--
-- Frontloader
-- Specialization class for John Deere 6140D
--
-- @author  Mario
-- @date  24/08/2010
--
-- Copyright (C) Mario, All Rights Reserved.

Frontloader = {};

function Frontloader.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Frontloader:load(xmlFile)
 
	self.dualsActive = false;

	self.duals = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.duals#index"));
	self.duals2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.duals#index2"));
	
end;

function Frontloader:delete()

end;

function Frontloader:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Frontloader:keyEvent(unicode, sym, modifier, isDown)


	if isDown and sym == Input.KEY_u then
		self.dualsActive = not self.dualsActive;
	end;
end;

function Frontloader:update(dt)
	setVisibility(self.duals, self.dualsActive);
	setVisibility(self.duals2, self.dualsActive);
end;

function Frontloader:draw()
	if self.isEntered then
		if not self.helpPanel then
			renderText(0.8335, 0.18, 0.021, "Press backslash: Info on");
		else
			renderText(0.8335, 0.18, 0.021, "Press backslash: Info off");
		end;
		if self.helpPanel then
			renderText(0.02, 0.60, 0.023, "- John Deere 6140D Info -");
			
			if self.dualsActive then
				renderText(0.02, 0.48, 0.021, "Press U: Rear/Front Dualies off");
			else
				renderText(0.02, 0.48, 0.021, "Press U: Rear Dualies on");
			end;
		end;
	end;
end;

function Frontloader:onEnter()
	
end;

function Frontloader:onLeave()

end;
