--
-- kolos
-- This is the specialization for combines
--
-- @author  Stefan Geiger
-- @date  30/11/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

kolos = {};

function kolos.prerequisitesPresent(specializations)
return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function kolos:load(xmlFile)


	local rotationPartNodeabl3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl3#index"));
    if rotationPartNodeabl3 ~= nil then
        self.rotationPartabl3 = {};
        self.rotationPartabl3.node = rotationPartNodeabl3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl3#minRot"));
        self.rotationPartabl3.minRot = {};
        self.rotationPartabl3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl3#maxRot"));
        self.rotationPartabl3.maxRot = {};
        self.rotationPartabl3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl3#rotTime"), 2)*1000;
        self.rotationPartabl3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl3#touchRotLimit"), 10));
    end;
local rotationPartNodeabl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl1#index"));
    if rotationPartNodeabl1 ~= nil then
        self.rotationPartabl1 = {};
        self.rotationPartabl1.node = rotationPartNodeabl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl1#minRot"));
        self.rotationPartabl1.minRot = {};
        self.rotationPartabl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl1#maxRot"));
        self.rotationPartabl1.maxRot = {};
        self.rotationPartabl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#rotTime"), 2)*1000;
        self.rotationPartabl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#touchRotLimit"), 10));
    end;
  local rotationPartNodeabl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl2#index"));
    if rotationPartNodeabl2 ~= nil then
        self.rotationPartabl2 = {};
        self.rotationPartabl2.node = rotationPartNodeabl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl2#minRot"));
        self.rotationPartabl2.minRot = {};
        self.rotationPartabl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl2#maxRot"));
        self.rotationPartabl2.maxRot = {};
        self.rotationPartabl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#rotTime"), 2)*1000;
        self.rotationPartabl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#touchRotLimit"), 10));
    end;

	
	local rotationPartNodeabl4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl4#index"));
    if rotationPartNodeabl4 ~= nil then
        self.rotationPartabl4 = {};
        self.rotationPartabl4.node = rotationPartNodeabl4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl4#minRot"));
        self.rotationPartabl4.minRot = {};
        self.rotationPartabl4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl4#maxRot"));
        self.rotationPartabl4.maxRot = {};
        self.rotationPartabl4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl4#rotTime"), 2)*1000;
        self.rotationPartabl4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl4#touchRotLimit"), 10));
    end;
	
	
	
local rotationPartNodeabl5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl5#index"));
    if rotationPartNodeabl5 ~= nil then
        self.rotationPartabl5 = {};
        self.rotationPartabl5.node = rotationPartNodeabl5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl5#minRot"));
        self.rotationPartabl5.minRot = {};
        self.rotationPartabl5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl5#maxRot"));
        self.rotationPartabl5.maxRot = {};
        self.rotationPartabl5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl5#rotTime"), 2)*1000;
        self.rotationPartabl5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl5#touchRotLimit"), 10));
    end;
	
	
	
		local rotationPartNodeabl6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl6#index"));
    if rotationPartNodeabl6 ~= nil then
        self.rotationPartabl6 = {};
        self.rotationPartabl6.node = rotationPartNodeabl6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl6#minRot"));
        self.rotationPartabl6.minRot = {};
        self.rotationPartabl6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl6#maxRot"));
        self.rotationPartabl6.maxRot = {};
        self.rotationPartabl6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl6#rotTime"), 2)*1000;
        self.rotationPartabl6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl6#touchRotLimit"), 10));
    end;
	
	
	
			local rotationPartNodeabl7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl7#index"));
    if rotationPartNodeabl7 ~= nil then
        self.rotationPartabl7 = {};
        self.rotationPartabl7.node = rotationPartNodeabl7;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl7#minRot"));
        self.rotationPartabl7.minRot = {};
        self.rotationPartabl7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl7#maxRot"));
        self.rotationPartabl7.maxRot = {};
        self.rotationPartabl7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl7#rotTime"), 2)*1000;
        self.rotationPartabl7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl7#touchRotLimit"), 10));
    end;
	
	
	
	
	
			local rotationPartNodeabl8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl8#index"));
    if rotationPartNodeabl8 ~= nil then
        self.rotationPartabl8 = {};
        self.rotationPartabl8.node = rotationPartNodeabl8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl8#minRot"));
        self.rotationPartabl8.minRot = {};
        self.rotationPartabl8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl8#maxRot"));
        self.rotationPartabl8.maxRot = {};
        self.rotationPartabl8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl8#rotTime"), 2)*1000;
        self.rotationPartabl8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl8#touchRotLimit"), 10));
    end;
	

	 
local translationNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translation2#index"));
      if translationNode2 ~= nil then
        self.translation2 = {};
        self.translation2.node = translationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#minTrans"));
        self.translation2.minTrans = {};
        self.translation2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#maxTrans"));
        self.translation2.maxTrans = {};
        self.translation2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translation2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation2#transTime"), 2)*1000;
        self.translation2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation2#touchTransLimit"), 10);
    end;
local translationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translation1#index"));
      if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
        self.translation1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#touchTransLimit"), 10);
    end;

	local translationNode7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translation7#index"));
      if translationNode7 ~= nil then
        self.translation7 = {};
        self.translation7.node = translationNode7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation7#minTrans"));
        self.translation7.minTrans = {};
        self.translation7.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation7.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation7.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation7#maxTrans"));
        self.translation7.maxTrans = {};
        self.translation7.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation7.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation7.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translation7.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation7#transTime"), 2)*1000;
        self.translation7.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation7#touchTransLimit"), 10);
    end;
	
	local translationNode6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translation6#index"));
      if translationNode6 ~= nil then
        self.translation6 = {};
        self.translation6.node = translationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation6#minTrans"));
        self.translation6.minTrans = {};
        self.translation6.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation6.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation6.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation6#maxTrans"));
        self.translation6.maxTrans = {};
        self.translation6.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation6.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation6.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translation6.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation6#transTime"), 2)*1000;
        self.translation6.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation6#touchTransLimit"), 10);
    end;
	
	
       self.gearShifter1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.gearShifter1#index"));
	   
	          self.gearShifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.gearShifter#index"));
	   
    self.gearShifter2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.gearShifter2#index"));

	      end;


function kolos:delete()
end;

function kolos:mouseEvent(posX, posY, isDown, isUp, button)
end;

function kolos:keyEvent(unicode, sym, modifier, isDown)

    	if sym == self.keys.jablakfel then
		self.translation1Max = isDown;
	end;
	if sym == self.keys.jablakle then
		self.translation1Min = isDown;
	end;
    	if sym == self.keys.bablakfel then
		self.translation2Max = isDown;
	end;
	if sym == self.keys.bablakle then
		self.translation2Min = isDown;
	end;


	
	  	if sym == self.keys.sidlev then
		self.translation7Max = isDown;
	end;
	if sym == self.keys.sidprav then
		self.translation7Min = isDown;
	end;
	
		
	  	if sym == self.keys.sidvverx then
		self.translation6Max = isDown;
	end;
	if sym == self.keys.sidvniz then
		self.translation6Min = isDown;
	end;


	end;
	
	





	
	
	
	
	
function kolos:update(dt)


	







local doTranslate = self.translation1Max or self.translation1Min 
	if self.translation1 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation1.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1Max); 
		setTranslation(self.translation1.node, unpack(newTrans)); 
	end; 
local doTranslate = self.translation2Max or self.translation2Min 
	if self.translation2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation2.maxTrans, self.translation2.minTrans, 3, self.translation2.transTime, dt, not self.translation2Max); 
		setTranslation(self.translation2.node, unpack(newTrans)); 
	end; 


if self.inrange or self.isEntered then
	if InputBinding.hasEvent (InputBinding.Dverlev) then
		self.rotationMaxabl1 = not self.rotationMaxabl1;
	end;
end;

if self.inrange or self.isEntered then
	if InputBinding.hasEvent (InputBinding.Dverprav) then
		self.rotationMaxabl2 = not self.rotationMaxabl2;
	end;
end;

if self.inrange then
	if InputBinding.hasEvent (InputBinding.reshetka) then
		self.rotationMaxabl3 = not self.rotationMaxabl3;
	end;
end;

if self.inrange then
	if InputBinding.hasEvent (InputBinding.kabinka) then
		self.rotationMaxabl4 = not self.rotationMaxabl4;
			self.rotationMaxabl5 = not self.rotationMaxabl5;
	end;
end;

	
	       if self.rotationPartabl1 ~= nil then
	   	
		   local x, y, z = getRotation(self.rotationPartabl1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl1.maxRot, self.rotationPartabl1.minRot, 3, self.rotationPartabl1.rotTime, dt, not self.rotationMaxabl1);
		   setRotation(self.rotationPartabl1.node, unpack(newRot));
	       end;
	   
	   

	   		    if self.rotationPartabl2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl2.maxRot, self.rotationPartabl2.minRot, 3, self.rotationPartabl2.rotTime, dt, not self.rotationMaxabl2);
		   setRotation(self.rotationPartabl2.node, unpack(newRot));
	       end;
	   
	   
	   
    if self.rotationPartabl3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl3.maxRot, self.rotationPartabl3.minRot, 3, self.rotationPartabl3.rotTime, dt, not self.rotationMaxabl3);
		   setRotation(self.rotationPartabl3.node, unpack(newRot));
        end;
   
       if self.rotationPartabl4 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl4.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl4.maxRot, self.rotationPartabl4.minRot, 3, self.rotationPartabl4.rotTime, dt, not self.rotationMaxabl4);
		   setRotation(self.rotationPartabl4.node, unpack(newRot));
  end;
   		    if self.rotationPartabl5 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl5.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl5.maxRot, self.rotationPartabl5.minRot, 3, self.rotationPartabl5.rotTime, dt, not self.rotationMaxabl5);
		   setRotation(self.rotationPartabl5.node, unpack(newRot));
        end;
     
  
      local doTranslate = self.translation7Max or self.translation7Min 
	if self.translation7 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation7.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation7.maxTrans, self.translation7.minTrans, 3, self.translation7.transTime, dt, not self.translation7Max); 
		setTranslation(self.translation7.node, unpack(newTrans)); 
	end; 
local doTranslate = self.translation6Max or self.translation6Min 
	if self.translation6 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation6.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation6.maxTrans, self.translation6.minTrans, 3, self.translation6.transTime, dt, not self.translation6Max); 
		setTranslation(self.translation6.node, unpack(newTrans)); 
	end; 


   
   
   
   

   
   

   local speed = self.lastSpeed*3600;
	if self.gearShifter ~= nil then
		if self.movingDirection < 0 then
			setRotation(self.gearShifter, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(7));
		else	
		if speed >= -0.5 and speed < 0.5 then
			setRotation(self.gearShifter, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
		elseif speed >= 0.5 and speed < 7 then
			setRotation(self.gearShifter, Utils.degToRad(15), Utils.degToRad(0), Utils.degToRad(-5));
		elseif speed >= 7 and speed < 20 then
			setRotation(self.gearShifter, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(-5));
		elseif speed >= 20 and speed < 45 then
			setRotation(self.gearShifter, Utils.degToRad(15), Utils.degToRad(0), Utils.degToRad(0));
		    elseif speed >= 45 then
			setRotation(self.gearShifter, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(0));
		end;
		end;
	end;
   
      	if self.gearShifter2 ~= nil then
		if self.fuelFillLevel < 0 then
			setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(50), Utils.degToRad(0));
			else
		if self.fuelFillLevel >= 0 and self.fuelFillLevel < 5 then
			setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(50), Utils.degToRad(0));
		elseif self.fuelFillLevel >= 20 and self.fuelFillLevel < 40 then
			setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(36), Utils.degToRad(0));
		elseif self.fuelFillLevel >= 40 and self.fuelFillLevel < 60 then
			setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(18), Utils.degToRad(0));
		elseif self.fuelFillLevel >= 60 and self.fuelFillLevel < 80 then
				setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(5), Utils.degToRad(0));
		elseif self.fuelFillLevel >= 80 and self.fuelFillLevel < 100 then
			setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(-5), Utils.degToRad(0));
		elseif self.fuelFillLevel >= 100 and self.fuelFillLevel < 120 then
			setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(20), Utils.degToRad(0));
		elseif self.fuelFillLevel >= 120 and self.fuelFillLevel < 150 then
			setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(-36), Utils.degToRad(0));
		elseif self.fuelFillLevel >= 150 then
			setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(-45), Utils.degToRad(0));
		end;
		end;
	end;
   
 

   
   
   
     local speed = self.lastSpeed*3600;
	if self.gearShifter1 ~= nil then
	if speed >= -0.5 and speed < 0.5 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(-20), Utils.degToRad(0));
								elseif speed >= 0 and speed < 2 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(-18), Utils.degToRad(0));
					elseif speed >= 2 and speed < 4 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(-16), Utils.degToRad(0));
					elseif speed >= 4 and speed < 6 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(-14), Utils.degToRad(0));
					elseif speed >= 6 and speed < 8 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(-12), Utils.degToRad(0));
					elseif speed >= 8 and speed < 10 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(-10), Utils.degToRad(0));
					elseif speed >= 10 and speed < 12 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(-8), Utils.degToRad(0));
					elseif speed >= 12 and speed < 14 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(-6), Utils.degToRad(0));
					elseif speed >= 14 and speed < 16 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(-4), Utils.degToRad(0));
					elseif speed >= 16 and speed < 18 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(-2), Utils.degToRad(0));
					elseif speed >= 18 and speed < 20 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
					elseif speed >= 20 and speed < 22 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(5), Utils.degToRad(0));
					elseif speed >= 22 and speed < 24 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(10), Utils.degToRad(0));
					elseif speed >= 24 and speed < 26 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(15), Utils.degToRad(0));
					elseif speed >= 26 and speed < 28 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(20), Utils.degToRad(0));
					elseif speed >= 28 and speed < 30 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(25), Utils.degToRad(0));
					elseif speed >= 30 and speed < 32 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(30), Utils.degToRad(0));
					elseif speed >= 32 and speed < 34 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(35), Utils.degToRad(0));
					elseif speed >= 34 and speed < 36 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(40), Utils.degToRad(0));
					elseif speed >= 36 and speed < 38 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(45), Utils.degToRad(0));
					elseif speed >= 38 and speed < 40 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(50), Utils.degToRad(0));
					elseif speed >= 40 and speed < 42 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(54), Utils.degToRad(0));
					elseif speed >= 42 and speed < 44 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(58), Utils.degToRad(0));
					elseif speed >= 44 and speed < 46 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(62), Utils.degToRad(0));
					elseif speed >= 46 and speed < 48 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(66), Utils.degToRad(0));
					elseif speed >= 48 and speed < 50 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(70), Utils.degToRad(0));
					elseif speed >= 50 and speed < 52 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(74), Utils.degToRad(0));
					elseif speed >= 52 and speed < 54 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(78), Utils.degToRad(0));
					elseif speed >= 54 and speed < 56 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(82), Utils.degToRad(0));
					elseif speed >= 56 and speed < 58 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(86), Utils.degToRad(0));
					elseif speed >= 58 and speed < 60 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(90), Utils.degToRad(0));
					elseif speed >= 60 and speed < 62 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(94), Utils.degToRad(0));
					elseif speed >= 62 and speed < 64 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(98), Utils.degToRad(0));
					elseif speed >= 64 and speed < 66 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(102), Utils.degToRad(0));
					elseif speed >= 66 and speed < 68 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(104), Utils.degToRad(0));
					elseif speed >= 68 and speed < 70 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(108), Utils.degToRad(0));
					elseif speed >= 70 and speed < 72 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(110), Utils.degToRad(0));
					elseif speed >= 72 and speed < 74 then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(114), Utils.degToRad(0));
					elseif speed >= 74  then
			setRotation(self.gearShifter1, Utils.degToRad(0), Utils.degToRad(114), Utils.degToRad(0));
		end;
	end;
end;
                                   
  

  

  
  
  

  
  
  
  


function kolos:draw()

end;

function kolos:onEnter()
end;

function kolos:onLeave()
end;

function kolos:updateTick(dt)





if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 10.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;
end;
