--MMZ_4502
--powered by hz888
--hz888@freemail.hu

MMZ_4502 = {};

function MMZ_4502.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function MMZ_4502:load(xmlFile)


    local brakeSound = getXMLString(xmlFile, "vehicle.brakeSound#file");
    if brakeSound ~= nil and brakeSound ~= "" then
        brakeSound = Utils.getFilename(brakeSound, self.baseDirectory);
        self.brakeSound = createSample("brakeSound");
        self.brakeSoundEnabled = false;
        loadSample(self.brakeSound, brakeSound, false);
        self.brakeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeSound#pitchOffset"), 1);
        self.brakeSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeSound#volume"), 1);
    end;


	handbrakeSoundFile = Utils.getFilename("handbrake.wav", self.baseDirectory);
	self.handbrakeSoundId = createSample("handbrakeSound");
	loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);

	turn1SoundFile = Utils.getFilename("turn1.wav", self.baseDirectory);
	self.turn1SoundId = createSample("turn1Sound");
	loadSample(self.turn1SoundId, turn1SoundFile, false);

	turn2SoundFile = Utils.getFilename("turn2.wav", self.baseDirectory);
	self.turn2SoundId = createSample("turn2Sound");
	loadSample(self.turn2SoundId, turn2SoundFile, false);


    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

    self.numFarlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.farlights#count"), 0);
    self.farlights = {};
    for i=1, self.numFarlights do
        local farlightnamei = string.format("vehicle.farlights.farlight" .. "%d", i);
        self.farlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, farlightnamei .. "#index"));
        setVisibility(self.farlights[i], false);
    end;

    self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;

    self.numFlashlightsLeft = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.flashlightsLeft#count"), 0);
    self.flashlightsLeft = {};
    for i=1, self.numFlashlightsLeft do
        local flashlightLeftnamei = string.format("vehicle.flashlightsLeft.flashlightLeft" .. "%d", i);
        self.flashlightsLeft[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, flashlightLeftnamei .. "#index"));
        setVisibility(self.flashlightsLeft[i], false);
    end;
	
    self.numFlashlightsRight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.flashlightsRight#count"), 0);
    self.flashlightsRight = {};
    for i=1, self.numFlashlightsRight do
        local flashlightRightnamei = string.format("vehicle.flashlightsRight.flashlightRight" .. "%d", i);
        self.flashlightsRight[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, flashlightRightnamei .. "#index"));
        setVisibility(self.flashlightsRight[i], false);
    end;

    self.farlightsActive = false;
    self.frontlightsActive = false;
    self.lightsActive = false;
    self.brakelightsActive = false;
    self.flashlightsLeftActive = false;
    self.flashlightsRightActive = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayOn = 0;
    self.delayOff = 0;

end;

function MMZ_4502:delete()

    if self.brakeSound ~= nil then
        delete(self.brakeSound);
    end;

end;

function MMZ_4502:mouseEvent(posX, posY, isDown, isUp, button)

end;

function MMZ_4502:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == (self.keys.kezifek) then
		self.handbrake = not self.handbrake
		if self.handbrake then
		playSample(self.handbrakeSoundId, 1, 1, 0);
		end;
	end;

	if isDown and sym == (self.keys.tavolsagi) and self.light then
		self.farlightsActive = not self.farlightsActive;
	end;

	if isDown and sym == 96 then
		self.helpPanel = not self.helpPanel;
	end;

	if isDown and sym == (self.keys.indexL) then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
	end;
	if isDown and sym == (self.keys.indexR) then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
	end;
	if isDown and sym == (self.keys.elakadas) then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
	end;

end;

function MMZ_4502:update(dt)

            self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

            if InputBinding.isAxisZero(self.input) then
                self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
            end;


            if self.brakeSound ~= nil then
		if self.movingDirection > 0 then
                	if -self.input > 0.001 and self.brakeSoundEnabled then
                    		self.brakeSoundEnabled = false;
                	end;

                	if -self.input < -0.001 and not self.brakeSoundEnabled then
                    		if self:getIsActiveForSound() then
                        		playSample(self.brakeSound, 1, self.brakeSoundVolume, 0);
                        		setSamplePitch(self.brakeSound, self.brakeSoundPitchOffset);
					self.motor.brakeForce = 50;
                    		end;
                    		self.brakeSoundEnabled = true;
			end;
                end;
		if self.movingDirection < 0 then
                	if -self.input < -0.001 and self.brakeSoundEnabled then
                    		self.brakeSoundEnabled = false;
                	end;

                	if -self.input > 0.001 and not self.brakeSoundEnabled then
                    		if self:getIsActiveForSound() then
                        		playSample(self.brakeSound, 1, self.brakeSoundVolume, 0);
                        		setSamplePitch(self.brakeSound, self.brakeSoundPitchOffset);
					self.motor.brakeForce = 50;
                    		end;
                    		self.brakeSoundEnabled = true;
			end;
                end;
            end;


    if self.isEntered then

       
	if self.handbrake then
		self.motor.backwardGearRatio = 0;
		self.motor.forwardGearRatios = {0, 0, 0};
		self.motor.brakeForce = 100;
   		self.brakelightsActive = true;		
	else

		if -self.input < -0.001 and self.movingDirection > 0 then
			self.brakelightsActive = true;
			self.motor.brakeForce = -self.input*-50;
		elseif -self.input > 0.001 and self.movingDirection < 0 then
    			self.brakelightsActive = true;
			self.motor.brakeForce = -self.input*25;
		else
			self.brakelightsActive = false;
			self.motor.brakeForce = 10;
		end;
		self.motor.backwardGearRatio = 1.5;
		self.motor.forwardGearRatios = {2, 2, 2};
	end;

        if InputBinding.hasEvent(InputBinding.TOGGLE_LIGHTS) then
			self.light = not self.light;
	end;

		if self.light then
			setTextBold(true);
			setTextColor(0,1,0,1);
			renderText(0.804, 0.17, 0.026, "=");
			renderText(0.8, 0.172, 0.026, "(");
		else
			self.farlightsActive = false;
		end;

		if self.farlightsActive then
			for i=1, self.numFarlights do
				local farlight = self.farlights[i];
				setVisibility(farlight, self.farlightsActive);
				setTextColor(0,0,1,1);
				renderText(0.804, 0.17, 0.026, "=");
				renderText(0.8, 0.172, 0.026, "(");
			end;
		else
			for i=1, self.numFarlights	do
				local farlight = self.farlights[i];
				setVisibility(farlight, self.farlightsActive, false);
			end;
		end;

		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;

		if self.flashlightsLeftActive then
			for i=1, self.numFlashlightsLeft do
				local flashlightLeft = self.flashlightsLeft[i];
				setVisibility(flashlightLeft, self.flashlightsLeftActive);
			end;
		else
			for i=1, self.numFlashlightsLeft do
				local flashlightLeft = self.flashlightsLeft[i];
				setVisibility(flashlightLeft, self.flashlightsLeftActive, false);
			end;
		end;
	
		if self.flashlightsRightActive then
			for i=1, self.numFlashlightsRight do
				local flashlightRight = self.flashlightsRight[i];
				setVisibility(flashlightRight, self.flashlightsRightActive);
			end;
		else
			for i=1, self.numFlashlightsRight do
				local flashlightRight = self.flashlightsRight[i];
				setVisibility(flashlightRight, self.flashlightsRightActive, false);
			end;
		end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;

		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashlightsRightActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashlightsRightActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;

		if self.flash then
			if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOn < 0 then
					self.delayOff = 500;
					self.flashlightsRightActive = true;
					self.flashlightsLeftActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOff >= 0 then
				self.delayOff = self.delayOff -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOff < 0 then
					self.delayOn = 500;
					self.flashlightsLeftActive = false;
					self.flashlightsRightActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;

		if not self.flashLeft and not self.flashRight then
			if not self.flash then
				self.flashlightsRightActive = false;
				self.flashlightsLeftActive = false;
			end;
		end;
		
		if not self.flash and not self.flashLeft then
			if not self.flashRight then
				self.flashlightsRightActive = false;
			end;
		end;

		if not self.flash and not self.flashRight then
			if not self.flashLeft then
				self.flashlightLeftActive = false;
			end;
		end;

	if not self.helpPanel then
		setTextBold(true);
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.17, 0.021, "0: Info be");
	else
		setTextBold(true);
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.17, 0.021, "0: Info ki");
	end;
	if self.helpPanel then
		renderText(0.02, 0.50, 0.023, "MMZ_4502 info");
		renderText(0.02, 0.48, 0.021, "F5/f6: dveri");
		renderText(0.02, 0.46, 0.021, "f7: kapot");
		renderText(0.02, 0.44, 0.021, "SPACE: ruchnik");
		renderText(0.02, 0.42, 0.021, "num_enter*2: zavesti");
		renderText(0.02, 0.38, 0.021, "f2-f4: povoroti");
		end;

    end;

end;

function MMZ_4502:draw()

	if self.handbrake then
		setTextBold(true);
		setTextColor(1,0,0,1);
		if self.input == -1 then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.3, 0.3, 0.05, "ROGZITOFEK KIENGED!");
		end;
	end;



end;

function MMZ_4502:onEnter()

end;

function MMZ_4502:onLeave()

    self.farlightsActive = false;
    self.frontlightsActive = false;
    self.lightsActive = false;
    self.handbrake = false;
    self.brakelightsActive = false;
    self.handbrakelightsActive = false;
    self.helpPanel = false;
    self.cameras[self.camIndex]:onDeactivate();
    self.motor.brakeForce = 100;
    self.flashlightsRightActive = false;
    self.flashlightsLeftActive = false;
	for i=1, self.numFarlights	do
		local farlight = self.farlights[i];
		setVisibility(farlight, self.farlightsActive, false);
	end;
	for i=1, self.numbrakelights do
		local brakelight = self.brakelights[i];
		setVisibility(brakelight, self.brakelightsActive, false);
	end;
	for i=1, self.numFlashlightsLeft do
		local flashlightLeft = self.flashlightsLeft[i];
		setVisibility(flashlightLeft, self.flashlightsLeftActive, false);
	end;
	for i=1, self.numFlashlightsRight do
		local flashlightRight = self.flashlightsRight[i];
		setVisibility(flashlightRight, self.flashlightsRightActive, false);
	end;

end;