--
-- Abstuetzung
--
-- M@D Author     Gorli
-- M@D date  03.05.2009
--
-- > Copyright (C) Gorli< --


Abstuetzung = {}

function Abstuetzung.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Abstuetzung:load(xmlFile)
	
	local translationPartNode11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart11#index"));
    if translationPartNode11 ~= nil then
        self.translationPart11 = {};
        self.translationPart11.node = translationPartNode11;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart11#minTrans"));
        self.translationPart11.minTrans = {};
        self.translationPart11.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart11.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart11.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart11#maxTrans"));
        self.translationPart11.maxTrans = {};
        self.translationPart11.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart11.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart11.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart11.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart12#transTime"), 2)*1000;
        self.translationPart11.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart12#touchTransLimit"), 10);
    end;
    local translationPartNode12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart12#index"));
    if translationPartNode12 ~= nil then
        self.translationPart12 = {};
        self.translationPart12.node = translationPartNode12;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart12#minTrans"));
        self.translationPart12.minTrans = {};
        self.translationPart12.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart12.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart12.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart12#maxTrans"));
        self.translationPart12.maxTrans = {};
        self.translationPart12.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart12.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart12.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart12.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart12#transTime"), 2)*1000;
        self.translationPart12.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart12#touchTransLimit"), 10);
    end; 
    local translationPartNode13 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart13#index"));
    if translationPartNode13 ~= nil then
        self.translationPart13 = {};
        self.translationPart13.node = translationPartNode13;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart13#minTrans"));
        self.translationPart13.minTrans = {};
        self.translationPart13.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart13.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart13.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart13#maxTrans"));
        self.translationPart13.maxTrans = {};
        self.translationPart13.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart13.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart13.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart13.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart13#transTime"), 2)*1000;
        self.translationPart13.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart13#touchTransLimit"), 10);
    end;
    local translationPartNode14 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart14#index"));
    if translationPartNode14 ~= nil then
        self.translationPart14 = {};
        self.translationPart14.node = translationPartNode14;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart14#minTrans"));
        self.translationPart14.minTrans = {};
        self.translationPart14.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart14.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart14.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart14#maxTrans"));
        self.translationPart14.maxTrans = {};
        self.translationPart14.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart14.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart14.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart14.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart14#transTime"), 2)*1000;
        self.translationPart14.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart14#touchTransLimit"), 10);
    end; 
    
 
	local rotationNode11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation11#index"));
    if rotationNode11 ~= nil then
        self.rotation11 = {};
        self.rotation11.node = rotationNode11;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation11#minRot"));
        self.rotation11.minRot = {};
        self.rotation11.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation11.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation11.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation11#maxRot"));
        self.rotation11.maxRot = {};
        self.rotation11.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation11.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation11.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation11.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation11#rotTime"), 2)*1000;
        self.rotation11.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation11#touchRotLimit"), 10));
    end;
	
	local rotationNode12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation12#index"));
    if rotationNode12 ~= nil then
        self.rotation12 = {};
        self.rotation12.node = rotationNode12;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation12#minRot"));
        self.rotation12.minRot = {};
        self.rotation12.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation12.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation12.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation12#maxRot"));
        self.rotation12.maxRot = {};
        self.rotation12.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation12.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation12.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation12.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation12#rotTime"), 2)*1000;
        self.rotation12.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation12#touchRotLimit"), 10));
    end;
    local rotationNode13 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation13#index"));
    if rotationNode13 ~= nil then
        self.rotation13 = {};
        self.rotation13.node = rotationNode13;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation13#minRot"));
        self.rotation13.minRot = {};
        self.rotation13.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation13.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation13.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation13#maxRot"));
        self.rotation13.maxRot = {};
        self.rotation13.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation13.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation13.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation13.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation13#rotTime"), 2)*1000;
        self.rotation13.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation13#touchRotLimit"), 10));
    end;
    local rotationNode14 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation14#index"));
    if rotationNode14 ~= nil then
        self.rotation14 = {};
        self.rotation14.node = rotationNode14;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation14#minRot"));
        self.rotation14.minRot = {};
        self.rotation14.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation14.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation14.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation14#maxRot"));
        self.rotation14.maxRot = {};
        self.rotation14.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation14.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation14.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation14.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation14#rotTime"), 2)*1000;
        self.rotation14.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation14#touchRotLimit"), 10));
    end;

end;
      
function Abstuetzung:delete()
end;

function Abstuetzung:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Abstuetzung:keyEvent(unicode, sym, modifier, isDown)

    if sym == Input.KEY_o then
		self.translationMax11 = isDown;
		self.translationMax12 = isDown;
		self.translationMax13 = isDown;
		self.translationMax14 = isDown;
	end;
	if sym == Input.KEY_u then
		self.translationMin11 = isDown;
		self.translationMin12 = isDown;
		self.translationMin13 = isDown;
		self.translationMin14 = isDown;
	end;
	if sym == Input.KEY_g then
		self.rotation11Max = isDown;
	end;
	if sym == Input.KEY_v then
		self.rotation11Min = isDown;
	end;
	if sym == Input.KEY_h then
		self.rotation12Max = isDown;
	end;
	if sym == Input.KEY_b then
		self.rotation12Min = isDown;
	end;
	if sym == Input.KEY_j then
		self.rotation13Max = isDown;
	end;
	if sym == Input.KEY_n then
		self.rotation13Min = isDown;
		end;
	if sym == Input.KEY_k then
		self.rotation14Max = isDown;
	end;
	if sym == Input.KEY_m then
		self.rotation14Min = isDown;
	end;

end;

function Abstuetzung:update(dt)
	
	local doTranslate = self.translationMax11 or self.translationMin11
	if self.translationPart11 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart11.node);
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart11.maxTrans, self.translationPart11.minTrans, 3, self.translationPart11.transTime, dt, not self.translationMax11);
		setTranslation(self.translationPart11.node, unpack(newTrans));
	end; 
	local doTranslate = self.translationMax12 or self.translationMin12
	if self.translationPart12 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart12.node);
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart12.maxTrans, self.translationPart12.minTrans, 3, self.translationPart12.transTime, dt, not self.translationMax12);
		setTranslation(self.translationPart12.node, unpack(newTrans));
	end;
	local doTranslate = self.translationMax13 or self.translationMin13
	if self.translationPart13 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart13.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart13.maxTrans, self.translationPart13.minTrans, 3, self.translationPart13.transTime, dt, not self.translationMax13);
		setTranslation(self.translationPart13.node, unpack(newTrans));
	end;
	local doTranslate = self.translationMax14 or self.translationMin14
	if self.translationPart14 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart14.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart14.maxTrans, self.translationPart14.minTrans, 3, self.translationPart14.transTime, dt, not self.translationMax14);
		setTranslation(self.translationPart14.node, unpack(newTrans));
	end;

	local doRotate = self.rotation11Max or self.rotation11Min
	if self.rotation11 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation11.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation11.maxRot, self.rotation11.minRot, 3, self.rotation11.rotTime, dt, not self.rotation11Max);
        setRotation(self.rotation11.node, unpack(newRot));
    end;
	
	local doRotate = self.rotation12Max or self.rotation12Min
	if self.rotation12 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation12.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation12.maxRot, self.rotation12.minRot, 3, self.rotation12.rotTime, dt, not self.rotation12Max);
        setRotation(self.rotation12.node, unpack(newRot));
    end;
    local doRotate = self.rotation13Max or self.rotation13Min
	if self.rotation13 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation13.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation13.maxRot, self.rotation13.minRot, 3, self.rotation13.rotTime, dt, not self.rotation13Max);
        setRotation(self.rotation13.node, unpack(newRot));
    end;
    local doRotate = self.rotation14Max or self.rotation14Min
	if self.rotation14 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation14.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation14.maxRot, self.rotation14.minRot, 3, self.rotation14.rotTime, dt, not self.rotation14Max);
        setRotation(self.rotation14.node, unpack(newRot));
    end;
end;

function Abstuetzung:draw()
end;


