--
-- ExtraLightSources
-- Specialization for ExtraLightSources
--
-- @author:  	Manuel Leithner
-- @date:		20/10/10
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
--

ExtraLightSources = {};

function ExtraLightSources.prerequisitesPresent(specializations)
    return true
end;

function ExtraLightSources:load(xmlFile)

	self.setLightState = SpecializationUtil.callSpecializationsFunction("setLightState");
	
	local numLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.lightSources#count"), 0);
    self.lightsSource = {};
    for i=1, numLights do
        local lightnamei = string.format("vehicle.lightSources.source%d", i);
		self.lightsSource[i] = {};
		self.lightsSource[i].lights = Utils.indexToObject(self.components, getXMLString(xmlFile, lightnamei .. "#lights"));
        setVisibility(self.lightsSource[i].node, false);
    end;

	self.currentLight = 0;	
end;

function ExtraLightSources:delete()
end;

function ExtraLightSources:readStream(streamId, connection)
	self:setLightState(streamReadInt8(streamId), true);
end;

function ExtraLightSources:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.currentLight);
end;

function ExtraLightSources:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ExtraLightSources:keyEvent(unicode, sym, modifier, isDown)
end;

function ExtraLightSources:update(dt)
end;

function ExtraLightSources:updateTick(dt)
end;

function ExtraLightSources:draw()
end;

-- state 0: disabled
-- state 1: normal light
-- state 2: front light
-- state 3: back light
-- state 4: front and back light
-- state 5 : normal and back light
function ExtraLightSources:setLightState(state, noEventSend)
	--LightStateEvent.sendEvent(self, state, noEventSend);

	if state >= 0 and state <= table.getn(self.lightsSource) then
		if self.currentLight > 0 then
			setVisibility(self.lightsSource[self.currentLight].lights, false);
		end;
		if state > 0 then
			if self:getIsActiveForSound() then
				setVisibility(self.lightsSource[state].lights, true);
			end;
		end;
		self.currentLight = state;		
	else
		print("Error: given light state not available");
	end;
	return state;
end;

function ExtraLightSources:onLeave()
    if self.deactivateLightsOnLeave then
        self:setLightState(0, true);
    end;
end;