SetExtendWheelRightEvent = {};
SetExtendWheelRightEvent_mt = Class(SetExtendWheelRightEvent, Event);
  
InitEventClass(SetExtendWheelRightEvent, "SetExtendWheelRightEvent");
  
function SetExtendWheelRightEvent:emptyNew()
      local self = Event:new(SetExtendWheelRightEvent_mt);
      self.className="SetExtendWheelRightEvent";
      return self;
 end;

function SetExtendWheelRightEvent:new(object, translationMaxRight)
      local self = SetExtendWheelRightEvent:emptyNew()
      self.object = object;
      self.translationMaxRight = translationMaxRight;
      return self;
end;
 
function SetExtendWheelRightEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.translationMaxRight = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetExtendWheelRightEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.translationMaxRight);
end;
 
function SetExtendWheelRightEvent:run(connection)
      self.object:setTranslationMaxRight(self.translationMaxRight, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetExtendWheelRightEvent:new(self.object, self.translationMaxRight), nil, connection, self.object);
      end;
end;