SetExtendWheelLeftEvent = {};
SetExtendWheelLeftEvent_mt = Class(SetExtendWheelLeftEvent, Event);
  
InitEventClass(SetExtendWheelLeftEvent, "SetExtendWheelLeftEvent");
  
function SetExtendWheelLeftEvent:emptyNew()
      local self = Event:new(SetExtendWheelLeftEvent_mt);
      self.className="SetExtendWheelLeftEvent";
      return self;
 end;

function SetExtendWheelLeftEvent:new(object, translationMaxLeft)
      local self = SetExtendWheelLeftEvent:emptyNew()
      self.object = object;
      self.translationMaxLeft = translationMaxLeft;
      return self;
end;
 
function SetExtendWheelLeftEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.translationMaxLeft = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetExtendWheelLeftEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.translationMaxLeft);
end;
 
function SetExtendWheelLeftEvent:run(connection)
      self.object:setTranslationMaxLeft(self.translationMaxLeft, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetExtendWheelLeftEvent:new(self.object, self.translationMaxLeft), nil, connection, self.object);
      end;
end;