-- 
-- by PeterJ (03/02/2011)
--  

ExtendWheels = {};

function ExtendWheels.prerequisitesPresent(specializations)

    return true;
end;

function ExtendWheels:load(xmlFile)
     self.setTranslationMaxLeft = SpecializationUtil.callSpecializationsFunction("setTranslationMaxLeft");
     self.setTranslationMaxRight = SpecializationUtil.callSpecializationsFunction("setTranslationMaxRight");
	 
	
		
		local translationPartNodeLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPartLeft#index"));
		if translationPartNodeLeft ~= nil then
        self.translationPartLeft = {};
        self.translationPartLeft.node = translationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartLeft#minTrans"));
        self.translationPartLeft.minTrans = {};
        self.translationPartLeft.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartLeft.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartLeft.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartLeft#maxTrans"));
        self.translationPartLeft.maxTrans = {};
        self.translationPartLeft.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartLeft.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartLeft.maxTrans[3] = Utils.getNoNil(z, 0);
		self.translationPartLeft.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartLeft#transTime"), 2)*1000;
        self.translationPartLeft.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartLeft#touchTransLimit"), 10);
    end;
	  local translationPartNodeRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPartRight#index"));
		if translationPartNodeRight ~= nil then
        self.translationPartRight = {};
        self.translationPartRight.node = translationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRight#minTrans"));
        self.translationPartRight.minTrans = {};
        self.translationPartRight.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRight#maxTrans"));
        self.translationPartRight.maxTrans = {};
        self.translationPartRight.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartRight.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRight#transTime"), 2)*1000;
        self.translationPartRight.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRight#touchTransLimit"), 10);
    end;

		self.translationMaxLeft = false;
		self.translationMaxRight = false;
end;

function ExtendWheels:readStream(streamId, connection)
     self.translateMax = streamReadBool(streamId);
     if self.translationPartLeft ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setTranslation(self.translationPartLeft.node, x, y, z);
      end;
     if self.translationPartRight ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setTranslation(self.translationPartRight.node, x, y, z);
      end;
end;
  
function ExtendWheels:writeStream(streamId, connection)
      streamWriteBool(streamId, self.translateMax);
		if self.translationPartLeft ~= nil then
          local x, y, z = getTranslation(self.translationPartLeft.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.translationPartRight ~= nil then
          local x, y, z = getTranslation(self.translationPartRight.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function ExtendWheels:delete()

end;

function ExtendWheels:keyEvent(unicode, sym, modifier, isDown)


end;

function ExtendWheels:update(dt)
      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.EXTENDWHEEL) then
				self:setTranslationMaxLeft(not self.translationMaxLeft);
          end;
          if InputBinding.hasEvent(InputBinding.EXTENDWHEEL) then
				self:setTranslationMaxRight(not self.translationMaxRight);
          end;
		  
     end;
end;

function ExtendWheels:updateTick(dt)
	if self:getIsActive() and self.isClient then
			if self.translationPartLeft ~= nil then
				local x, y, z = getTranslation(self.translationPartLeft.node);
				local trans = {x,y,z};
				local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartLeft.maxTrans, self.translationPartLeft.minTrans, 3, self.translationPartLeft.transTime, dt, not self.translationMaxLeft);
				setTranslation(self.translationPartLeft.node, unpack(newTrans));
			end;
			if self.translationPartRight ~= nil then
				local x, y, z = getTranslation(self.translationPartRight.node);
				local trans = {x,y,z};
				local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartRight.maxTrans, self.translationPartRight.minTrans, 3, self.translationPartRight.transTime, dt, not self.translationMaxRight);
				setTranslation(self.translationPartRight.node, unpack(newTrans));
			end;
		
	end;		
end;

function ExtendWheels:draw()

  
end;


function ExtendWheels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ExtendWheels:setTranslationMaxLeft(translationMaxLeft, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetExtendWheelLeftEvent:new(self, translationMaxLeft), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetExtendWheelLeftEvent:new(self, translationMaxLeft));
          end;
      end;
      self.translationMaxLeft = translationMaxLeft;
end;

function ExtendWheels:setTranslationMaxRight(translationMaxRight, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
			  g_server:broadcastEvent(SetExtendWheelRightEvent:new(self, translationMaxRight), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetExtendWheelRightEvent:new(self, translationMaxRight));
          end;
      end;
      self.translationMaxRight = translationMaxRight;
end;