--
-- myWorklights
-- Specialization for workLights.
--
-- @author  Templaer
-- @date  25/04/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

myWorklights = {};

function myWorklights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function myWorklights:load(xmlFile)
	local numWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workLights#count"), 0);
    self.workLights = {};
    for i=1, numWorkLights do
        local worklightnamei = string.format("vehicle.workLights.workLight%d", i);
        self.workLights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.workLights[i], false);
    end;
	self.workLightsActive = false;
end;

function myWorklights:delete()
	for k, worklight in pairs(self.workLights) do
		setVisibility(worklight, false);
	end;
	self.workLightsActive = false;
end;

function myWorklights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function myWorklights:keyEvent(unicode, sym, modifier, isDown)
end;

function myWorklights:update(dt)
	if self.isEntered then
	
		if InputBinding.hasEvent(InputBinding.MYWORKLIGHTS) then
			self.workLightsActive = not self.workLightsActive;
		end;
	
		for k, worklight in pairs(self.workLights) do
			setVisibility(worklight, self.workLightsActive);
		end;
		
	end;
end;

function myWorklights:onLeave()
	for k, worklight in pairs(self.workLights) do
		setVisibility(worklight, false);
	end;
	self.workLightsActive = false;
end;

function myWorklights:draw()
end;

