--
-- manualIgnition
-- Specialization for manual Motor Ignition
--
-- @author  Templaer
-- @date  01/05/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

manualIgnition = {};

function manualIgnition.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function manualIgnition:load(xmlFile)
	self.startMotorManually = SpecializationUtil.callSpecializationsFunction("startMotorManually");
	self.stopMotorManually = SpecializationUtil.callSpecializationsFunction("stopMotorManually");
	self.updateStats = SpecializationUtil.callSpecializationsFunction("updateStats");
	self.applyBrakes = SpecializationUtil.callSpecializationsFunction("applyBrakes");

    self.ignitionKey = false;
	self.allowedIgnition = false;  
	
	self.fuelConsumption = 0;
	self.distanceDriven = 0;
	self.fuelUsed = 0;
	self.runningTime = 0;	
	
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
end;

function manualIgnition:delete()
end;

function manualIgnition:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manualIgnition:keyEvent(unicode, sym, modifier, isDown)
end;

function manualIgnition:update(dt)
	if self.isMotorStarted then
		self:updateStats(dt);
	end;
	
    if not self.isAITractorActivated then
	
        if self:getIsActiveForInput() then
		
            if InputBinding.hasEvent(InputBinding.IGNITION) then
		        self.ignitionKey = not self.ignitionKey;
			    self.allowedIgnition = true;
	        end;
			
			if math.abs(self.input) > 0.3 and self.isMotorStarted == false then
			    self.ignitionKey = true;
				self.allowedIgnition = true;
			end;
			
	    end;
		
	    if not self.ignitionKey or not self.deactivateOnLeave then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;
								
        if self.ignitionKey and self.allowedIgnition then	
			self:startMotorManually();
		elseif not self.ignitionKey and self.allowedIgnition then
			self:stopMotorManually();
		end;
		
    elseif not self.ignitionKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;
end;

function manualIgnition:onLeave()
    if not self.deactivateOnLeave then
	
	    Utils.setEmittingState(self.exhaustParticleSystems, true)
		self.isMotorStarted = true;
		self.ignitionKey = true; 
		self:applyBrakes();
		
	else
	
		self.isMotorStarted = false;
		self.ignitionKey = false;
		
	end;	
	setVisibility(self.aiMotorSound, not self.deactivateOnLeave);
end;

function manualIgnition:startMotorManually()
	self:startMotor();
	self.allowedIgnition = false;
	self.deactivateOnLeave = false;
	self.steeringEnabled = true;
	
	if self.powershiftLevel ~= nil then
		self:resetStartingGear();
	end;
end;

function manualIgnition:stopMotorManually()
	if self.motorStopSoundVolume == 0 then
		self.motorStopSoundVolume = self.motorStopSoundVolume2;
	end;
	self:applyBrakes();
	self:onDeactivateAttachements();
	self:stopMotor();
	self.allowedIgnition = false;
	self.steeringEnabled = false;
	self.cruiseControl = false;
	self.deactivateOnLeave = true;
end;

function manualIgnition:applyBrakes()
	for k,wheel in pairs(self.wheels) do
		setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
	end;
end;

function manualIgnition:updateStats(dt)
	local kmMs = self.lastSpeed*self.speedDisplayScale / 1000;
	self.distanceDriven = self.distanceDriven + (kmMs * dt);
	self.runningTime = self.runningTime + (dt / 1000 / 60 / 60);
	self.fuelConsumption = (self.lastMovedDistance*self.fuelUsage / dt) * 1000 * 60 * 60;
	self.fuelUsed = self.fuelUsed + self.lastMovedDistance*self.fuelUsage;
end;

function manualIgnition:onEnter()
	if not self.ignitionKey then
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		self.steeringEnabled = false;
		Utils.setEmittingState(self.exhaustParticleSystems, false)
	else
	    self.steeringEnabled = true;
	end;
    setVisibility(self.aiMotorSound, false);
end;

function manualIgnition:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local runningTime =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#runningTime"),0);
    self.runningTime = runningTime;
	
    local distanceDriven =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#distanceDriven"),0);
    self.distanceDriven = distanceDriven;
	
	local fuelUsed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fuelUsed"), 0);
	self.fuelUsed = fuelUsed;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function manualIgnition:getSaveAttributesAndNodes(nodeIdent)
    local runningTime = Utils.getNoNil(self.runningTime, 10);
	local distanceDriven = Utils.getNoNil(self.distanceDriven, 10);
	local fuelUsed = Utils.getNoNil(self.fuelUsed, 10);
	
    local attributes = 'runningTime="'..string.format("%f", runningTime)..'"'..' distanceDriven="'..string.format("%f", distanceDriven)..'"'..' fuelUsed="'..string.format("%f", fuelUsed)..'"';
    return attributes, nil;
end;

function manualIgnition:draw()
end;

