--
-- driveStick
-- Specialization for a driveStick.
--
-- @author  Templaer
-- @date  25/04/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

driveStick = {};

function driveStick.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function driveStick:load(xmlFile)
    self.accDirection = 1;
	self.cruiseControl = false;
end;

function driveStick:delete()
end;

function driveStick:mouseEvent(posX, posY, isDown, isUp, button)
end;

function driveStick:keyEvent(unicode, sym, modifier, isDown)
end;

function driveStick:update(dt)
    if self.isMotorStarted and self.isEntered then	
	
		self.motor.speedLevel = 1;
	
        if self:getIsActiveForInput() then	
										
	        if InputBinding.hasEvent(InputBinding.REVERSE) then
		        self.accDirection = -self.accDirection;
				if self.hasAutoMode ~= nil then
					if self.currentMode > 1 then
						self:doPowershift("down");
					end;
				end;
            end;
						
			if InputBinding.hasEvent(InputBinding.CRUISECONTROL) then		
			    self.cruiseControl = not self.cruiseControl;
			end;
			
	    end;
		
		if self.isAITractorActivated then
		    self.cruiseControl = false;
		end;
				    					
					
		if g_currentMission.allowSteerableMoving and not self.playMotorSound then	
		
			local acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
			if InputBinding.isAxisZero(acceleration) then
				acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD); 
			end;
						
			if math.abs(acceleration) > 0.8 or self.motor.speedLevel == 0 then
				self.cruiseControl = false;
			end;
			
			if self.cruiseControl then
				acceleration = self.accDirection;
				if self.handThrottleEnabled ~= nil then
					if self.handThrottleEnabled then
						local newAcceleration = math.min(self.lastRoundPerMinute + 300, self.motor.maxRpm[3]) / self.motor.maxRpm[3];
						acceleration = self.accDirection * newAcceleration;
					end;
				end;
			else
				acceleration = self.accDirection * acceleration;
			end;
							
            if self.steeringEnabled then		
                if self.firstTimeRun then
                    WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode)
                end;	
            end;		
			
		end;
		
	end;
end;

function driveStick:onLeave()
    self.cruiseControl = false;
end;

function driveStick:draw()
end;

