--
-- deltaPowershift
-- This specialization can simulate any transmission that uses some form of powershift
--
-- @author  Templaer
-- @date  31/08/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

deltaPowershift = {};

function deltaPowershift.prerequisitesPresent(specializations)
    if SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(driveStick, specializations) then
		return true;
	else
		return false;
	end;
end;

function deltaPowershift:load(xmlFile)
	self.doPowershift = SpecializationUtil.callSpecializationsFunction("doPowershift");
	self.doRangeShift = SpecializationUtil.callSpecializationsFunction("doRangeShift");
	self.resetStartingGear = SpecializationUtil.callSpecializationsFunction("resetStartingGear");
	self.resetTimers = SpecializationUtil.callSpecializationsFunction("resetTimers");
	self.shiftMode = SpecializationUtil.callSpecializationsFunction("shiftMode");
	
    self.origMaxRpm = self.motor.maxRpm[3];
		
	self.hasHexashift = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.hasHexashift"), false);
	self.hasAutoMode = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.hasAutoMode"), true);
	self.numRanges = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.numRanges#count"), 4);
	self.numLevels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.numLevels#count"), 6);
	self.startingRange = math.min(Utils.getNoNil(getXMLInt(xmlFile, "vehicle.startingRange#number"), 3), self.numRanges) - 1;
	self.startingLevel = math.min(Utils.getNoNil(getXMLInt(xmlFile, "vehicle.startingLevel#number"), 1), self.numLevels);
	
	self.currentMode = 1;
	self.modes = {"Manual", "Auto", "HexActiv"};
	self.automaticTimer = 0;
	self.automaticReverseTimer = 0;
	self.powershiftLevel = 1;
    self.currentRange = 0;
	
	-- Initialize the RPM Table
	self.rpmTable = {};
	for i = 0, self.numRanges-1 do
		self.rpmTable[i] = {}; 
		for j = 0, self.numLevels-1 do
			local currentRpm = (i * (self.origMaxRpm / self.numRanges) + (j+1) * self.origMaxRpm / self.numRanges / self.numLevels);
			if i < self.numRanges - 1 then	
				self.rpmTable[i][j] = currentRpm * 0.75;
			else
				self.rpmTable[i][j] = currentRpm * (0.65 + (0.35 / self.numLevels) * (j+1));
			end;
		end;
	end;
end;

function deltaPowershift:delete()
end;

function deltaPowershift:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local currentMode =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#currentMode"), 1);
    self.currentMode = currentMode;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function deltaPowershift:getSaveAttributesAndNodes(nodeIdent)
    local currentMode = Utils.getNoNil(self.currentMode, 1);
    local attributes = 'currentMode="'..string.format("%d", currentMode)..'"';
    return attributes, nil;
end;

function deltaPowershift:mouseEvent(posX, posY, isDown, isUp, button)
end;

function deltaPowershift:keyEvent(unicode, sym, modifier, isDown)
end;

function deltaPowershift:update(dt)
    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	
	    self.motor.speedLevel = 1;		
		self.motor.maxRpm[1] = self.rpmTable[self.currentRange][self.powershiftLevel-1];
		
		if self.cruiseControl then
			self.input = 1;
		end;
		
		if InputBinding.hasEvent(InputBinding.RANGEUP) then
			self:doRangeShift("up");
		end;
		if InputBinding.hasEvent(InputBinding.RANGEDOWN) then
			self:doRangeShift("down");
		end;
			
		-- Handle level input
		if InputBinding.hasEvent(InputBinding.LEVELUP) then
			self:doPowershift("up");
		end;
		if InputBinding.hasEvent(InputBinding.LEVELDOWN) then
			self:doPowershift("down");
		end;
		if InputBinding.hasEvent(InputBinding.AUTOMATIC) then
			self:shiftMode();
		end;
			
		if self.currentMode > 1 then
		
			if math.abs(self.input) > 0 or self.cruiseControl then
				self.automaticTimer = self.automaticTimer + (dt / 1000);
			else 
				self:resetTimers(false);
			end;
			self.automaticReverseTimer = self.automaticReverseTimer + (dt / 1000);
		
			if math.abs(self.input) > 0.8 and self.automaticTimer >= 1.5 then
				if self.currentMode == 3 and self.powershiftLevel == self.numLevels and self.lastRoundPerMinute > 1600 then
					self:doRangeShift("up");
				elseif self.lastRoundPerMinute > 1300 then
					self:doPowershift("up");
				end;	
			elseif math.abs(self.input) < 0.5 and self.automaticReverseTimer >= 1 then
				if self.currentMode == 3 and self.powershiftLevel == 1 then
					if self.currentRange > self.startingRange or self.currentRange < self.startingRange and self.lastRoundPerMinute < 800 then
						self:doRangeShift("down");
					end;					
				elseif self.lastRoundPerMinute < 1000 then
					self:doPowershift("down");		
				end;
			end;			
			
		end;
	end;
end;

function deltaPowershift:draw()
end;

function deltaPowershift:doPowershift(direction) -- Function to shift powershift steps
    if direction == "up" and self.powershiftLevel < self.numLevels then
		self.powershiftLevel = self.powershiftLevel + 1;
		self.motor.minRpm = 200;
	elseif direction == "down" and self.powershiftLevel > 1 then
		self.powershiftLevel = self.powershiftLevel - 1;
		self.motor.minRpm = -200;
	end;
	self:resetTimers(true);
end;


function deltaPowershift:doRangeShift(direction) -- Function to shift ranges
	if direction == "up" and self.currentRange < self.numRanges - 1 then
	    self.currentRange = self.currentRange + 1;
		self.motor.minRpm = 200;
		if self.currentMode > 1 then
			self.powershiftLevel = 1;
		end;
	elseif direction == "down" and self.currentRange > 0 then
	    self.currentRange = self.currentRange - 1;
		self.motor.minRpm = -300;
		if self.currentMode > 1 then
			self.powershiftLevel = self.numLevels;
		end;
	end;
	self:resetTimers(true);
end;

function deltaPowershift:resetStartingGear()
	if not self.isAITractorActivated then
		self.powershiftLevel = self.startingLevel;
		self.currentRange = self.startingRange;
	end;
end;

function deltaPowershift:resetTimers(both)
    self.automaticTimer = 0;
	if both then
	    self.automaticReverseTimer = 0;
	end;
end;

function deltaPowershift:shiftMode()
	if self.hasAutoMode and self.hasHexashift and self.currentMode < 3 then
		self.currentMode = self.currentMode + 1;
	elseif self.hasAutoMode and self.currentMode < 2 then
		self.currentMode = self.currentMode + 1;
	else
		self.currentMode = 1;
	end;
	self:resetTimers(true);
end;

