-- LUA fr realistisches Partikelsystem am Auspuff
-- basiert auf der dynamicExhaustSystem.lua von Face ausm dem Kirovets K 700A
--
-- edit by modelleicher
-- www.schwabenmodding.bplaced.net


realExhaustParticleSystem = {};

function realExhaustParticleSystem.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function realExhaustParticleSystem:load(xmlFile)
	self.reps = {};
	
	self.reps.minAlpha = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#minAlpha"), 0.1);
	self.reps.maxAlpha = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#maxAlpha"), 1);
	self.reps.parameter = getXMLString(xmlFile, "vehicle.realExhaustParticleSystem#parameter");

	self.reps.realAlpha = self.reps.minAlpha;
	self.reps.isAcc = false;
	self.reps.accBackup = 0;
end;

function realExhaustParticleSystem:delete()
end;

function realExhaustParticleSystem:mouseEvent(posX, posY, isDown, isUp, button)
end;

function realExhaustParticleSystem:keyEvent(unicode, sym, modifier, isDown)
end;

function realExhaustParticleSystem:update(dt)
	if self:getIsActive() then
		-- berprfen ob der Traktor am beschleunigen ist
		if self.reps.accBackup < self.motor.lastMotorRpm then
			self.reps.isAcc = true;
		elseif self.reps.accBackup > self.motor.lastMotorRpm then
			self.reps.isAcc = false;
		end;
		if self.lastAcceleration == 0 then
			self.reps.isAcc = false;
		end;

		
		-- Tempomatstufen 
		if self.motor.speedLevel == 1 then
			if self.lastAcceleration < 0.4 then
				self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
			elseif self.lastAcceleration == 0.4 then
				self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.01);
			end;
		end;
		if self.motor.speedLevel == 2 or self.motor.speedLevel == 3 then
			if self.lastAcceleration < 1 then
				self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
			elseif self.lastAcceleration == 1 then
				self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.01);
			end;
		end;
		
		if self.motor.speedLevel == 0 then -- keine Tempomatstufe aktiviert
			if self.lastAcceleration < 1 then -- wenn lastAcceleration 1 ist, beschleunigt der Trecker nicht mehr
				if self.reps.isAcc == true then
					self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
				end;
				if self.reps.isAcc == false then
					self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.1);
				end;
			elseif self.lastAcceleration == 1 then -- wenn acc 1 ist, wird der Rauch weniger
				if self.reps.realAlpha > self.reps.minAlpha then
					self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.01);
				end;
			end;	
		end;
		
		setShaderParameter(self.exhaustParticleSystems[1].shape, self.reps.parameter, 0, 0, 0, self.reps.realAlpha, false);		
		self.reps.accBackup = self.motor.lastMotorRpm;	

	end;

end;

function realExhaustParticleSystem:draw()
end;