--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.757, 0.26, 0.018, (InputBinding.getKeyNamesOfDigitalAction(InputBinding.HUDINFO).. ": Info einblenden"))
		g_currentMission:addExtraPrintText(os.date("Datum / Uhrzeit:  %a %d %b / %X"));
		g_currentMission:addHelpButtonText(g_i18n:getText("ShowHelp1"), InputBinding.HUDINFO);
	 else
		renderText(0.40, 0.96, 0.02, "Numpad 0: Info Abschalten");
		renderText(0.72, 0.86, 0.03, "-MB SK Schausteller 6x6-");			
		renderText(0.72, 0.83, 0.02, "Taste Pos1: Rundumleuchte Ein/Aus");
		renderText(0.72, 0.81, 0.02, "Taste 9: Klappe Hinten");	
		renderText(0.72, 0.79, 0.02, "Taste m: Klappe Rechts");
		renderText(0.72, 0.76, 0.02, "Taste n: Klappe Links");
		renderText(0.72, 0.73, 0.02, "Taste 7: Allrad Ein/Aus");
		renderText(0.72, 0.71, 0.02, "Taste 4: Arbeitslicht Vorn");
		renderText(0.72, 0.69, 0.02, "Taste 0: Horn");
		renderText(0.72, 0.66, 0.02, "Taste Numpad 1: Blinker Links");
		renderText(0.72, 0.63, 0.02, "Taste Numpad 2: Warnblinker");
		renderText(0.72, 0.61, 0.02, "Taste Numpad 3: Blinker Rechts");
		renderText(0.72, 0.58, 0.02, "Stuetzen muessen ausgefahren sein");
        renderText(0.72, 0.53, 0.02, "Taste Pos1/ende : Sttze Raus/Rein");
		renderText(0.72, 0.51, 0.02, "Taste 7/4 : Arm1 Hoch/Runter");
		renderText(0.72, 0.49, 0.02, "Taste 8/5 : Arm2 Hoch/Runter");
		renderText(0.72, 0.47, 0.02, "Taste 9/6 : Arm3 Hoch/Runter");
		renderText(0.72, 0.45, 0.02, "Taste *// : Arm Ein/Ausfahren");
		g_currentMission:addExtraPrintText(os.date("Datum / Uhrzeit:  %a %d %b / %X"));
		g_currentMission:addHelpButtonText(g_i18n:getText("ShowHelp2"), InputBinding.HUDINFO);
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;

