wheelSet3 = {};

function wheelSet3.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function wheelSet3:load(xmlFile)
	local s=0;
	self.wheelsets3 = {};
	while true do
		local w=0;
		if getXMLString(xmlFile,string.format("vehicle.wheelsets3.set(%d).wheel(0)#node",s)) == nil then break; end;
		local set = {};
		while true do
			local node = getXMLString(xmlFile, string.format("vehicle.wheelsets3.set(%d).wheel(%d)#node",s,w));
			if node == nil then break; end;
			local index = Utils.indexToObject(self.components,node);
			setVisibility(index,false);
			table.insert(set, index);
			w=w+1;
		end;
		if table.getn(set) == table.getn(self.wheels) then
			table.insert(self.wheelsets3,set);
		end;
		s=s+1;
	end;
	self.wheelset3Cnt = table.getn(self.wheelsets3);
	if self.wheelset3Cnt > 0 then
		for i=1,table.getn(self.wheels) do
			self.wheels[i].driveNode = self.wheelsets3[1][i];
			setVisibility(self.wheels[i].driveNode,true);
		end;
		self.wheelset3 = 1;
	end;
end;

function wheelSet3:delete()
end;

function wheelSet3:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelSet3:keyEvent(unicode, sym, modifier, isDown)
end;

function wheelSet3:update(dt)
	if self:getIsActiveForInput() then
		if self.wheelset3Cnt > 0 then
			if InputBinding.hasEvent(InputBinding.switchWheelSets3) then
				self.wheelset3 = self.wheelset3 + 1;
				if self.wheelset3 > self.wheelset3Cnt then
					self.wheelset3 = 1;
				end;
				for w=1,table.getn(self.wheels) do
					setVisibility(self.wheels[w].driveNode,false);
					self.wheels[w].driveNode = self.wheelsets3[self.wheelset3][w];
					setVisibility(self.wheels[w].driveNode,true);
				end;
			end;
		end;
	end;
end;

function wheelSet3:draw()
	if self.wheelset3Cnt > 0 and self:getIsActive() then
		local text = g_i18n:getText("switchWheelSets3").." (Set"..self.wheelset3..")";
		g_currentMission:addHelpButtonText(text, InputBinding.switchWheelSets3);
	end;
end;
