
moveSattelplatte1 = {};

function moveSattelplatte1.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function moveSattelplatte1:load(xmlFile)

	self.moveableSattelplatte1 = {};
	self.moveableSattelplatte1.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableSattelplatte1#index"));
	self.moveableSattelplatte1.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableSattelplatte1#maxZ"), 0); 
	self.moveableSattelplatte1.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableSattelplatte1#minZ"), 0); 
	
end;

function moveSattelplatte1:delete()
end;

function moveSattelplatte1:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveSattelplatte1:keyEvent(unicode, sym, modifier, isDown)

end;

function moveSattelplatte1:update(dt)

	if self.moveableSattelplatte1 ~= nil then
		local xSattelplatte1, ySattelplatte1, zSattelplatte1 = getTranslation(self.moveableSattelplatte1.index);
		local maxZ = self.moveableSattelplatte1.max;
		local minZ = self.moveableSattelplatte1.min;
		local moveSpeed = 0.004;
			if InputBinding.isPressed(InputBinding.Sattelplatte1_Vor) then
				if zSattelplatte1 < maxZ then
					zSattelplatte1 = zSattelplatte1 + moveSpeed;
				else
					zSattelplatte1 = maxZ;
				end;
			elseif InputBinding.isPressed(InputBinding.Sattelplatte1_Zuruek) then
				if zSattelplatte1 > minZ then
					zSattelplatte1 = zSattelplatte1 - moveSpeed;
				else
					zSattelplatte1 = minZ;
				end;
			end;
		setTranslation(self.moveableSattelplatte1.index, xSattelplatte1, ySattelplatte1, zSattelplatte1);
	end;
				
end;

function moveSattelplatte1:onLeave()

end;

function moveSattelplatte1:draw()

	if self.moveableSattelplatte1 then
		g_currentMission:addHelpButtonText(g_i18n:getText("Sattelplatte1_Vor"), InputBinding.Sattelplatte1_Vor);
		g_currentMission:addHelpButtonText(g_i18n:getText("Sattelplatte1_Zuruek"), InputBinding.Sattelplatte1_Zuruek);
	end;

end;

function moveSattelplatte1:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

