--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.1
-- @date  		29/08/11
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v2.1 - improvements
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	local i=0;
	while true do
		local buttonName = string.format("vehicle.interactiveComponents.buttons.button(%d)", i);	
		if not hasXMLProperty(xmlFile, buttonName) then
			break;
		end;
		local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
		local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
		local highlight = getChildAt(mark, 0);
		local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
		local event = getXMLString(xmlFile, buttonName .. "#event");
		local onMessage = g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#onMessage"), "ic_button_on"));
		local offMessage =  g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#offMessage") , "ic_button_off"));
	
		local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage, self.infoBar);

		table.insert(self.interactiveObjects, button);
		i = i + 1;
	end;
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  29/08/11
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage, infobar)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, infobar, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.vehicle ~= nil then
		if self.event == "toggleMotorIgnition" then		
			self.isOpen = self.vehicle.isMotorStarted;
		end;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(dt)
    if self.vehicle ~= nil then
        if self.event == "toggleMotorIgnition" then
			if self.vehicle.isMotorStarted then
				self.vehicle:invokeIgnition(false, noEventSend);
			else
				self.vehicle:invokeIgnition(true, noEventSend);
			end;
		end;	
	end;
	
	if self.event == "frontworkXerion" then
		if self.vehicle ~= nil then
		self.vehicle:setState("work:1", not self.vehicle.B3.work[1].a);
		self.vehicle:setState("work:3", not self.vehicle.B3.work[3].a);
		end;
	end;
	
	if self.event == "rearworkXerion" then
		if self.vehicle ~= nil then
		self.vehicle:setState("work:2", not self.vehicle.B3.work[2].a);
		self.vehicle:setState("work:4", not self.vehicle.B3.work[4].a);
		end;
	end;
	
	if self.event == "warnXerion" then
		if self.vehicle ~= nil then
			if self.vehicle.B3.wl then
				self.vehicle:setState("warnlights", false);
				self.vehicle:setState("dirLeft", false);
				self.vehicle:setState("dirRight", false);
			else
				self.vehicle:setState("warnlights", true);
				self.vehicle:setState("dirLeft", true);
				self.vehicle:setState("dirRight", true);
			end;
		end;
	end;
	
	if self.event == "blinkerRXerion" then
		if self.vehicle ~= nil then
			if not self.vehicle.B3.wl then
				if self.vehicle.B3.dirRight[1].a then
					self.vehicle:setState("dirLeft", false);
					self.vehicle:setState("dirRight", false);
				else
					self.vehicle:setState("dirLeft", false);
					self.vehicle:setState("dirRight", true);
				end;
			end;
		end;
	end;
	
	if self.event == "blinkerLXerion" then
		if self.vehicle ~= nil then
			if not self.vehicle.B3.wl then
				if self.vehicle.B3.dirLeft[1].a then
					self.vehicle:setState("dirLeft", false);
					self.vehicle:setState("dirRight", false);
				else
					self.vehicle:setState("dirLeft", true);
					self.vehicle:setState("dirRight", false);
				end;
			end;
		end;
	end;
	
	if self.event == "lichtXerion" then
		if self.vehicle ~= nil then
			if self.vehicle.lightsActive then
				self.vehicle:setLightsVisibility(false);
			else
				self.vehicle:setLightsVisibility(true);
			end;
		end;
	end;
	
	if self.event == "rulXerion" then
		if self.vehicle ~= nil then
			if self.vehicle.beaconLightsActive then
				self.vehicle:setBeaconLightsVisibility(false);
			else
				self.vehicle:setBeaconLightsVisibility(true);
			end;
		end;
	end;
	
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;