ESLimiterEvent = {};
ESLimiterEvent_mt = Class(ESLimiterEvent, Event);

InitEventClass(ESLimiterEvent, "ESLimiterEvent");

function ESLimiterEvent:emptyNew()
    local self = Event:new(ESLimiterEvent_mt); 
    self.className="ESLimiterEvent";
    return self;
end;

function ESLimiterEvent:new(vehicle, level, percentage, doRestoreLimit)
    local self = ESLimiterEvent:emptyNew()
    self.vehicle = vehicle;
	self.level = level;
	self.percentage = percentage;
	self.doRestoreLimit = doRestoreLimit;
    return self;
end;

function ESLimiterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.level = streamReadInt8(streamId);
	self.percentage = streamReadInt8(streamId);
	self.doRestoreLimit = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ESLimiterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.level);
	streamWriteInt8(streamId, self.percentage);
	streamWriteBool(streamId, self.doRestoreLimit);
end;

function ESLimiterEvent:run(connection)
	self.vehicle:setNewLimit(self.level, self.percentage, self.doRestoreLimit, true);
	if not connection:getIsServer() then
		--g_server:broadcastEvent(ESLimiterEvent:new(self.vehicle, self.level, self.percentage, self.doRestoreLimit), nil, connection, self.object);
	end;
end;

function ESLimiterEvent.sendEvent(vehicle, level, percentage, doRestoreLimit, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			-- no need to broadcast the event: only the server need the information
			--g_server:broadcastEvent(ESLimiterEvent:new(vehicle, level, percentage, doRestoreLimit), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ESLimiterEvent:new(vehicle, level, percentage, doRestoreLimit));
		end;
	end;
end;