fredzazagrue = {}

function fredzazagrue.prerequisitesPresent(specializations)
     Vehicle.registerJointType("shovel");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function fredzazagrue:load(xmlFile)


    local jointDesc = {};

   local shovelAttacher = {};
	local jointTypeStr = getXMLString(xmlFile,"vehicle.attacherJoints.attacherJoint#jointType");
	shovelAttacher.joint = getXMLString(xmlFile,"vehicle.attacherJoints.attacherJoint#index");
	shovelAttacher.index = 0;
	self.shovel = shovelAttacher;
	if jointTypeStr ~= nil then
		local jointType = Vehicle.jointTypeNameToInt[jointTypeStr];

		if jointType == nil then
      		Vehicle.registerJointType(jointTypeStr);
			print("register Jointtype: " .. jointTypeStr);
			jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		end;

		if jointType ~= nil then
			self.attacherJoints[1].jointType = jointType;
		end;
	end;
	

    self.numclignos = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.clignos#count"), 0);
    self.clignos = {};
    for i=1, self.numclignos do
        local clignonamei = string.format("vehicle.clignos.cligno" .. "%d", i);
        self.clignos[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, clignonamei .. "#index"));
        setVisibility(self.clignos[i], false);
    end;
    
    self.numcligns = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cligns#count"), 0);
    self.cligns = {};
    for i=1, self.numcligns do
        local clignnamei = string.format("vehicle.cligns.clign" .. "%d", i);
        self.cligns[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, clignnamei .. "#index"));
        setVisibility(self.cligns[i], false);
    end;
 
    self.clignosActive = false;
    self.clignsActive = false;
    
    
    
        local translationPartNode11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart11#index"));
    if translationPartNode11 ~= nil then
        self.translationPart11 = {};
        self.translationPart11.node = translationPartNode11;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart11#minTrans"));
        self.translationPart11.minTrans = {};
        self.translationPart11.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart11.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart11.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart11#maxTrans"));
        self.translationPart11.maxTrans = {};
        self.translationPart11.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart11.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart11.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart11.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart11#transTime"), 2)*1000;
        self.translationPart11.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart11#touchTransLimit"), 10);
    end;
    
        local translationPartNode12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart12#index"));
    if translationPartNode12 ~= nil then
        self.translationPart12 = {};
        self.translationPart12.node = translationPartNode12;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart12#minTrans"));
        self.translationPart12.minTrans = {};
        self.translationPart12.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart12.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart12.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart12#maxTrans"));
        self.translationPart12.maxTrans = {};
        self.translationPart12.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart12.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart12.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart12.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart12#transTime"), 2)*1000;
        self.translationPart12.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart12#touchTransLimit"), 10);
    end;
    
        local translationPartNode21 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart21#index"));
    if translationPartNode21 ~= nil then
        self.translationPart21 = {};
        self.translationPart21.node = translationPartNode21;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart21#minTrans"));
        self.translationPart21.minTrans = {};
        self.translationPart21.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart21.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart21.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart21#maxTrans"));
        self.translationPart21.maxTrans = {};
        self.translationPart21.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart21.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart21.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart21.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart21#transTime"), 2)*1000;
        self.translationPart21.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart21#touchTransLimit"), 10);
    end;
    
        local translationPartNode22 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart22#index"));
    if translationPartNode22 ~= nil then
        self.translationPart22 = {};
        self.translationPart22.node = translationPartNode22;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart22#minTrans"));
        self.translationPart22.minTrans = {};
        self.translationPart22.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart22.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart22.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart22#maxTrans"));
        self.translationPart22.maxTrans = {};
        self.translationPart22.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart22.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart22.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart22.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart22#transTime"), 2)*1000;
        self.translationPart22.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart22#touchTransLimit"), 10);
    end;
    
            local translationPartNode31 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart31#index"));
    if translationPartNode31 ~= nil then
        self.translationPart31 = {};
        self.translationPart31.node = translationPartNode31;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart31#minTrans"));
        self.translationPart31.minTrans = {};
        self.translationPart31.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart31.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart31.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart31#maxTrans"));
        self.translationPart31.maxTrans = {};
        self.translationPart31.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart31.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart31.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart31.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart31#transTime"), 2)*1000;
        self.translationPart31.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart31#touchTransLimit"), 10);
    end;
    
            local translationPartNode32 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart32#index"));
    if translationPartNode32 ~= nil then
        self.translationPart32 = {};
        self.translationPart32.node = translationPartNode32;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart32#minTrans"));
        self.translationPart32.minTrans = {};
        self.translationPart32.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart32.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart32.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart32#maxTrans"));
        self.translationPart32.maxTrans = {};
        self.translationPart32.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart32.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart32.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart32.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart32#transTime"), 2)*1000;
        self.translationPart32.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart32#touchTransLimit"), 10);
    end;
    
                local translationPartNode41 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart41#index"));
    if translationPartNode41 ~= nil then
        self.translationPart41 = {};
        self.translationPart41.node = translationPartNode41;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart41#minTrans"));
        self.translationPart41.minTrans = {};
        self.translationPart41.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart41.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart41.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart41#maxTrans"));
        self.translationPart41.maxTrans = {};
        self.translationPart41.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart41.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart41.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart41.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart41#transTime"), 2)*1000;
        self.translationPart41.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart41#touchTransLimit"), 10);
    end;
    
            local translationPartNode42 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart42#index"));
    if translationPartNode42 ~= nil then
        self.translationPart42 = {};
        self.translationPart42.node = translationPartNode42;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart42#minTrans"));
        self.translationPart42.minTrans = {};
        self.translationPart42.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart42.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart42.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart42#maxTrans"));
        self.translationPart42.maxTrans = {};
        self.translationPart42.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart42.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart42.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart42.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart42#transTime"), 2)*1000;
        self.translationPart42.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart42#touchTransLimit"), 10);
    end;
    
    local rotationPartNodetourelleporte1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourelleporte1#index"));
    if rotationPartNodetourelleporte1 ~= nil then
        self.tourelleporte1 = {};
        self.tourelleporte1.node = rotationPartNodetourelleporte1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelleporte1#minRot"));
        self.tourelleporte1.minRot = {};
        self.tourelleporte1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelleporte1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelleporte1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelleporte1#maxRot"));
        self.tourelleporte1.maxRot = {};
        self.tourelleporte1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelleporte1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelleporte1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourelleporte1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelleporte1#rotTime"), 2)*1000;
        self.tourelleporte1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelleporte1#touchRotLimit"), 10))
    end;
    
    local rotationPartNodetourelleporte2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourelleporte2#index"));
    if rotationPartNodetourelleporte2 ~= nil then
        self.tourelleporte2 = {};
        self.tourelleporte2.node = rotationPartNodetourelleporte2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelleporte2#minRot"));
        self.tourelleporte2.minRot = {};
        self.tourelleporte2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelleporte2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelleporte2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelleporte2#maxRot"));
        self.tourelleporte2.maxRot = {};
        self.tourelleporte2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelleporte2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelleporte2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourelleporte2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelleporte2#rotTime"), 2)*1000;
        self.tourelleporte2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelleporte2#touchRotLimit"), 10))
    end;
    
    
    local rotationPartNodetourellegrue1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourellegrue1#index"));
    if rotationPartNodetourellegrue1 ~= nil then
        self.tourellegrue1 = {};
        self.tourellegrue1.node = rotationPartNodetourellegrue1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourellegrue1#minRot"));
        self.tourellegrue1.minRot = {};
        self.tourellegrue1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourellegrue1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourellegrue1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourellegrue1#maxRot"));
        self.tourellegrue1.maxRot = {};
        self.tourellegrue1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourellegrue1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourellegrue1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourellegrue1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourellegrue1#rotTime"), 2)*1000;
        self.tourellegrue1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourellegrue1#touchRotLimit"), 10))
    end;
    
        local rotationPartNodetourellegrue2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourellegrue2#index"));
    if rotationPartNodetourellegrue2 ~= nil then
        self.tourellegrue2 = {};
        self.tourellegrue2.node = rotationPartNodetourellegrue2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourellegrue2#minRot"));
        self.tourellegrue2.minRot = {};
        self.tourellegrue2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourellegrue2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourellegrue2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourellegrue2#maxRot"));
        self.tourellegrue2.maxRot = {};
        self.tourellegrue2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourellegrue2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourellegrue2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourellegrue2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourellegrue2#rotTime"), 2)*1000;


	    self.tourellegrue2.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourellegrue2#pivotverin"));
    end;
            local rotationPartNodetourellegrue3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourellegrue3#index"));
    if rotationPartNodetourellegrue3 ~= nil then
        self.tourellegrue3 = {};
        self.tourellegrue3.node = rotationPartNodetourellegrue3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourellegrue3#minRot"));
        self.tourellegrue3.minRot = {};
        self.tourellegrue3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourellegrue3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourellegrue3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourellegrue3#maxRot"));
        self.tourellegrue3.maxRot = {};
        self.tourellegrue3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourellegrue3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourellegrue3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourellegrue3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourellegrue3#rotTime"), 2)*1000;


	    self.tourellegrue3.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourellegrue3#pivotverin"));
    end;
    
    local rotationPartNodetourellegrue4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourellegrue4#index"));
    if rotationPartNodetourellegrue4 ~= nil then
        self.tourellegrue4 = {};
        self.tourellegrue4.node = rotationPartNodetourellegrue4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourellegrue4#minRot"));
        self.tourellegrue4.minRot = {};
        self.tourellegrue4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourellegrue4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourellegrue4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourellegrue4#maxRot"));
        self.tourellegrue4.maxRot = {};
        self.tourellegrue4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourellegrue4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourellegrue4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourellegrue4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourellegrue4#rotTime"), 2)*1000;
   		self.tourellegrue4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourellegrue4#touchRotLimit"), 10))
    end;


    self.veringrue1 = {};
	self.veringrue1.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.veringrue1#indexverin"));
	self.veringrue1.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.veringrue1#indextige"));
	self.veringrue1.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.veringrue1#translationtige"));
	local ax, ay, az = getWorldTranslation(self.veringrue1.tige);
    local bx, by, bz = getWorldTranslation(self.veringrue1.translationtige);
    self.veringrue1.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

	self.veringrue2 = {};
	self.veringrue2.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.veringrue2#indexverin"));
	self.veringrue2.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.veringrue2#indextige"));
	self.veringrue2.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.veringrue2#translationtige"));
	local ax, ay, az = getWorldTranslation(self.veringrue2.tige);
    local bx, by, bz = getWorldTranslation(self.veringrue2.translationtige);
    self.veringrue2.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
    
        	local objectAttacher = {};
	objectAttacher.joint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.anchor#index"));
	objectAttacher.index = 0;
	self.object = objectAttacher;
	self.attachedObject = nil;
	self.objectAttachable = false;
	self.objectInRange = nil;
	
	


end;

function fredzazagrue:delete()

end;


function fredzazagrue:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fredzazagrue:keyEvent(unicode, sym, modifier, isDown)  

	if self.isEntered and self.isMotorStarted then

	if table.getn(self.x) == 4 then
	if sym == Input.KEY_KP_4 then
		self.translationMax11 = isDown;
		self.translationMax41 = isDown;
    end;
	if sym == Input.KEY_KP_6 then
		self.translationMin11 = isDown;
		self.translationMin41 = isDown;
    end;
    if sym == Input.KEY_KP_2 then
		self.translationMax12 = isDown;
    end;
	if sym == Input.KEY_KP_8 then
		self.translationMin12 = isDown;
    end;
    end;

	
    if table.getn(self.x) == 5 then
    if sym == Input.KEY_KP_6 then
		self.translationMax21 = isDown;
		self.translationMax42 = isDown;
    end;
	if sym == Input.KEY_KP_4 then
		self.translationMin21 = isDown;
		self.translationMin42 = isDown;
    end;
    if sym == Input.KEY_KP_2 then
		self.translationMax22 = isDown;
    end;
	if sym == Input.KEY_KP_8 then
		self.translationMin22 = isDown;
    end;
    end;
    
    
if table.getn(self.x) == 6 then
    if sym == Input.KEY_KP_6 then
    self.rotationMintourellegrue1 = isDown;
	end;
	if sym == Input.KEY_KP_4 then
    self.rotationMaxtourellegrue1 = isDown;
	end;
	if sym == Input.KEY_KP_1 then
    self.rotationMintourellegrue2 = isDown;
	end;
	if sym == Input.KEY_KP_7 then
    self.rotationMaxtourellegrue2 = isDown;
	end;
	if sym == Input.KEY_KP_2 then
    self.rotationMintourellegrue3 = isDown;
	end;
	if sym == Input.KEY_KP_8 then
    self.rotationMaxtourellegrue3 = isDown;
	end;
	if sym == Input.KEY_KP_3 then
    self.translationMin31 = isDown;
    self.translationMin32 = isDown;
	end;
	if sym == Input.KEY_KP_9 then
    self.translationMax31 = isDown;
    self.translationMax32 = isDown;
	end;
	if sym == Input.KEY_KP_0 then
    self.rotationMintourellegrue4 = isDown;
	end;
	if sym == Input.KEY_KP_period then
    self.rotationMaxtourellegrue4 = isDown;
	end;
end;

if table.getn(self.x) == 8 then
    if sym == Input.KEY_KP_5 then
    self.rotationMintourelleporte1 = isDown;
    self.rotationMintourelleporte2 = isDown;
	end;
	if sym == Input.KEY_KP_8 then
    self.rotationMaxtourelleporte1 = isDown;
    self.rotationMaxtourelleporte2 = isDown;
	end;
end;








end;



end;


function fredzazagrue:update(dt)



	self.tourellegrue1Moving = 0; 
	self.tourellegrue2Moving = 0;
	self.tourellegrue3Moving = 0;
	self.tourellegrue4Moving = 0;
	self.translationPart31Moving = 0;
	self.translationPart32Moving = 0;
	
	if table.getn(self.x) == 4 then
		self.clignsActive = true;
	else 
		self.clignsActive = false;	
	end;
	
	if table.getn(self.x) == 5 then
		self.clignosActive = true;
	else 
		self.clignosActive = false;	
	end;
	
	    if not self.clignosActive then
			for i=1, self.numclignos do
				local cligno = self.clignos[i];
				setVisibility(cligno, self.clignosActive);
			end;
		else
			for i=1, self.numclignos do
				local cligno = self.clignos[i];
				setVisibility(cligno, self.clignosActive, false);
			end;
		end;
		
		if not self.clignsActive then
			for i=1, self.numcligns do
				local clign = self.cligns[i];
				setVisibility(clign, self.clignsActive);
			end;
		else
			for i=1, self.numcligns do
				local clign = self.cligns[i];
				setVisibility(clign, self.clignsActive, false);
			end;
		end;


	for i, jointDesc in pairs(self.componentJoints) do
	   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
	

     if self.veringrue1 ~= nil and self.tourellegrue2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.veringrue1.node);
		local bx, by, bz = getWorldTranslation(self.tourellegrue2.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.veringrue1.node), bx-ax, by-ay, bz-az);
		setDirection(self.veringrue1.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.veringrue1.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.veringrue1.tige, 0, 0, (distance-self.veringrue1.tigeDistance)*-1);
		end;
	end;
	
	if self.veringrue2 ~= nil and self.tourellegrue3 ~= nil then
		local ax, ay, az = getWorldTranslation(self.veringrue2.node);
		local bx, by, bz = getWorldTranslation(self.tourellegrue3.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.veringrue2.node), bx-ax, by-ay, bz-az);
		setDirection(self.veringrue2.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.veringrue2.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.veringrue2.tige, 0, 0, (distance-self.veringrue2.tigeDistance)*-1);
		end;
	end;
	

	
    local doRotate = self.rotationMaxtourellegrue2 or self.rotationMintourellegrue2
    	if self.tourellegrue2 ~= nil and doRotate then
		local x, y, z = getRotation(self.tourellegrue2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourellegrue2.maxRot, self.tourellegrue2.minRot, 3, self.tourellegrue2.rotTime, dt, not self.rotationMaxtourellegrue2);
		setRotation(self.tourellegrue2.node, unpack(newRot));

	end;
	    local doRotate = self.rotationMaxtourellegrue3 or self.rotationMintourellegrue3
    	if self.tourellegrue3 ~= nil and doRotate then
		local x, y, z = getRotation(self.tourellegrue3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourellegrue3.maxRot, self.tourellegrue3.minRot, 3, self.tourellegrue3.rotTime, dt, not self.rotationMaxtourellegrue3);
		setRotation(self.tourellegrue3.node, unpack(newRot));

	end;


	

    local doTranslate = self.translationMax11 or self.translationMin11
		if self.translationMax11 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart11.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart11.maxTrans, self.translationPart11.minTrans, 3, self.translationPart11.transTime, dt, not self.translationMax11);
        setTranslation(self.translationPart11.node, unpack(newTrans));
	end;
	local doTranslate = self.translationMax12 or self.translationMin12
		if self.translationMax12 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart12.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart12.maxTrans, self.translationPart12.minTrans, 3, self.translationPart12.transTime, dt, not self.translationMax12);
        setTranslation(self.translationPart12.node, unpack(newTrans));
	end;
	local doTranslate = self.translationMax21 or self.translationMin21
		if self.translationMax21 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart21.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart21.maxTrans, self.translationPart21.minTrans, 3, self.translationPart21.transTime, dt, not self.translationMax21);
        setTranslation(self.translationPart21.node, unpack(newTrans));
	end;
	local doTranslate = self.translationMax22 or self.translationMin22
		if self.translationMax22 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart22.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart22.maxTrans, self.translationPart22.minTrans, 3, self.translationPart22.transTime, dt, not self.translationMax22);
        setTranslation(self.translationPart22.node, unpack(newTrans));
	end;
	local doTranslate = self.translationMax31 or self.translationMin31
		if self.translationMax31 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart31.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart31.maxTrans, self.translationPart31.minTrans, 3, self.translationPart31.transTime, dt, not self.translationMax31);
        setTranslation(self.translationPart31.node, unpack(newTrans));
	end;
		local doTranslate = self.translationMax32 or self.translationMin32
		if self.translationMax32 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart32.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart32.maxTrans, self.translationPart32.minTrans, 3, self.translationPart32.transTime, dt, not self.translationMax32);
        setTranslation(self.translationPart32.node, unpack(newTrans));
	end;
	
		local doTranslate = self.translationMax41 or self.translationMin41
		if self.translationMax41 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart41.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart41.maxTrans, self.translationPart41.minTrans, 3, self.translationPart41.transTime, dt, not self.translationMax41);
        setTranslation(self.translationPart41.node, unpack(newTrans));
	end;
		local doTranslate = self.translationMax42 or self.translationMin42
		if self.translationMax42 ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart42.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart42.maxTrans, self.translationPart42.minTrans, 3, self.translationPart42.transTime, dt, not self.translationMax42);
        setTranslation(self.translationPart42.node, unpack(newTrans));
	end;
	
	
	local doRotate = self.rotationMaxtourellegrue1 or self.rotationMintourellegrue1
    	if self.tourellegrue1 ~= nil and doRotate then
		local x, y, z = getRotation(self.tourellegrue1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourellegrue1.maxRot, self.tourellegrue1.minRot, 3, self.tourellegrue1.rotTime, dt, not self.rotationMaxtourellegrue1);
		setRotation(self.tourellegrue1.node, unpack(newRot));
	end;
	
	local doRotate = self.rotationMaxtourellegrue4 or self.rotationMintourellegrue4
    	if self.tourellegrue4 ~= nil and doRotate then
		local x, y, z = getRotation(self.tourellegrue4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourellegrue4.maxRot, self.tourellegrue4.minRot, 3, self.tourellegrue4.rotTime, dt, not self.rotationMaxtourellegrue4);
		setRotation(self.tourellegrue4.node, unpack(newRot));

	end;
	local doRotate = self.rotationMaxtourelleporte2 or self.rotationMintourelleporte2
    	if self.tourelleporte2 ~= nil and doRotate then
		local x, y, z = getRotation(self.tourelleporte2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourelleporte2.maxRot, self.tourelleporte2.minRot, 3, self.tourelleporte2.rotTime, dt, not self.rotationMaxtourelleporte2);
		setRotation(self.tourelleporte2.node, unpack(newRot));
	end;
	
	local doRotate = self.rotationMaxtourelleporte1 or self.rotationMintourelleporte1
    	if self.tourelleporte1 ~= nil and doRotate then
		local x, y, z = getRotation(self.tourelleporte1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourelleporte1.maxRot, self.tourelleporte1.minRot, 3, self.tourelleporte1.rotTime, dt, not self.rotationMaxtourelleporte1);
		setRotation(self.tourelleporte1.node, unpack(newRot));
	end;
	


end;




function fredzazagrue:draw()



end;

function fredzazagrue:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
