-- Trac2500
-- 
--

Trac2500 = {};

function Trac2500.initSpecialization()
	--Vehicle.registerJointType("jd_frontCoupler");
	--Vehicle.registerJointType("jd_weight");
	--Vehicle.registerJointType("jd_fastCoupler");
end;

function Trac2500.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Trac2500:load(xmlFile)	
	self.getIsTurnedOnAttachedImplements = Trac2500.getIsTurnedOnAttachedImplements;

	self.rearAttacherJoint = {};
	self.rearAttacherJoint.mainPullerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearAttacherJoint#mainPullerIndex"));
	self.rearAttacherJoint.orientNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearAttacherJoint#orientIndex"));	
	
	self.trailerAttacherRotateNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherRotateNode#index") );

	self.internalCamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.internalCamera#index"));
	self.camPositionX = 0;
	self.camPositionZ = 0;
end;

function Trac2500:delete()
end;

function Trac2500:getIsTurnedOnAttachedImplements()
	for _,v in pairs(self.attachedImplements) do
		if v.object.isTurnedOn ~= nil then
			if v.object.isTurnedOn == true then
				return true;
			end;
		end;
	end;
	return false
end;

function Trac2500:readStream(streamId, connection)
end;

function Trac2500:writeStream(streamId, connection)	
end;

function Trac2500:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Trac2500:keyEvent(unicode, sym, modifier, isDown)
end;

function Trac2500:update(dt)
	--used to get more updateIntervales then updateTick()
	if not self.startedUpdating then
		self.updateInterval = self.time+10;
		self.startedUpdating = true;
	end;
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;
		if self.rearAttacherJoint.mainPullerNode ~= nil and self.rearAttacherJoint.orientNode ~= nil then
			local x,_,_ = getRotation(self.rearAttacherJoint.orientNode)
			local _,y,z = getRotation(self.rearAttacherJoint.mainPullerNode)
			setRotation(self.rearAttacherJoint.mainPullerNode, x,y,z);
		end;
	end;
	
	if self.isEntered then
		
		if InputBinding.isPressed(InputBinding.MOVECAMLEFT) then
			self.camPositionX = self.camPositionX + 0.02;
			if self.camPositionX >= 0.3 then
				self.camPositionX = 0.3;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMRIGHT) then
			self.camPositionX = self.camPositionX - 0.02;
			if self.camPositionX <= -0.3 then
				self.camPositionX = -0.3;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMFORWARD) then
			self.camPositionZ = self.camPositionZ + 0.02;
			if self.camPositionZ >= 0.3 then
				self.camPositionZ = 0.3;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMBACK) then
			self.camPositionZ = self.camPositionZ - 0.02;
			if self.camPositionZ <= -0.3 then
				self.camPositionZ = -0.3;
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.MOVECAMRESET) then
			self.camPositionX = 0;
			self.camPositionZ = 0;
		end;
		
		if self.internalCamera ~= nil then
			setTranslation(self.internalCamera, self.camPositionX, 0, self.camPositionZ);
		end;		
	end;	

	if self.checkTrailerAttacherRot == true then 
		if self.attacherJoints[1].jointIndex ~= 0 or
			self.attacherJoints[3].jointIndex ~= 0 or
			self.attacherJoints[5].jointIndex ~= 0 then		
			setRotation(self.trailerAttacherRotateNode, 0, Utils.degToRad(-180), 0);
		else
			setRotation(self.trailerAttacherRotateNode, 0, 0, 0);
		end;	
		checkTrailerAttacherRot = false;
	end;
end;

function Trac2500:updateTick(dt)

end;

function Trac2500:draw()
end;

function Trac2500:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Trac2500:getSaveAttributesAndNodes(nodeIdent)
end;

function Trac2500:attachImplement(implement)	
	self.checkTrailerAttacherRot = true;
end;

function Trac2500:detachImplement(implementIndex)
	self.checkTrailerAttacherRot = true;
end;
