--xyzspain
-- transporte de grandes vehiculos  compaia canadiense CT3200XL

CT3200XL = {};

function CT3200XL.prerequisitesPresent(specializations)   
return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;
function CT3200XL:load(xmlFile)
  
   print("'lua loaded CT3200XL'" );	
   ---rotaciones y reanslaciones
  
   local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
      
    end;

	
	 --desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	  ---------flashlights
	self.FlashLightLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl#index"));
    self.FlashLightRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr#index"));	 
	self.flashLightLeftActive = false;
    self.flashLightRightActive = false;
    self.flash = false;
    self.flashRight = false;
    self.flashLeft = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayOn = 0;
    self.delayOff = 0;
   
    turnSoundFile = Utils.getFilename("turn.wav", self.baseDirectory);
    self.turnSoundId = createSample("turnSound");
    loadSample(self.turnSoundId, turnSoundFile, false);
	--- strobe lights
  ---------
	self.Lightstrobe1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexstrobe1#index"));
   self.Lightstrobe2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexstrobe2#index"));
	self.Lightstrobe3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexstrobe3#index"));
	
	
    self.Lightstrobe1Active = false;
	 self.Lightstrobe2Active = false;
	self.Lightstrobe3Active = false;
	
    self.strobe1 = false;
    self.delayOnstrobe1 = 0;
    self.delayOffstrobe1 = 0;
	 self.strobe2 = false;
    self.delayOnstrobe2 = 0;
    self.delayOffstrobe2 = 0;
	 self. strobe3 = false;
    self.delayOnstrobe3 = 0;
    self.delayOffstrobe3 = 0;
	
	--------------
	---brake light and sound
	self.lightsbrake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brake#index"));
	self.lightsbrake1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brake1#index"));
	
   
	self.braking = false;
	local brakeSound = getXMLString(xmlFile, "vehicle.brakeSound#file");
    if brakeSound ~= nil and brakeSound ~= "" then
	brakeSound = Utils.getFilename(brakeSound, self.baseDirectory);
        self.brakeSound = createSample("brakeSound");
        loadSample(self.brakeSound, brakeSound, false);
    end;
	-------rotacion levas frenos------
	 local numRotParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts#count"), 0);
    self.RotParts = {};
    for i=1, numRotParts do
      local partnamei = string.format("vehicle.RotParts.part" .. "%d", i);
      self.RotParts[i] = {};
      self.RotParts[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
      self.RotParts[i].minRot = {};
      self.RotParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
      self.RotParts[i].maxRot = {};
      self.RotParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.RotParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile,  partnamei .. "#rotSpeed"), 2)*1000;
    end;
	self.rotParts=false;
	
	 -----marcha atras
	  local reverseDriveSound = getXMLString(xmlFile, "vehicle.reverseDriveSound#file");
    if reverseDriveSound ~= nil and reverseDriveSound ~= "" then
		reverseDriveSound = Utils.getFilename(reverseDriveSound, self.baseDirectory);
        self.reverseDriveSound = createSample("reverseDriveSound");
        self.reverseDriveSoundEnabled = false;
        loadSample(self.reverseDriveSound, reverseDriveSound, false);
    end;
		---luz marcha atras
	self.backlights = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backlights#index"));	
	setVisibility(self.backlights, false);
	
	
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
end;
function CT3200XL:delete()

 end;

function CT3200XL:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CT3200XL:keyEvent(unicode, sym, modifier, isDown)
	
---flashlights
	
	if isDown and sym == Input.KEY_KP_1 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashLightRightActive = false;
		
	end;

	if isDown and sym == Input.KEY_KP_3 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashLightLeftActive = false;
	end;
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashLightRightActive = false;
		self.flashLightLeftActive = false;
	end;

	
	
end;
function CT3200XL:update(dt)
if self.attacherVehicle then
if self:getIsActive() then --aislarlo de otros objetos
	
 

	if InputBinding.hasEvent(InputBinding.TOGGLE_BEACON_LIGHTS) then
		self.strobe1= not self.strobe1;
		self.delayOnstrobe1 = 10;
		self.strobe2= not self.strobe2;
		self.delayOnstrobe2 = 60;
		self.strobe3= not self.strobe3;
		self.delayOnstrobe3 = 90;
		
	end;
	
	
	
--- flashLights
	if self.FlashLightLeft ~= nil then
            if self.flashLightLeftActive then
            	setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
			
	    else
            	setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
				
	    end;
        end;

	if self.FlashLightRight ~= nil then
            if self.FlashLightRightActive then
            	setVisibility(self.FlashLightRight, self.flashLightRightActive);
				
	    else
            	setVisibility(self.FlashLightRight, self.flashLightRightActive);
			
	    end;
        end;

	if self.flashLeft then
		if self.delayOnLeft >= -1 then
			self.delayOnLeft = self.delayOnLeft -dt;
		end;
		if not self.flashLightLeftActive then
			if self.delayOnLeft < 0 then
				self.delayOffLeft = 500;
				self.flashLightLeftActive = true;
				playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOffLeft >= 0 then
			self.delayOffLeft = self.delayOffLeft -dt;
		end;
		if self.flashLightLeftActive then
			if self.delayOffLeft < 0 then
				self.delayOnLeft = 500;
				self.flashLightLeftActive = false;
			end;
		end;
	end;

	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashLightRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 500;
				self.flashLightRightActive = true;
				playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashLightRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 500;
				self.flashLightRightActive = false;
			end;
		end;
	end;

	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashLightRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashLightRightActive = true;
				self.flashLightLeftActive = true;
				playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashLightRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashLightLeftActive = false;
				self.flashLightRightActive = false;
			end;
		end;
	end;

	if not self.flashLeft and not self.flashRight then
		if not self.flash then
			self.flashLightRightActive = false;
			self.flashLightLeftActive = false;
		end;
	end;
		
	if not self.flash and not self.flashLeft then
		if not self.flashRight then
			self.flashLightRightActive = false;
		end;
	end;

	if not self.flash and not self.flashRight then
		if not self.flashLeft then
			self.flashLightLeftActive = false;
		end;
	end;
-----
 --- strobe lights
   if self.Lightstrobe1 ~= nil then
           if self.Lightstrobe1Active then
            	setVisibility(self.Lightstrobe1, self.Lightstrobe1Active);
		  else
            	setVisibility(self.Lightstrobe1, self.Lightstrobe1Active);
		 end;
        end;
	if self.Lightstrobe2 ~= nil then
           if self.Lightstrobe2Active then
            	setVisibility(self.Lightstrobe2, self.Lightstrobe2Active);
		  else
            	setVisibility(self.Lightstrobe2, self.Lightstrobe2Active);
		 end;
        end;
	if self.Lightstrobe3 ~= nil then
           if self.Lightstrobe3Active then
            	setVisibility(self.Lightstrobe3, self.Lightstrobe3Active);
		  else
            	setVisibility(self.Lightstrobe3, self.Lightstrobe3Active);
		 end;
        end;



if self.strobe1 then
		if self.delayOnstrobe1 >= -1 then
			self.delayOnstrobe1 = self.delayOnstrobe1 -dt;
		end;
		if not self.Lightstrobe1Active then
			if self.delayOnstrobe1 < 0 then
				self.delayOffstrobe1 = 100;
				self.Lightstrobe1Active = true;
			---	playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOffstrobe1 >= 0 then
			self.delayOffstrobe1 = self.delayOffstrobe1 -dt;
		end;
		if self.Lightstrobe1Active then
			if self.delayOffstrobe1 < 0 then
				self.delayOnstrobe1 = 100;
				self.Lightstrobe1Active = false;
			end;
		end;
	end;
	if self.strobe2 then
		if self.delayOnstrobe2 >= -1 then
			self.delayOnstrobe2 = self.delayOnstrobe2 -dt;
		end;
		if not self.Lightstrobe2Active then
			if self.delayOnstrobe2 < 0 then
				self.delayOffstrobe2 = 120;
				self.Lightstrobe2Active = true;
			---	playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOffstrobe2 >= 0 then
			self.delayOffstrobe2 = self.delayOffstrobe2 -dt;
		end;
		if self.Lightstrobe2Active then
			if self.delayOffstrobe2 < 0 then
				self.delayOnstrobe2 = 120;
				self.Lightstrobe2Active = false;
			end;
		end;
	end;
	if self.strobe3 then
		if self.delayOnstrobe3 >= -1 then
			self.delayOnstrobe3 = self.delayOnstrobe3 -dt;
		end;
		if not self.Lightstrobe3Active then
			if self.delayOnstrobe3 < 0 then
				self.delayOffstrobe3 = 80;
				self.Lightstrobe3Active = true;
			---	playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOffstrobe3 >= 0 then
			self.delayOffstrobe3 = self.delayOffstrobe3 -dt;
		end;
		if self.Lightstrobe3Active then
			if self.delayOffstrobe3 < 0 then
				self.delayOnstrobe3 = 80;
				self.Lightstrobe3Active = false;
			end;
		end;
	end;	

--------- apagar
if not self.strobe1 then
self.Lightstrobe1Active = false;
self.Lightstrobe2Active = false;
self.Lightstrobe3Active = false;

end;

--------------------brake------------------------
   inputAxis_2 = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxis_2 = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;
	
		if (self.movingDirection*self.lastSpeed*(-inputAxis_2)) < -0.001 then
			setVisibility(self.lightsbrake, true);
			setVisibility(self.lightsbrake1, true);
			if not self.brakeSoundRunning then
					playSample(self.brakeSound, 1, 1, 0);
					self.brakeSoundRunning = true;
					
				end;
			self.braking = true;
			
		else
		     setVisibility(self.lightsbrake, false);
			 setVisibility(self.lightsbrake1, false);
			self.braking = false;
			self.brakeSoundRunning = false;	
		
		end;
	
		if self.braking  then
		self.rotParts=true;
		else
		self.rotParts=false;
		end;
	
	---marcha atras

      if self.reverseDriveSound ~= nil and self.movingDirection == -1  then
            if not self.reverseDriveSoundEnabled then
                playSample(self.reverseDriveSound, 0, 0.4, 0);
                self.reverseDriveSoundEnabled = true;
				
            end;
     
           elseif self.reverseDriveSoundEnabled then
                stopSample(self.reverseDriveSound);
                self.reverseDriveSoundEnabled = false;
				
           end;
       

				--backlights

			if self.movingDirection == -1 then
			setVisibility(self.backlights, true);
			elseif self.movingDirection ~=-1  then 
			setVisibility(self.backlights, false);
			
			end;
	
end;
end;
----rotaciones y translaciones
		
		if self.rotParts ~= nil   then
				for i=1, table.getn(self.RotParts) do
					local rot = {getRotation(self.RotParts[i].index)};
					local newRot = Utils.getMovedLimitedValues(rot, self.RotParts[i].maxRot, self.RotParts[i].minRot, 3, self.RotParts[i].rotTime, dt, not self.rotParts);
					setRotation(self.RotParts[i].index, unpack(newRot));
				end;
				end;

	 if self.translation1max ~= nil then
		local x, y, z = getTranslation(self.translation1.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1max);
        setTranslation(self.translation1.node, unpack(newTrans));
		end;

-- juntas

		local joint = self.componentJoints[1];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[3];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[4];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[5];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[6];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		
		
		
		
	self:setHydraulicDirection();	
end;
function CT3200XL:draw()
if self.attacherVehicle then
	if self.strobe1 then
			 g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".2"), self.typeDesc), InputBinding.TOGGLE_BEACON_LIGHTS); 
else
			 g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".1"), self.typeDesc), InputBinding.TOGGLE_BEACON_LIGHTS); 
end; 

 
end;
end;
function CT3200XL:onAttach()	
self.translation1max =true;

end;

function CT3200XL:onDetach()
self.translation1max =false;

self.Lightstrobe1Active = false;
self.Lightstrobe2Active = false;
self.Lightstrobe3Active = false;
setVisibility(self.Lightstrobe1, false);
setVisibility(self.Lightstrobe2, false);
setVisibility(self.Lightstrobe3, false);
setVisibility(self.lightsbrake, false);
setVisibility(self.lightsbrake1, false);
self.flashLightRightActive = false;
self.flashLightLeftActive = false;
setVisibility(self.FlashLightRight, false);
setVisibility(self.FlashLightLeft, false);
if self.reverseDriveSoundEnabled then
  stopSample(self.reverseDriveSound);
  self.reverseDriveSoundEnabled = false;
				
   end;
 setVisibility(self.backlights, false);
end;

function CT3200XL:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end;
