--
-- SampleModMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}
SampleModMap.currentModDirectory = g_modsDirectory .. "/MAP_KNUSTON_FARM_V2/";

source(SampleModMap.currentModDirectory .. "scripts/FMCMapTriggersV2.lua");

local SampleModMap_mt = Class(SampleModMap, Mission00);

function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);
    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));

    g_currentMission.milkProductionScale = 0.03;
    g_currentMission.milkPriceScale = 0.50;
    g_currentMission.manureProductionScale = 0.1;
    
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadowKF.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));

    -- Copy career messages from ModDesc.XML's <l10n> section, into a global
    -- descriptions table of the g_i18n object.
    -- This way, we can get customized career messages for the infospot triggers.
    local i=1;
    while (true) do
        local titleTxt   = string.format("careerMessageTitle%02d", i);
        local contentTxt = string.format("careerMessageContent%02d", i);
        if (not g_i18n:hasText(titleTxt)) then
            -- No more texts, or there is a gap in the number-sequence.
            break;
        end;
        g_i18n.globalI18N.descriptions[titleTxt]   = g_i18n:getText(titleTxt);
        g_i18n.globalI18N.descriptions[contentTxt] = g_i18n:getText(contentTxt);
        i=i+1;
    end;
    
    SampleModMap:superClass().load(self);
end
function SampleModMap:loadFinished()
    SampleModMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
    -- Hide already touched infospot triggers.
    for _,v in pairs(g_currentMission.updateables) do
        if v["infoSymbol"] ~= nil and v["triggerId"] ~= nil then
            -- Guessing this is a infospotTrigger.
            local shapeName = getName(v["triggerId"]);
            if shapeName ~= nil and shapeName:len() > 2 then
                local infoTriggerNum = tonumber(shapeName:sub(-2));
                if infoTriggerNum > 0 and infoTriggerNum <= g_currentMission.foundInfoTriggers:len() then
                    if g_currentMission.foundInfoTriggers:sub(infoTriggerNum,infoTriggerNum) == "1" then
                        -- infoTrigger have already been touched before, so hide/disable it.
                        setVisibility(v["triggerId"], false);
                    end;
                else
                    print(string.format("Invalid infoTrigger name: '%s'. Last two characters not digits or between %02d and %02d.",
                        shapeName, 1, g_currentMission.foundInfoTriggers:len())
                    );
                end;
            end;
        end;
    end;
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;
