--MAN
--powered by hz888
--hz888@freemail.hu

MAN = {};

function MAN.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function MAN:load(xmlFile)

	self.connectCollisions = SpecializationUtil.callSpecializationsFunction("connectCollisions");
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.moveColli = {}; 
    self.animParts = {}
	self.collisionArm = {}; 
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		self.moveColli[nameR] = getXMLString(xmlFile, partname.."#moveColli");
		if self.moveColli[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#collision"));
			Collision.collisionAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#collsionAttacher"));
			Collision.armAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.. "#armAttacher"));
			Collision.index = 0;
			self.collisionArm[nameR] = Collision;
			self:connectCollisions(nameR);
		end; 
	end;


    self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;

	self.numbacklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.backlights#count"), 0);
    self.backlights = {};
    for i=1, self.numbacklights do
        local backlightnamei = string.format("vehicle.backlights.backlight" .. "%d", i);
        self.backlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, backlightnamei .. "#index"));
        setVisibility(self.backlights[i], false);
    end;
	self.backlightsActive = false;

    local brakeSound1 = getXMLString(xmlFile, "vehicle.brakeSound1#file");
    if brakeSound1 ~= nil and brakeSound1 ~= "" then
        brakeSound1 = Utils.getFilename(brakeSound1, self.baseDirectory);
        self.brakeSound1 = createSample("brakeSound1");
        self.brakeSound1Enabled = false;
        loadSample(self.brakeSound1, brakeSound1, false);
        self.brakeSound1PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeSound1#pitchOffset"), 1);
        self.brakeSound1Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeSound1#volume"), 1);
    end;

end;

function MAN:delete()

    if self.brakeSound1 ~= nil then
        delete(self.brakeSound1);
    end;

end;

function MAN:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MAN:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym==Input.KEY_KP_0 then
		self.Go.pillar = not self.Go.pillar; 
		self.Done.pillar = true;
	end;

	if isDown and sym == 96 then
        	self.helpPanel = not self.helpPanel;
    	end;

end;

function MAN:update(dt)


	if self.Go.pillar ~= nil and self.Done.pillar ~= false then
		self:anim("pillar", false); 
	end; 

    if self.isEntered then

	self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

	if InputBinding.isAxisZero(self.input) then
        	self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
	end;

	if self.brakelightsActive then
		for i=1, self.numbrakelights do
			local brakelight = self.brakelights[i];
			setVisibility(brakelight, self.brakelightsActive);
		end;
	else
		for i=1, self.numbrakelights do
			local brakelight = self.brakelights[i];
			setVisibility(brakelight, self.brakelightsActive, false);
		end;
	end;


	if self.backlightsActive then
		for i=1, self.numbacklights do
			local backlight = self.backlights[i];
			setVisibility(backlight, self.backlightsActive);
		end;
	else
		for i=1, self.numbacklights do
			local backlight = self.backlights[i];
			setVisibility(backlight, self.backlightsActive, false);
		end;
	end;

	if -self.input < -0.001 and self.movingDirection > 0 then
		self.brakelightsActive = true;
		self.motor.brakeForce = -self.input*-50;
	elseif -self.input > 0.001 and self.movingDirection < 0 then
    		self.brakelightsActive = true;
		self.motor.brakeForce = -self.input*25;
	else
		self.brakelightsActive = false;
		self.motor.brakeForce = 10;
	end;
	if self.movingDirection < 0 then
    		self.backlightsActive = true;
	else
		self.backlightsActive = false;
	end;

	if self.movingDirection > 0 then
            if self.brakeSound1 ~= nil then
                if -self.input < -0.001 and self.brakeSound1Enabled then
                    self.brakeSound1Enabled = false;
                end;

                if -self.input < -0.001 and not self.brakeSound1Enabled then
                    if self:getIsActiveForSound() then
                        playSample(self.brakeSound1, 1, self.brakeSound1Volume, 0);
                        setSamplePitch(self.brakesound1Sound, self.brakeSound1PitchOffset);
                    end;
                    self.brakeSound1Enabled = true;
                end;

            end;
	end;
	if self.movingDirection < 0 then
            if self.brakeSound1 ~= nil then
                if -self.input > 0.001 and self.brakeSound1Enabled then
                    self.brakeSound1Enabled = false;
                end;

                if -self.input > 0.001 and not self.brakeSound1Enabled then
                    if self:getIsActiveForSound() then
                        playSample(self.brakeSound1, 1, self.brakeSound1Volume, 0);
                        setSamplePitch(self.brakesound1Sound, self.brakeSound1PitchOffset);
                    end;
                    self.brakeSound1Enabled = true;
                end;

            end;
	end;
    end;

end;

function MAN:draw()

	if not self.helpPanel then
			renderText(0.8335, 0.17, 0.02, "0: Info be");
		else
			renderText(0.8335, 0.17, 0.02, "0: Info ki");
		end;
		if self.helpPanel then
			renderText(0.02, 0.6, 0.025, "- MAN F2000 -");
			renderText(0.02, 0.58, 0.02, "NUM 0: Bogi tengely fel/le");
	end;

end;

function MAN:onEnter()

end;

function MAN:onLeave()

    self.brakelightsActive = false;
    self.backlightsActive = false;

end;

function MAN:anim(varName, loopCheck)
	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
		end;
	end;
end; 


function MAN:connectCollisions(varName)
	local Collision = self.collisionArm[varName];
	local constr = JointConstructor:new();
	constr:setActors(self.rootNode, Collision.collision);
	constr:setJointTransforms(Collision.armAttacher, Collision.collisionAttacher);
	for i=1, 3 do		            
		constr:setRotationLimit(i-1, 0, 0, 0);
		constr:setTranslationLimit(i-1, true, 0, 0);
	end;
	Collision.index = constr:finalize();
end;
