--
-- Marshall feed trailer
-- Class for feed trailer
--
-- @author  PeterJ_LS-UK modteam
-- @date  19/02/2012
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.


Marshall_Feeder = {};

function Marshall_Feeder.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Marshall_Feeder:load(xmlFile)

	self.baleValue = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.bale#value"), 0.0);
	self.triggerCallback = Marshall_Feeder.triggerCallback;

	local trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bale#trigger"));
	if trigger ~= nil then
		self.trigger = trigger;
		addTrigger(self.trigger, "triggerCallback", self);
	else
		print("Error: Missing bale trigger");
	end;
	
	self.ableCowsEat = true;
	self.eatSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animals#eatSpeed"), 0.0);
end;

function Marshall_Feeder:delete()
	removeTrigger(self.trigger);
end;

function Marshall_Feeder:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Marshall_Feeder:keyEvent(unicode, sym, modifier, isDown)
end;

function Marshall_Feeder:update(dt)


end;

function Marshall_Feeder:updateTick(dt)

	if self.isClient then
		local nearestDistance = 5.0;
		local px, py, pz = getWorldTranslation(self.components[1].node);
		for i=1, table.getn(g_currentMission.attachables) do
			local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
			if distance < nearestDistance then
				local attachable = g_currentMission.attachables[i];		
				if attachable.fruitTypes == self.fruitTypes and attachable.fillLevel ~= nil and attachable ~= self then
					if self.currentFillType ~= attachable.currentFillType and attachable.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
						if self.fillLevel < self.capacity and self.fillLevel > 1 then
							self.currentFillType = attachable.currentFillType;
						end;
					end;
				end;
			end;
		end;
		if self.ableCowsEat then
			local cowsStored = AnimalHusbandry.getNumberOfAnimals();
			if cowsStored > 0 then
				self:setFillLevel(self.fillLevel - (cowsStored / self.eatSpeed), self.currentFillType);
			end;
		end;
	end;

end;

function Marshall_Feeder:draw()
	if self.isClient then
		if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
			local fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
			if fruitType ~= nil then
				g_currentMission:setFruitOverlayFruitType(fruitType);
			end;
		end;
	end;
end;

function Marshall_Feeder:onAttach(attacherVehicle)
	self.ableCowsEat = false;
end;
 
function Marshall_Feeder:onDetach()
	self.ableCowsEat = true;
end;

function Marshall_Feeder:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter or onStay then
		if otherId ~= 0 then
			local object = g_currentMission:getNodeObject(otherId);
			if object ~= nil then
				if object:isa(Bale) then
					if g_currentMission:getIsServer() then
						if (self.fillLevel + self.baleValue) < self.capacity then
							if self.fillLevel > 0 then 
								self:setFillLevel(self.fillLevel + self.baleValue, self.currentFillType);
							else
								self:setFillLevel(self.fillLevel + self.baleValue, Fillable.FILLTYPE_GRASS);
							end;
							object:delete();
						end;
					end;
				end;
			end;
		end;
	end;
end;