-- attachVehicles
-- Specialization for Tieflader.
-- @ Geri-G, ls-modsource.com
-- @ date : 22/02/2010

-- Edited by Henly20 www.ls-uk.info 05/08/2010


forkattacher = {};

function forkattacher.prerequisitesPresent(specializations)
    return true;
end;

function forkattacher:load(xmlFile)

	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");

	self.GetVehiclesInRange = forkattacher.GetVehiclesInRange;
	self.attachVehicles = forkattacher.attachVehicles;
	self.detachVehicles = forkattacher.detachVehicles;
	self.Attachers={};
	self.PF={};
	local Parent = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Attacher#ParentIndex"));
	local Parent2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Attacher#PlaceFinderParent"));
	local numAttachers = getNumOfChildren(Parent);
	local numPlaceFinders = getNumOfChildren(Parent2);
	for i=1, numAttachers do
		self.Attachers[i] = {};
		self.Attachers[i].node = getChildAt(Parent, i-1);
		self.Attachers[i].attachedObject = nil;
	end;	
	for j=1, numPlaceFinders do
		self.PF[j] = {};
		self.PF[j].Transform = getChildAt(Parent2, j-1);
	end;
	self.once = true;
	self.onceActive = true;	

end;

function forkattacher:delete()
end;

function forkattacher:readStream(streamId, connection)
      local turnedOn = streamReadBool(streamId);
      self:setIsTurnedOn(turnedOn, true);
end;

function forkattacher:writeStream(streamId, connection)
      streamWriteBool(streamId, self.isTurnedOn);
end;

function forkattacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function forkattacher:keyEvent(unicode, sym, modifier, isDown)

end;

function forkattacher:update(dt)

      if self:getIsActiveForInput() then
              if InputBinding.hasEvent(InputBinding.ATTACHOBJECT) then
                  self:setIsTurnedOn(not self.isTurnedOn);
              end;
      end;

end;

function forkattacher:updateTick(dt)

	if self:getIsActive() then
		if self.isTurnedOn then
			local nearestVehicles = {};
            if self.once then
				self.nearestVehicles = {self:GetVehiclesInRange()};
				self.once = false;
			end;
			for i = 1, table.getn(self.nearestVehicles) do
				self:attachVehicles(self.nearestVehicles[i], i);
			end;
        else
			self.once = true;
			for i = 1, table.getn(self.nearestVehicles) do
				self:detachVehicles(self.nearestVehicles[i], i);
			end;	
		end;
	end;
end;

function forkattacher:draw()
	if self:getIsActive() then
		if self.isTurnedOn then
			g_currentMission:addHelpButtonText(g_i18n:getText("UNLOCK"), InputBinding.IMPLEMENT_EXTRA3);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("LOCK"), InputBinding.IMPLEMENT_EXTRA3);
		end;
	end;
end;

function forkattacher:validateAttacherJoint(implement, jointDesc, dt)
	return true;
end;

function forkattacher:setIsTurnedOn(turnedOn, noEventSend)
	SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
	self.isTurnedOn = turnedOn;
end;

function forkattacher:attachVehicles(node, k)
	if self.Attachers[k].node ~= nil and self.Attachers[k].attachedObject == nil then 			
		--JointTranslation Anpassung an das Objekt
		local xw, yw, zw = getWorldTranslation(node.components[1].node);		
		local x,y,z = worldToLocal(getParent(self.Attachers[k].node), xw, yw, zw);	
		setTranslation(self.Attachers[k].node, x,y,z);			
		--JointRotation Anpassung an das Objekt
		local zX, zY, zZ = localDirectionToWorld(node.components[1].node, 0,0,1);
		local zX, zY, zZ = worldDirectionToLocal(getParent(self.Attachers[k].node), zX, zY, zZ);
		local yX, yY, yZ = localDirectionToWorld(node.components[1].node, 0,1,0);
		local yX, yY, yZ = worldDirectionToLocal(getParent(self.Attachers[k].node), yX, yY, yZ);
		setDirection(self.Attachers[k].node, zX, zY, zZ, yX, yY, yZ);
		
		if node.enterReferenceNode == nil then
			node:onAttach(self);
		end;
		--anhaengen
		local constr = JointConstructor:new();					
		constr:setActors(self.components[1].node, node.components[1].node);
		constr:setJointTransforms(self.Attachers[k].node,  node.components[1].node);
		for i=1, 3 do		                    
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1, 0, 0);
		end;		
		self.Attachers[k].attachedObject = constr:finalize();
	end;
end;

function forkattacher:detachVehicles(node, k)
	if self.Attachers[k].attachedObject ~= nil then	
		node.attacherVehicle = nil;
		
		if node.enterReferenceNode == nil then
			node:onDetach(self);
		end;		
		removeJoint(self.Attachers[k].attachedObject);
		self.Attachers[k].attachedObject = nil;
		
		setTranslation(self.Attachers[k].node,0,0,0);
		setRotation(self.Attachers[k].node,0,0,0);
	end;
end;

function forkattacher:GetVehiclesInRange()
	local nearestNode = {};
	local nearestDistance = 2;
	for u,obj in pairs(self.PF) do
		local px, py, pz = getWorldTranslation(obj.Transform);
		
		for k,v in pairs(g_currentMission.vehicles) do
			if v ~= self and v ~= self.attacherVehicle then
				local x,y,z = getWorldTranslation(v.components[1].node);
				local distance = Utils.vector3Length(px-x, py-y, pz-z);
				if distance < nearestDistance then
					if table.getn(nearestNode)+1 <= table.getn(self.Attachers) then
						nearestNode[table.getn(nearestNode)+1] = v;
					end;
				end;
			end;
		end;
	end;
	return unpack(nearestNode)
end;

function forkattacher:onDetach()
	self.onceActive = false;
	self.isTurnedOn = false;
end;

function forkattacher:onAttach(attacherVehicle)

	self.isTurnedOn = true;
end;
