--
-- Fork Combo
-- Class for fork combo
--
-- @author  PeterJ_LS-UK modteam
-- @date  01/03/2012
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Fork_Combo = {};

function Fork_Combo.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Fork_Combo:load(xmlFile)

	self.setHookMounted = SpecializationUtil.callSpecializationsFunction("setHookMounted");
	self.HookMountedAnimation = getXMLString(xmlFile, "vehicle.forkHook#animationName");
	self.hookOnFork = false;

	self.hook = {};
	self.hook[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.hook#index1"));
	self.hook[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.hook#index2"));

end;

function Fork_Combo:readStream(streamId, connection)
    self:setHookMounted(streamReadBool(streamId), true);
end;

function Fork_Combo:writeStream(streamId, connection)
	streamWriteBool(streamId, self.hookOnFork);
end;

function Fork_Combo:delete()
end;

function Fork_Combo:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local hookOnFork = getXMLBool(xmlFile, key.."#hookMounted");
	if hookOnFork ~= nil then
		self:setHookMounted(hookOnFork);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function Fork_Combo:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'hookMounted="'..tostring(self.hookOnFork)..'"';
	return attributes, nil;
end;

function Fork_Combo:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fork_Combo:keyEvent(unicode, sym, modifier, isDown)
end;

function Fork_Combo:update(dt)
	if not self:getIsActive() then
		if not self.isImplementAttached then
			if self.playerInRange then
				if self.hookOnFork then
					g_currentMission:addHelpButtonText(g_i18n:getText("HOOKOFF"), InputBinding.IMPLEMENT_EXTRA2);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("HOOKON"), InputBinding.IMPLEMENT_EXTRA2);
				end;
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					self:setHookMounted(not self.isHookMounted);
				end;
			end;
		end;
		if self.hookOnFork then
			setVisibility(self.hook[1], true);
			setVisibility(self.hook[2], false);
		else
			setVisibility(self.hook[1], false);
			setVisibility(self.hook[2], true);
		end;
	end;
end;

function Fork_Combo:updateTick(dt)
	if g_currentMission.player ~= nil then
		local nearestDistance = 2.0;
		local x1,y1,z1 = getWorldTranslation(self.components[1].node);
		local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance < nearestDistance then
			self.playerInRange = true; 
		else
			self.playerInRange = false; 
		end;
	end;
end;

function Fork_Combo:draw()
end;

function Fork_Combo:onAttach(attacherVehicle)
end;
 
function Fork_Combo:onDetach()
end;

function Fork_Combo:attachImplement(implement)
	self.isImplementAttached = true;
end;

function Fork_Combo:detachImplement(implement)
	self.isImplementAttached = false;
end;

function Fork_Combo:setHookMounted(hookMounted,noEventSend)
	SetLoweredMaxEvent.sendEvent(self, hookMounted, noEventSend);
	-- Play Hook Mounted animation --
	self.isHookMounted = hookMounted;
	if self.isHookMounted then
		if self.HookMountedAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.HookMountedAnimation, -1, nil, true);
			self.hookOnFork = true;
		end;
	else
		if self.HookMountedAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.HookMountedAnimation, 1, nil, true);
			self.hookOnFork = false;
		end;
	end;
end;

SetLoweredMaxEvent = {};
SetLoweredMaxEvent_mt = Class(SetLoweredMaxEvent, Event);

InitEventClass(SetLoweredMaxEvent, "SetLoweredMaxEvent");

function SetLoweredMaxEvent:emptyNew()
    local self = Event:new(SetLoweredMaxEvent_mt);
    self.className="SetLoweredMaxEvent";
    return self;
end;

function SetLoweredMaxEvent:new(vehicle, hookMounted)
    local self = SetLoweredMaxEvent:emptyNew()
    self.vehicle = vehicle;
	self.hookMounted = hookMounted;
    return self;
end;

function SetLoweredMaxEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.hookMounted = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLoweredMaxEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.hookMounted);
end;

function SetLoweredMaxEvent:run(connection)   
	self.vehicle:setHookMounted(self.hookMounted, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLoweredMaxEvent:new(self.vehicle, self.hookMounted), nil, connection, self.vehicle);
    end;
end;

function SetLoweredMaxEvent.sendEvent(vehicle, hookMounted, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLoweredMaxEvent:new(vehicle, hookMounted), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLoweredMaxEvent:new(vehicle, hookMounted));
		end;
	end;
end;
