SetTransportEvent = {};
SetTransportEvent_mt = Class(SetTransportEvent, Event);

InitEventClass(SetTransportEvent, "SetTransportEvent");

function SetTransportEvent:emptyNew()
    local self = Event:new(SetTransportEvent_mt);
    self.className="SetTransportEvent";
    return self;
end;

function SetTransportEvent:new(vehicle, isTransportState)
    local self = SetTransportEvent:emptyNew()
    self.vehicle = vehicle;
	self.isTransportState = isTransportState;
    return self;
end;

function SetTransportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isTransportState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetTransportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isTransportState);
end;

function SetTransportEvent:run(connection)   
	self.vehicle:setTransport(self.isTransportState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTransportEvent:new(self.vehicle, self.isTransportState), nil, connection, self.vehicle);
    end;
end;

function SetTransportEvent.sendEvent(vehicle, isTransportState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTransportEvent:new(vehicle, isTransportState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTransportEvent:new(vehicle, isTransportState));
		end;
	end;
end;