--
-- RopeBreakdown
-- Specialization for New Holland BB 980 from Strawmod to get it breakable due to a lack of rope.
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		30/11/10
--

RopeBreakdown = {};

function RopeBreakdown.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(BalerVariableChamber, specializations);
end;

function RopeBreakdown:load(xmlFile)
	self.SetCoverEdgeDoorPanel= SpecializationUtil.callSpecializationsFunction("SetCoverEdgeDoorPanel");
	self.SetSideDoorPanel= SpecializationUtil.callSpecializationsFunction("SetSideDoorPanel");
	self.SetHasRopes= SpecializationUtil.callSpecializationsFunction("SetHasRopes");
	-- Animation --
	self.CoverEdgeDoorPanelAnimation = getXMLString(xmlFile, "vehicle.CoverEdgeDoorPanel#animationName");
	self.CoverEdgeDoorPanel = true;
	self.SideDoorPanelAnimation = getXMLString(xmlFile, "vehicle.SideDoorPanel#animationName");
	self.SideDoorPanel = true;
	-- Ropes management --
	self.Ropes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ropes#index"));
	self.RopesCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Ropes#Capacity"), 4);
	self.hasRopes = true;
	self.isLoaded = true;
	-- Sound for "no Ropes " --
    NoRopeSoundFile = Utils.getFilename("Sounds/NoRope.ogg", self.baseDirectory);
    self.NoRopeSoundId = createSample("NoRopeSound");
    loadSample(self.NoRopeSoundId, NoRopeSoundFile, false);
    self.NoRopePlaying = false;


end;

function RopeBreakdown:delete()
    if self.NoRopeSound ~= nil then
        delete(self.NoRopeSound);
    end;
end;

function RopeBreakdown:readStream(streamId, connection)
    self:SetCoverEdgeDoorPanel(streamReadBool(streamId), true);
	self:SetSideDoorPanel(streamReadBool(streamId), true);
    self:SetHasRopes(streamReadBool(streamId), true);
end;

function RopeBreakdown:writeStream(streamId, connection)
    streamWriteBool(streamId, self.CoverEdgeDoorPanel);
	streamWriteBool(streamId, self.SideDoorPanel);
    streamWriteBool(streamId, self.isLoaded);
end;

function RopeBreakdown:readUpdateStream(streamId, timestamp, connection)
end;

function RopeBreakdown:writeUpdateStream(streamId, connection, dirtyMask)
end;

function RopeBreakdown:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RopeBreakdown:keyEvent(unicode, sym, modifier, isDown)
end;

function RopeBreakdown:update(dt)
	-- Manage key events --
	if self.inrange then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:SetSideDoorPanel(not self.SideDoorPanel);
		end;
		if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
			self:SetCoverEdgeDoorPanel(not self.CoverEdgeDoorPanel);
		end;
		if not self.isLoaded then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
				if g_currentMission.missionStats.money > 10000 or g_currentMission.missionStats.money == 10000 then
					self:SetHasRopes(true);
				end;
			end;
		end;
	end;
	-- trigger the breakdown --
	if self.NoRopesBalesCount >= self.RopesCapacity then
		self:SetHasRopes(false);
	end;
	-- Display key when in range --
	if self.inrange then
		if self.SideDoorPanel then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("OPEN_SIDE_DOOR"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("CLOSE_SIDE_DOOR"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		end;
		if self.CoverEdgeDoorPanel then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("OPEN_COVEREDGE_DOOR"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("CLOSE_COVEREDGE_DOOR"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);
			if not self.isLoaded then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("RELOAD_ROPES"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
			end;
		end;
	end;
end;

function RopeBreakdown:updateTick(dt)
	if self.attacherVehicle and g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode);
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.inrange = true;
		else
			self.inrange = false;
		end;
	end;
end;

function RopeBreakdown:SetCoverEdgeDoorPanel(isCoverEdgeDoorPanel,noEventSend)
	SetCoverEdgeDoorPanelEvent.sendEvent(self, isCoverEdgeDoorPanel, noEventSend);
	-- Play doorPanel animation if inRange --
		if isCoverEdgeDoorPanel then
			if self.CoverEdgeDoorPanelAnimation ~= nil and self.playAnimation ~= nil then
				self:playAnimation(self.CoverEdgeDoorPanelAnimation, -1, nil, true);
				self.CoverEdgeDoorPanel = true;
			end;
		else
			if self.CoverEdgeDoorPanelAnimation ~= nil and self.playAnimation ~= nil then
				self:playAnimation(self.CoverEdgeDoorPanelAnimation, 1, nil, true);
				self.CoverEdgeDoorPanel = false;
			end;
		end;
end;

function RopeBreakdown:SetSideDoorPanel(isSideDoorPanel,noEventSend)
	SetSideDoorPanelEvent.sendEvent(self, isSideDoorPanel, noEventSend);
	-- Play doorPanel animation if inRange --
		if isSideDoorPanel then
			if self.SideDoorPanelAnimation ~= nil and self.playAnimation ~= nil then
				self:playAnimation(self.SideDoorPanelAnimation, -1, nil, true);
				self.SideDoorPanel = true;
			end;
		else
			if self.CoverEdgeDoorPanelAnimation ~= nil and self.playAnimation ~= nil then
				self:playAnimation(self.SideDoorPanelAnimation, 1, nil, true);
				self.SideDoorPanel = false;
			end;
		end;
end;

function RopeBreakdown:SetHasRopes(isLoaded,noEventSend)
	self.isLoaded = isLoaded;
	SetHasRopesEvent.sendEvent(self, self.isLoaded, noEventSend);
	if self.isLoaded then
		self.NoRopesBalesCount = 0;
		setVisibility(self.Ropes, true);
		if self.NoRopePlaying then
			stopSample(self.NoRopeSoundId);
			self.NoRopePlaying = false;
		end;
		g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + 10000;
		g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + 10000;

		g_currentMission.missionStats.money = g_currentMission.missionStats.money - 10000;
	else
		setVisibility(self.Ropes, false);
		self:setPickup(false, true);
		if self:getIsActiveForSound() then
			if not self.NoRopePlaying then
				playSample(self.NoRopeSoundId, 1, 1, 0);
				self.NoRopePlaying = true;
			end;
		end;
	end;
end;

function RopeBreakdown:draw()
	if not self.isLoaded then
		 g_currentMission:addWarning(g_i18n:getText("OUT_OF_NET_1") .. "\n" .. g_i18n:getText("OUT_OF_NET_2"), 0.07+0.022, 0.019+0.029);
	end;
--~ 	setTextBold(true);
--~ 	setTextColor(1, 1, 1, 1.0);
--~ 	if self.HUD then
--~ 		if not self.isLoaded then
--~ 			renderText(0.542, 0.918, 0.015, string.format("No Ropes"));
--~ 		end;
--~ 	end;
end;

