--
-- InteractiveControlPanel
-- Specialization for InteractiveControlPanel
--
-- @author:  	Manuel Leithner
-- @date:		20/10/10
-- @version:	v2.0
-- @history:	v1.0 - initial implementation
--				v2.0 - Converted to LS2011
--

InteractiveControlPanel = {};

function InteractiveControlPanel.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(BalerVariableChamber, specializations);
end;

function InteractiveControlPanel:load(xmlFile)

	source(Utils.getFilename("Scripts/InteractiveComponentInterface.lua", self.baseDirectory));

	self.detachPosition = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#detachPosition"));
	self.controlPanel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#index"));
	self.mark = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#highlight"));
	self.highlight = getChildAt(self.mark,0);

	local overlays = {};
	local buttons = {};

	local bgX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.controlPanel#xPos"), 0.71);
	local bgY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.controlPanel#yPos"), 0.375);

    self.panelSound = createSample("panelSample");
    loadSample(self.panelSound, Utils.getFilename("ControlPanel/peeptone.wav", self.baseDirectory), false);

	-- add main background overlay
	table.insert(overlays, Overlay:new("controlPanelBG", Utils.getFilename("ControlPanel/JohnDeere_controlPanel_bg_diffuse.png", self.baseDirectory), bgX, bgY,0.285,0.35));
	table.insert(overlays, Overlay:new("controlPanelBG_overlay", Utils.getFilename("ControlPanel/JohnDeere_controlPanel_bg_diffuse.png", self.baseDirectory), bgX, bgY,0.285,0.35));

	table.insert(buttons, Overlay:new("controlButtonClose",    Utils.getFilename("ControlPanel/JohnDeere_controlPanel_close_diffuse.png", self.baseDirectory),bgX+0.056, bgY+0.265, 0.020, 0.030));
	table.insert(buttons, Overlay:new("controlButtonPlus",  Utils.getFilename("ControlPanel/JohnDeere_controlPanel_increase_button_diffuse.png", self.baseDirectory),bgX+0.212,  bgY+0.092, 0.029, 0.04));
	table.insert(buttons, Overlay:new("controlButtonMinus",  Utils.getFilename("ControlPanel/JohnDeere_controlPanel_decrease_button_diffuse.png", self.baseDirectory),bgX+0.212,  bgY+0.044, 0.029, 0.04));
	table.insert(buttons, Overlay:new("controlButtonStartStop",    Utils.getFilename("ControlPanel/JohnDeere_controlPanel_onOff_button_diffuse.png", self.baseDirectory),bgX+0.05205, bgY+0.19, 0.029, 0.04));
	table.insert(buttons, Overlay:new("controlButtonWrapBale",    Utils.getFilename("ControlPanel/JohnDeere_controlPanel_wrap_button_diffuse.png", self.baseDirectory),bgX+0.087, bgY+0.044, 0.029, 0.04));
	table.insert(buttons, Overlay:new("controlButtonCapacity",  Utils.getFilename("ControlPanel/JohnDeere_controlPanel_coverEdge_twine_button_diffuse.png", self.baseDirectory), bgX+0.05205, bgY+0.14, 0.029, 0.04));

	-- create new control panel instance
	self.interactiveControlPanel = JD864ControlPanel:new(self.controlPanel, self.highlight, self.mark, "Control Panel", 0.1, overlays, buttons, self.panelSound, self);
	self.attacherVehicleCopy = nil;

end;

function InteractiveControlPanel:delete()
end;

function InteractiveControlPanel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveControlPanel:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveControlPanel:update(dt)
end;

function InteractiveControlPanel:draw()
end;

function InteractiveControlPanel:onAttach(attacherVehicle)
	self.attacherVehicleCopy = attacherVehicle;
	self.interactiveControlPanel:setVisible(Utils.getNoNil(attacherVehicle.isMouseActive,false));
	if attacherVehicle.addControlPanel ~= nil then
		local wasSuccessful = attacherVehicle:addControlPanel(self);
	end;
end;

function InteractiveControlPanel:onDetach()
	if self.attacherVehicleCopy.removeControlPanel ~= nil then
		local wasSuccessful = self.attacherVehicleCopy:removeControlPanel(self);
		self.interactiveControlPanel.isOpen = false;
	end;

	self.attacherVehicleCopy = nil;
end;


--
-- BogballeControlPanel Class
-- Specialization for BogballeControlPanel
--
-- @author:  	Manuel Leithner
-- @date:		20/10/10
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
--

JD864ControlPanel = {};
function JD864ControlPanel:new(node, highlight, mark, name, size, overlays, buttons, sound, controlledAttachable)

	local JD864ControlPanel_mt = Class(JD864ControlPanel, InteractiveComponentInterface);
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, nil, nil, JD864ControlPanel_mt);

	instance.onMessage = g_i18n:getText("ic_component_open");
	instance.offMessage = g_i18n:getText("ic_component_close");
	instance.controlledAttachable = controlledAttachable;
	instance.sound = sound;
	instance.overlays = overlays;
	if instance.overlays == nil then
		instance.overlays = {};
	end;

	self.currentDisplay = 1;

	-- add buttons
	local actionEvent = instance.onPanelAction;
	for k,v in pairs(buttons) do
		table.insert(instance.overlays, OverlayNumberedButton:new(v, k, actionEvent, instance, {1, 1, 1, 0.8}));
	end;
	instance.mainBackground = instance.overlays[1];

	instance.bgX = instance.mainBackground.x;
	instance.bgY = instance.mainBackground.y;

	return instance;
end;


function JD864ControlPanel:delete()
	for k,v in pairs(self.overlays) do
		v:delete();
	end;
	InteractiveComponentInterface.delete(self);
end;

function JD864ControlPanel:mouseEvent(posX, posY, isDown, isUp, button)
	if self.isOpen then
		for k,v in pairs(self.overlays) do
			v:mouseEvent(posX, posY, isDown, isUp, button);
		end;
	end;
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function JD864ControlPanel:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function JD864ControlPanel:update(dt)
	if self.hydraulic ~= nil then
		local x,y,z = getRotation(self.node);
		local a,b,c = unpack(self.lastRotation);
		if math.abs(math.abs(x) - a) > 0.001 or math.abs(math.abs(y) - b) > 0.001 or math.abs(math.abs(z) - c) > 0.001 then
			for k,hydraulic in pairs(self.hydraulic) do
				local ax, ay, az = getWorldTranslation(hydraulic.node);
				local bx, by, bz = getWorldTranslation(hydraulic.InteractiveControlPanelFixPoint);
				local dx, dy, dz = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
				setDirection(hydraulic.node, dx, dy, dz, 0, 1, 1);
				if hydraulic.punch ~= nil then
					local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
					setTranslation(hydraulic.punch, 0, 0, (distance-hydraulic.punchDistance));
				end;
			end;
			self.lastRotation = {math.abs(x), math.abs(y), math.abs(z)};
		end;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function JD864ControlPanel:draw()
	local machine = self.controlledAttachable;
	if machine == nil then
		self.currentDisplay = 0;
	end;
	if self.isOpen then
		for k,v in pairs(self.overlays) do
			if k == 2 then
				if self.currentDisplay ~= 0 then
					v:render();
				end;
			else
				v:render();
			end;
		end;
		setTextColor(0.2078, 0.22, 0.1921, 1);
		setTextBold(false);
		if self.currentDisplay ~= 0 then

			if self.currentDisplay ~= 0 then
				local offset = 0;
				if machine.currentBaleSize < 1000 then
					offset = 1;
					if machine.currentBaleSize < 100 then
						offset = 2;
						if machine.currentBaleSize < 10 then
							offset = 3;
						end;
					end;
				end;
--~ 				renderText(self.bgX+0.035, self.bgY+0.452, 0.015, g_i18n:getText("bogballe_fillLevel"));
--~ 				renderText(self.bgX+0.035 + offset*0.0115, self.bgY+0.423, 0.03, string.format("%d", machine.fillLevel));
--~ 				renderText(self.bgX+0.083, self.bgY+0.4272, 0.015, "Kg");

--~ 				--renderText(self.bgX+0.11,  self.bgY+0.4272-0.055, 0.015, string.format("(Step: %s)", machine.currentStep));
--~ 				renderText(self.bgX+0.035, self.bgY+0.452 - 0.055, 0.015, g_i18n:getText("bogballe_maxCapacity"));
--~ 				renderText(self.bgX+0.035, self.bgY+0.423 - 0.055, 0.03,  string.format("%d", machine.capacity));
--~ 				renderText(self.bgX+0.083, self.bgY+0.4272- 0.055, 0.015, "Kg");


--~  				--renderText(self.bgX+0.0405, self.bgY+0.423 - 0.143, 0.03,  string.format("%d", machine.settings.literPerHa.current));
--~ 				renderText(self.bgX+0.077, self.bgY+0.4272- 0.143, 0.015, "Kg/Ha");
				--renderText(self.bgX+0.12, self.bgY+0.4255 - 0.143, 0.022,  string.format("%d", machine.currentBaleSize));
				--renderText(self.bgX+0.14, self.bgY+0.4272 - 0.143, 0.015, "m");


--~ 				local lastSpeed =  math.floor((Utils.getNoNil(machine.attacherVehicle.lastSpeed, 0) * 3600)*10)/10;
--~ 				local speed = tostring(lastSpeed);
--~ 				local maxLen = 1;
--~ 				if lastSpeed > 10 then
--~ 					maxLen = 2;
--~ 				end;
--~ 				if string.len(speed) <= maxLen then
--~ 					speed = speed .. ".0";
--~ 				end;
--~ 				offset = 0;
--~ 				if string.len(speed) < 4 then
--~ 					offset = 1;
--~ 				end;
--~ 				renderText(self.bgX+0.035 + offset*0.0115, self.bgY+0.423 - 0.179, 0.03,  speed);
--~ 				renderText(self.bgX+0.077,  			   self.bgY+0.4272- 0.179, 0.0145, "Km/h");
--~ 				local lastRPM = Utils.getNoNil(machine.attacherVehicle.motor.lastMotorRpm, 0);
--~ 				offset = 0;
--~ 				if lastRPM < 1000 then
--~ 					offset = 1;
--~ 					if lastRPM < 100 then
--~ 						offset = 2;
--~ 						if lastRPM < 10 then
--~ 							offset = 3;
--~ 						end;
--~ 					end;
--~ 				end;
--~ 				renderText(self.bgX+0.101 + offset*0.00843, self.bgY+0.4255 - 0.179, 0.022,  string.format("%d", lastRPM));
--~ 				renderText(self.bgX+0.137,  				self.bgY+0.4272 - 0.179, 0.015, "rpm");
			end;

			setTextColor(0, 0, 0, 1);
			if self.currentDisplay == 1 then -- baleSIze
				--renderText(self.bgX+0.1535, self.bgY+0.2 - 0.108, 0.015, g_i18n:getText("CURRENT_BALESIZE"));
				renderText(self.bgX+0.1472,  self.bgY+0.145, 0.03,  string.format("%d", machine.currentBaleSize));
				renderText(self.bgX+0.185,  self.bgY+0.1495, 0.015, "cm");
			elseif self.currentDisplay == 2 then -- current BaleCount
				--renderText(self.bgX+0.1535, self.bgY+0.2 - 0.108, 0.015, g_i18n:getText("CURRENT_AMOUNT_OF_BALES"));
				renderText(self.bgX+0.1475,  self.bgY+0.145, 0.03,  string.format("%d", machine.CurrentBalesCount));
				--renderText(self.bgX+0.083,  self.bgY+0.4272 - 0.1085, 0.015, "Kg");
			elseif self.currentDisplay == 3 then -- Total BaleCount
				--renderText(self.bgX+0.1535, self.bgY+0.2 - 0.108, 0.015, g_i18n:getText("TOTAL_BALES"));
				renderText(self.bgX+0.1475,  self.bgY+0.145, 0.03,  string.format("%d", machine.TotalBalesCount));
			end;
		else
--~ 			setTextBold(true);
--~ 			renderText(self.bgX+0.035, self.bgY+0.45, 0.016, "Interactive Control" );
--~ 			setTextBold(false);
--~ 			renderText(self.bgX+0.05, self.bgY+0.436, 0.015, "by SFM-Modding" );
--~ 			renderText(self.bgX+0.035, self.bgY+0.404, 0.015, "Idea: " );
--~ 			renderText(self.bgX+0.0945, self.bgY+0.404, 0.015, "steyr1" );
--~ 			renderText(self.bgX+0.035, self.bgY+0.388, 0.015, "Realization: Face" );
--~ 			renderText(self.bgX+0.035, self.bgY+0.372, 0.015, "Bugfixing:" );
--~ 			renderText(self.bgX+0.0945, self.bgY+0.372, 0.015, "MadMax" );
--~ 			renderText(self.bgX+0.0945, self.bgY+0.356, 0.015, "Morpheus" );
--~ 			renderText(self.bgX+0.035, self.bgY+0.335, 0.015, "Content:" );
--~ 			renderText(self.bgX+0.04, self.bgY+0.319, 0.015, "IC is a new control-" );
--~ 			renderText(self.bgX+0.04, self.bgY+0.303, 0.015, "model for LS. Now" );
--~ 			renderText(self.bgX+0.04, self.bgY+0.287, 0.015, "you can control your" );
--~ 			renderText(self.bgX+0.04, self.bgY+0.271, 0.015, "attached implements" );
--~ 			renderText(self.bgX+0.04, self.bgY+0.255, 0.015, "with this control panel!" );
--~ 			renderText(self.bgX+0.04, self.bgY+0.235, 0.015, "Have fun !" );
		end;
	end;
	InteractiveComponentInterface.draw(self);
end;

function JD864ControlPanel:doAction(dt)
	InteractiveComponentInterface.doAction(self,dt);
	local attacherVehicle = self.controlledAttachable.attacherVehicleCopy;
	if attacherVehicle ~= nil then
		if attacherVehicle.setPanelOverlay ~= nil then
			if self.isOpen then
				attacherVehicle:setPanelOverlay(self);
			else
				attacherVehicle:setPanelOverlay(nil);
			end;
		end;
	end;
end;

function JD864ControlPanel:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function JD864ControlPanel:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function JD864ControlPanel:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function JD864ControlPanel:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;

function JD864ControlPanel:onPanelAction(id)
	playSample(self.sound, 1, 0.1,0);
	local machine = self.controlledAttachable;
	if id == 1 then
		self:doAction();
	elseif id == 2 then
		if machine.currentBaleSize < machine.BALE_ORIGINAL then
			if table.getn(machine.bales) == 0 then
				machine:setIncreaseBaleSize(true); -- increase baleSize
			end;
		end;
	elseif id == 3 then
		if machine.currentBaleSize > machine.BALE_60CM then
			if table.getn(machine.bales) == 0 then
				machine:setDecreaseBaleSize(true); -- decrease baleSize
			end;
		end;
	elseif id == 4 then
		machine:setIsTurnedOn(not machine.isTurnedOn);
	elseif id == 5 then
		if machine.canNet == true and table.getn(machine.bales) == 0 then
			machine:setNetBale(true);
		end;
	elseif id == 6 then
		if self.currentDisplay == 3 then
			self.currentDisplay = 1;
		elseif self.currentDisplay == 1 then
			self.currentDisplay = 2;
		elseif self.currentDisplay == 2 then
			self.currentDisplay = 3;
		end;
	end;
end;
