-- sirrobin

autosteer = {};

function autosteer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function autosteer:load(xmlFile)

	self.setAutoSteer = SpecializationUtil.callSpecializationsFunction("setAutoSteer");
	
    self.maxRotatedTimeSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wheels.maxRotatedTimeSpeed#value"), 1.7)*0.001;

	self.maxRotatedTimeSpeed = 0;
	self.steeringLocked = true;	
	
	self.controlpath = Utils.getFilename("textures/steuerung_man.png", self.baseDirectory);
    self.button1PoxX = 0.9;
    self.button1PoxY = 0.75;
    self.button1Width = 0.08;
    self.button1Height = 0.085;
    self.button1Overlay = Overlay:new("button1", self.controlpath, self.button1PoxX, self.button1PoxY, self.button1Width, self.button1Height);
    self.button1Active = true;

	self.controlpath = Utils.getFilename("textures/steuerung_auto.png", self.baseDirectory);
    self.button2PoxX = 0.9;
    self.button2PoxY = 0.75;
    self.button2Width = 0.08;
    self.button2Height = 0.085;
    self.button2Overlay = Overlay:new("button2", self.controlpath, self.button2PoxX, self.button2PoxY, self.button2Width, self.button2Height);
    self.button2Active = true;
	
end;

function autosteer:readStream(streamId, connection)
      local lockedsteer = streamReadBool(streamId);
      self:setAutoSteer(lockedsteer, true);
end;

function autosteer:writeStream(streamId, connection)
      streamWriteBool(streamId, self.steeringLocked);
end;

function autosteer:keyEvent(unicode, sym, modifier, isDown)

end;

function autosteer:update(dt)

      if self:getIsActiveForInput() then
              if InputBinding.hasEvent(InputBinding.autosteer) then
                  self:setAutoSteer(not self.steeringLocked);
              end;
      end;

end;

function autosteer:updateTick(dt)

		if self.steeringLocked then
		   self.autoRotateBackSpeed	= 2.2
		   self.maxRotatedTimeSpeed = 1.7*0.001;
		else
		   self.autoRotateBackSpeed = 0.0
		   self.maxRotatedTimeSpeed = 0;
		end;
end;

function autosteer:draw()

	if self:getIsActive() then
		if self.steeringLocked then
			 if self.button2Overlay ~= nil then
				if self.button2Active then
				self.button2Overlay:render();
				end;
			end;
			else
			 if self.button1Overlay ~= nil then
				if self.button1Active then
				self.button1Overlay:render();
				end;
			end;
		end;
	end;
  
end;


function autosteer:onEnter()
  
end;

function autosteer:onLeave()
 
end;

function autosteer:delete()

end;

function autosteer:mouseEvent(posX, posY, isDown, isUp, button)

end;

function autosteer:setAutoSteer(lockedsteer, noEventSend)
      SetAutoSteerEvent.sendEvent(self, lockedsteer, noEventSend)
      self.steeringLocked = lockedsteer;
end;

SetAutoSteerEvent = {};
SetAutoSteerEvent_mt = Class(SetAutoSteerEvent, Event);
  
InitEventClass(SetAutoSteerEvent, "SetAutoSteerEvent");
  
function SetAutoSteerEvent:emptyNew()
     local self = Event:new(SetAutoSteerEvent_mt);
      self.className="SetAutoSteerEvent";
      return self;
end;
  
function SetAutoSteerEvent:new(object, lockedsteer)
      local self = SetAutoSteerEvent:emptyNew()
      self.object = object;
      self.lockedsteer = lockedsteer;
      return self;
end;
  
function SetAutoSteerEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.lockedsteer = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetAutoSteerEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.lockedsteer);
end;
  
function SetAutoSteerEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setAutoSteer(self.lockedsteer, true);
end;
  
function SetAutoSteerEvent.sendEvent(vehicle, lockedsteer, noEventSend)
      if lockedsteer ~= vehicle.steeringLocked then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetAutoSteerEvent:new(vehicle, lockedsteer), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetAutoSteerEvent:new(vehicle, lockedsteer));
              end;
          end;
      end;
end;