--
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

FahrShowHelp = {};

function FahrShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function FahrShowHelp:load(xmlFile)
	self.FahrShowHelp = false;
end;

function FahrShowHelp:delete()
end;

function FahrShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FahrShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function FahrShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.FahrShowHelp = not self.FahrShowHelp;
		end;
	end;
end;



function FahrShowHelp:updateTick(dt)
end;

function FahrShowHelp:draw()
	if not self.FahrShowHelp then
		renderText(0.76, 0.25, 0.02, "Info on: Numpad 0");
	 else
		renderText(0.76, 0.40, 0.02, "Numpad 0: Info of");
		renderText(0.76, 0.61, 0.02, "Numpad 1: Blinker left");
		renderText(0.76, 0.59, 0.02, "Numpad 2: Warninglights");
		renderText(0.76, 0.57, 0.02, "Numpad 3: Blinker right");
		renderText(0.76, 0.55, 0.02, "Numpad 5: Front worklights");
		renderText(0.76, 0.53, 0.02, "Numpad 6: Rear worklights");
		renderText(0.76, 0.51, 0.02, "Numpad 8: Autosteer");			
		renderText(0.76, 0.49, 0.02, "Key Page_Up: Raise ESL Limiter");
		renderText(0.76, 0.47, 0.02, "Key Page_Down: Lower ESL Limiter");
		renderText(0.76, 0.45, 0.02, "Key 0: Horn");
	end;
end;

function FahrShowHelp:onLeave()
	self.ClaasShowHelp = false;
end;




