plane = {};

function plane.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function plane:load(xmlFile)
	self.setplane = SpecializationUtil.callSpecializationsFunction("setplane"); 
    self.plane = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.plane#index"));
	self.planeA = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.planeA#index"));
	self.planeActive = false;
end;

function plane:delete()
end;

function plane:mouseEvent(posX, posY, isDown, isUp, button)
end;

function plane:keyEvent(unicode, sym, modifier, isDown)
end;

function plane:update(dt)
	if InputBinding.hasEvent(InputBinding.plane) and self:getIsActiveForInput() then
		self.planeActive = not self.planeActive;
		planeEvent.sendEvent(self, self.planeActive);
	end;
end;
function plane:updateTick(dt)
	if self.planeActive then
		setVisibility(self.plane, true);
		setVisibility(self.planeA, false);
	else
		setVisibility(self.plane, false);
		setVisibility(self.planeA, true)
	end;
end;

function plane:draw()
	if self.planeActive then
		g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.plane))..":                      " .." slozit plachtu");
	else
		g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.plane))..":                      " .." rozlozit plachtu");
	end;
end;

function plane:readStream(streamId, connection)
	self.planeActive = streamReadBool(streamId);
end;

function plane:writeStream(streamId, connection)
	streamWriteBool(streamId, self.planeActive);
end;