--
-- Moduliner
-- @poc@lypse
--
-- 	edit by gotchTOM
--	@date 01-Dez-2010 
-- mp ready Hummel (modhoster.de) 03.07.2011
-- 	add inputbindings, new infoPanel, rotationMax5Delay, rotationMax6Delay, cultivatorDelay, drumNodeRotaryDelay, sowingDelay, drivemark + drivemarkDelay, markwheels -> updatePloughArea or updateCultivatorArea   

source("dataS/scripts/vehicles/specializations/SowingMachineAreaEvent.lua");

Moduliner = {};

function Moduliner.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Moduliner:load(xmlFile)
	self.setStateEvent= SpecializationUtil.callSpecializationsFunction("setStateEvent");
	self.rotationMax5Delay = 2000;
	self.rotationMax6Delay = 2000;
	self.cultivatorDelay = 1000;
	self.drumNodeRotaryDelay = 1000;
	self.sowingDelay = 1500;
	self.drivemarkDelay = 2000;
	self.drivemark = false;
	self.helpPanel = false;
    self.numtravails = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.travails#count"), 0);
    self.travails = {};
    for i=1, self.numtravails do
        local travailnamei = string.format("vehicle.travails.travail" .. "%d", i);
        self.travails[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, travailnamei .. "#index"));
        setVisibility(self.travails[i], false);
    end;
	self.seedPerSqm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.seedPerSqm#value"), 1);
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	self.threshingParticleSystems1 = {};
    local psName = "vehicle.threshingParticleSystem1";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems1, psName, self.rootNode, false)
	
	self.threshingParticleSystems2 = {};
    local psName = "vehicle.threshingParticleSystem2";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems2, psName, self.rootNode, false)
	
	self.threshingParticleSystems3 = {};
    local psName = "vehicle.threshingParticleSystem3";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems3, psName, self.rootNode, false)
   
    self.threshingParticleSystems4 = {};
    local psName = "vehicle.threshingParticleSystem4";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems4, psName, self.rootNode, false)
	
	self.threshingParticleSystems5 = {};
    local psName = "vehicle.threshingParticleSystem5";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems5, psName, self.rootNode, false)
	
	self.threshingParticleSystems6 = {};
    local psName = "vehicle.threshingParticleSystem6";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems6, psName, self.rootNode, false)

      local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    self.cuttingAreas = {}
    for i=1, numCuttingAreas do
        self.cuttingAreas[i] = {};
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea" .. "%d", i); 
        self.cuttingAreas[i].start = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.cuttingAreas[i].width = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.cuttingAreas[i].height = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

   
--	self.literMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sowingOptions#multiplicator"), 1);
--	self.capacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sowingOptions#capacity"), 6000);
	
    local translationPartNodebequille1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bequille1#index"));
    if translationPartNodebequille1 ~= nil then
        self.translationPartbequille1 = {};
        self.translationPartbequille1.node = translationPartNodebequille1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bequille1#minTrans"));
        self.translationPartbequille1.minTrans = {};
        self.translationPartbequille1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartbequille1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartbequille1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bequille1#maxTrans"));
        self.translationPartbequille1.maxTrans = {};
        self.translationPartbequille1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartbequille1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartbequille1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartbequille1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bequille1#transTime"), 2)*1000;
        self.translationPartbequille1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bequille1#touchTransLimit"), 10);
    end;

    ----- Relevage barre de semis

    local rotationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart#index"));
    if rotationPartNode ~= nil then
        self.rotationPart = {};
        self.rotationPart.node = rotationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#minRot"));
        self.rotationPart.minRot = {};
        self.rotationPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#maxRot"));
        self.rotationPart.maxRot = {};
        self.rotationPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#rotTime"), 2)*1000;
        self.rotationPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#touchRotLimit"), 10));
    end;

    local translationPartNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart1#index"));
    if translationPartNode1 ~= nil then
        self.translationPart1 = {};
        self.translationPart1.node = translationPartNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart1#minTrans"));
        self.translationPart1.minTrans = {};
        self.translationPart1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart1.minTrans[3] = Utils.getNoNil(z, 0);
	print ("load doTranslate and transMax")
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart1#maxTrans"));
        self.translationPart1.maxTrans = {};
        self.translationPart1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart1#transTime"), 2)*1000;
        self.translationPart1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart1#touchTransLimit"), 10);
        self.rotationPart.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart1#pivotverin"));
    end;

   local rotationPartNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
    if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
        self.rotationPart1.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart1#pivotverin"));        
    end;

        local rotationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
    if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
        self.rotationPart2.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart2#pivotverin"));        
    end;

      local rotationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
    if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
      end;

        local rotationPartNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
    if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
end;
       local rotationPartNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart5#index"));
    if rotationPartNode5 ~= nil then
        self.rotationPart5 = {};
        self.rotationPart5.node = rotationPartNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#minRot"));
        self.rotationPart5.minRot = {};
        self.rotationPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#maxRot"));
        self.rotationPart5.maxRot = {};
        self.rotationPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#rotTime"), 2)*1000;
        self.rotationPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#touchRotLimit"), 10));
 end;

    local rotationPartNode6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart6#index"));
    if rotationPartNode6 ~= nil then
        self.rotationPart6 = {};
        self.rotationPart6.node = rotationPartNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#minRot"));
        self.rotationPart6.minRot = {};
        self.rotationPart6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#maxRot"));
        self.rotationPart6.maxRot = {};
        self.rotationPart6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#rotTime"), 2)*1000;
        self.rotationPart6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#touchRotLimit"), 10));
 end;   
	self.verin = {};
	self.verin.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin#indexverin"));
	self.verin.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin#indextige"));
	self.verin.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin.tige);
    local bx, by, bz = getWorldTranslation(self.verin.translationtige);
    self.verin.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz); 

    self.verin1 = {};
	self.verin1.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indexverin"));
	self.verin1.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indextige"));
	self.verin1.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin1.tige);
    local bx, by, bz = getWorldTranslation(self.verin1.translationtige);
    self.verin1.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

    self.verin2 = {};
	self.verin2.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#indexverin"));
	self.verin2.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#indextige"));
	self.verin2.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin2.tige);
    local bx, by, bz = getWorldTranslation(self.verin2.translationtige);
	self.verin2.tigeDistance = Utils.vector3Length(bx-ax, by-ay, bz-az);
--    self.verin2.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

  ----- depliage rotative

  local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 2)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;
	
	
	local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;

     local translationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);
	print ("load doTranslate and transMax")
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end;

    self.drumNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index"));
	self.drumNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index2"));
	self.drumNodeRotary = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index"));
	self.drumNodeRotary2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index2"));
	self.drumNodeRotary3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index3"));
	self.drumNodeRotary4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index4"));
	self.drumNodeRotary5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index5"));
	self.drumNodeRotary6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index6"));
	self.drumNodeRotary7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index7"));
	self.drumNodeRotary8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index8"));
	self.drumNodeRotary9 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index9"));
	self.drumNodeRotary10 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index10"));
	self.drumNodeRotary11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index11"));
	self.drumNodeRotary12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index12"));
    self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drum#rotationScale"), 1);
	self.drumRotationScale2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotary#rotationScale"), 1);
  
 
	
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory);
        self.workSound = createSample("workSound");
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 0); 
        self.workSoundEnabled = false;       
    end;

	
	local semoirSound = getXMLString(xmlFile, "vehicle.semoirSound#file");
    if semoirSound ~= nil and semoirSound ~= "" then
        semoirSound = Utils.getFilename(semoirSound, self.baseDirectory);
        self.semoirSound = createSample("semoirSound");
        loadSample(self.semoirSound, semoirSound, false);
	self.semoirSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.semoirSound#pitchOffset"), 0);  
        self.semoirSoundEnabled = false;    
    end;
  
     self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
	self.fillLevel = 0;
   
	self.time = 0;
	self.lastSoundSpeed = 0;        
        self.tramline = false;
        self.leftmarker = false;
	self.rightmarker = false;
    self.rotationMax1 = false;    
	self.rotationMax2 = false;    
	self.rotationMax3 = false;    
	self.rotationMax4 = false;    
	self.rotationMax5 = false;
	self.rotationMax6 = false;    
	
	self.rotationMaxLeft = false
	self.rotationMaxRight = false
	
	self.travailsActive = false; 
        self.marche = false;
        self.marche1 = false;
       
      
       self.sound = false;
end;

function Moduliner:delete()   
  if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;

   if self.semoirSoundEnabled then
		stopSample(self.semoirSound);
		self.semoirSoundEnabled = false;
	end;
end;

function Moduliner:mouseEvent(posX, posY, isDown, isUp, button)    
end;

function Moduliner:keyEvent(unicode, sym, modifier, isDown)   
end;

function Moduliner:readStream(streamId, connection)  
	self.helpPanel = streamReadBool(streamId);
    self.rotationMaxLeft = streamReadBool(streamId);	
	self.rotationMaxRight = streamReadBool(streamId);
	self.rotationMax1 = streamReadBool(streamId)
	self.rotationMax2 = streamReadBool(streamId)
	self.travailsActive = streamReadBool(streamId)
	self.rundumleuchtenAn = streamReadBool(streamId)
	self.marche = streamReadBool(streamId)
	self.sound = streamReadBool(streamId)
	self.marche1 = streamReadBool(streamId)
	self.sound1 = streamReadBool(streamId)
	
	self.translation2Max = streamReadBool(streamId)
	self.rotationMax = streamReadBool(streamId)
	self.translation1Max = streamReadBool(streamId)
	self.drivemark = streamReadBool(streamId)
	self.rotationMax5Delay = streamReadInt32(streamId)
	self.rotationMax6Delay = streamReadInt32(streamId)
	
	self.rotationMax1 = streamReadBool(streamId)
	self.rotationMax2 = streamReadBool(streamId)
	self.rotationMax3 = streamReadBool(streamId)
	self.rotationMax4 = streamReadBool(streamId)
	self.rotationMax5 = streamReadBool(streamId)
	self.rotationMax6 = streamReadBool(streamId)
	
	self.leftmarker = streamReadBool(streamId)
	self.rightmarker = streamReadBool(streamId)
	
	self.fillLevel = streamReadFloat32(streamId)
	--self.currentFillType = streamReadString(streamId)
end

function Moduliner:writeStream(streamId, connection)
	streamWriteBool(streamId, self.helpPanel);
    streamWriteBool(streamId, self.rotationMaxLeft);	
	streamWriteBool(streamId, self.rotationMaxRight);
	streamWriteBool(streamId, self.rotationMax1)
	streamWriteBool(streamId, self.rotationMax2)
	streamWriteBool(streamId, self.travailsActive)
	streamWriteBool(streamId, self.rundumleuchtenAn)
	streamWriteBool(streamId, self.marche)
	streamWriteBool(streamId, self.sound)
	streamWriteBool(streamId, self.marche1)
	streamWriteBool(streamId, self.sound1)
	
	streamWriteBool(streamId, self.translation2Max)
	streamWriteBool(streamId, self.rotationMax)
	streamWriteBool(streamId, self.translation1Max)
	streamWriteBool(streamId, self.drivemark)
	streamWriteInt32(streamId, self.rotationMax5Delay)
	streamWriteInt32(streamId, self.rotationMax6Delay)
	streamWriteBool(streamId, self.rotationMax1)
	streamWriteBool(streamId, self.rotationMax2)
	
	streamWriteBool(streamId, self.rotationMax3)
	streamWriteBool(streamId, self.rotationMax4)
	streamWriteBool(streamId, self.rotationMax5)
	streamWriteBool(streamId, self.rotationMax6)
	
	streamWriteBool(streamId, self.leftmarker)
	streamWriteBool(streamId, self.rightmarker)
	
	streamWriteFloat32(streamId, self.fillLevel)
	--streamWriteString(streamId, self.currentFillType)
end;

function Moduliner:update(dt)
 
	self.time = self.time + dt;
	

		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.MODULINER_HLPPANEL_ONOFF) then
				self:setStateEvent("helpPanel", not self.helpPanel)
				--self.helpPanel = not self.helpPanel;
			end;
			if InputBinding.hasEvent(InputBinding.MODULINER_CULTI_WRKMODE) then
				self:setStateEvent("rotationMaxLeft", not self.rotationMaxLeft)
				self:setStateEvent("rotationMaxRight", not self.rotationMaxRight)
				--self.rotationMaxLeft = not self.rotationMaxLeft;
				--self.rotationMaxRight = not self.rotationMaxRight;  
			end;
			if InputBinding.hasEvent(InputBinding.MODULINER_SOWNG_WRKMODE) then
				self:setStateEvent("rotationMax1", not self.rotationMax1)
				self:setStateEvent("rotationMax2", not self.rotationMax2)
				--self.rotationMax1 = not self.rotationMax1;
				--self.rotationMax2 = not self.rotationMax2;  
			end;
			if InputBinding.hasEvent(InputBinding.MODULINER_WRKLIGHTS_ONOFF) then
				self:setStateEvent("travailsActive", not self.travailsActive)
				--self.travailsActive = not self.travailsActive;  
			end;
			if InputBinding.hasEvent(InputBinding.MODULINER_EMPTYTNK) then
				self:setStateEvent("fillLevel", 0)
				--self.fillLevel = 0; 
				--self:setStateEvent("currentFillType", FruitUtil.FRUITTYPE_UNKNOWN)
                --self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;  
			end;
			
			if self.attacherVehicle ~= nil then
				if InputBinding.hasEvent(InputBinding.MODULINER_RUL_ONOFF) then
					--self.rundumleuchtenAn = not self.rundumleuchtenAn;					
					self:setStateEvent("rundumleuchtenAn", not self.rundumleuchtenAn)
				end;
				
				for i=1, self.rundumleuchtenAnz do
					setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
				end;
			end;
			
			
    
			if self.isExpandedbarreLeft and self.isExpandedbarreRight then
				if InputBinding.hasEvent(InputBinding.MODULINER_CULTI_ONOFF) then
					self:setStateEvent("marche", not self.marche)
					self:setStateEvent("sound", not self.sound)
					--self.marche = not self.marche; 
					--self.sound = not self.sound;
				end; 
				if InputBinding.hasEvent(InputBinding.MODULINER_SOWNG_ONOFF) then
					self:setStateEvent("marche1", not self.marche1)
					self:setStateEvent("sound1", not self.sound1)
					--self.marche1 = not self.marche1; 
					--self.sound1 = not self.sound1
				end; 
				if InputBinding.hasEvent(InputBinding.MODULINER_CULTI_UPDOWN) then
					self:setStateEvent("translation2Max", not self.translation2Max)
					--self.translation2Max = not self.translation2Max;  
				end;
				if InputBinding.hasEvent(InputBinding.MODULINER_SOWNG_UPDOWN) then
					self:setStateEvent("rotationMax", not self.rotationMax)
					self:setStateEvent("translation1Max", not self.translation1Max)
					--self.rotationMax = not self.rotationMax;
					--self.translation1Max = not self.translation1Max;  
				end;
				if InputBinding.hasEvent(InputBinding.MODULINER_DRVEMARK_ONOFF) then
					self:setStateEvent("drivemark", not self.drivemark)
					--self.drivemark = not self.drivemark; 
				end;
				if InputBinding.hasEvent(InputBinding.MODULINER_MRKWHL_LFT) then
					self:setStateEvent("rotationMax5Delay", 2000)
					--self.rotationMax5Delay = 2000;
					self:setStateEvent("leftmarker", true)
					--self.leftmarker = true;
					self:setStateEvent("rightmarker", false)
					--self.rightmarker = false;
					self:setStateEvent("rotationMax3", true)
					--self.rotationMax3 = true;
					self:setStateEvent("rotationMax4", false)
					--self.rotationMax4 = false;
					self:setStateEvent("rotationMax5", false)
					--self.rotationMax5 = false;
				end;
				if InputBinding.hasEvent(InputBinding.MODULINER_MRKWHL_RGT) then
					self:setStateEvent("rotationMax6Delay", 2000)
					--self.rotationMax6Delay = 2000;
					self:setStateEvent("rightmarker", true)
					--self.rightmarker = true;
					self:setStateEvent("leftmarker", false)
					--self.leftmarker = false;
					self:setStateEvent("rotationMax3", false)
					--self.rotationMax3 = false;
					self:setStateEvent("rotationMax4", true)
					--self.rotationMax4 = true;
					self:setStateEvent("rotationMax6", false)
					--self.rotationMax6 = false;
				end;
				if InputBinding.hasEvent(InputBinding.MODULINER_MRKWHLS_OFF) then
					self:setStateEvent("rotationMax5Delay", 2000)
					--self.rotationMax5Delay = 2000;
					self:setStateEvent("rotationMax6Delay", 2000)
					--self.rotationMax6Delay = 2000;
					self:setStateEvent("leftmarker", false)
					--self.leftmarker = false;
					self:setStateEvent("rightmarker", false)
					--self.rightmarker = false;
					self:setStateEvent("rotationMax3", false)
					--self.rotationMax3 = false;
					self:setStateEvent("rotationMax4", false)
					--self.rotationMax4 = false;
					self:setStateEvent("rotationMax5", false)
					--self.rotationMax5 = false;
					self:setStateEvent("rotationMax6", false)
					--self.rotationMax6 = false;
				end;
				
			end;			
		end;


	if self.rotationMax3 then
		self.rotationMax6Delay = self.rotationMax6Delay - dt;
		if self.rotationMax6Delay < 0 then
			self.rotationMax6Delay = 0;
		end;
		if 	self.rotationMax6Delay <= 1000 then
		self.rotationMax5 = false;
		self.rotationMax6 = true;
		end;
	end;

	if self.rotationMax4 then
		self.rotationMax5Delay = self.rotationMax5Delay - dt;
		if self.rotationMax5Delay < 0 then
			self.rotationMax5Delay = 0;
		end;
		if 	self.rotationMax5Delay <= 1000 then
		self.rotationMax5 = true;
		self.rotationMax6 = false;
		end;
	end;	
 
    if self.attacherVehicle ~= nil then
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;
	end;

	if self.travailsActive then
		   for i=1, self.numtravails do
			local travail = self.travails[i];
			setVisibility(travail, self.travailsActive);
		   end;
	       else
		   for i=1, self.numtravails do
			local travail = self.travails[i];
			setVisibility(travail, self.travailsActive, false);
		   end;
	    end;	
      if self.translationPartbequille1 ~= nil then
		local x, y, z = getTranslation(self.translationPartbequille1.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartbequille1.maxTrans, self.translationPartbequille1.minTrans, 3, self.translationPartbequille1.transTime, dt, not self.translationMaxbequille1);
		setTranslation(self.translationPartbequille1.node, unpack(newTrans));
	end;

	if self.isExpandedbarreLeft and self.isExpandedbarreRight and self.translation1Max and self.attacherVehicle.lastSpeed*3600 > 2 then
		Utils.setEmittingState(self.threshingParticleSystems4, self.attacherVehicle.lastSpeed*3600 > 2);
		Utils.setEmittingState(self.threshingParticleSystems5, self.attacherVehicle.lastSpeed*3600 > 2);
		Utils.setEmittingState(self.threshingParticleSystems6, self.attacherVehicle.lastSpeed*3600 > 2);
    end;

    if self.isExpandedLeft and self.isExpandedRight and self.translation2Max and self.marche and self.attacherVehicle.lastSpeed*3600 > 2 then
		Utils.setEmittingState(self.threshingParticleSystems1, self.attacherVehicle.lastSpeed*3600 > 2);
		Utils.setEmittingState(self.threshingParticleSystems2, self.attacherVehicle.lastSpeed*3600 > 2);
		Utils.setEmittingState(self.threshingParticleSystems3, self.attacherVehicle.lastSpeed*3600 > 2);
    end;


    if not self.isExpandedLeft or not self.isExpandedRight or not self.translation2Max or not self.marche or self.attacherVehicle.lastSpeed*3600 < 2 then
		Utils.setEmittingState(self.threshingParticleSystems1, false);
		Utils.setEmittingState(self.threshingParticleSystems2, false);
		Utils.setEmittingState(self.threshingParticleSystems3, false);
    end;

     if not self.isExpandedbarreLeft or not self.isExpandedbarreRight or not self.translation1Max or self.attacherVehicle.lastSpeed*3600 < 2 then
		Utils.setEmittingState(self.threshingParticleSystems4, false);
		Utils.setEmittingState(self.threshingParticleSystems5, false);
		Utils.setEmittingState(self.threshingParticleSystems6, false);
    end;
  
    if self.rotationPart ~= nil then
      local x, y, z = getRotation(self.rotationPart.node);
      local rot = {x,y,z};                                             		
      local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart.maxRot, self.rotationPart.minRot, 3, self.rotationPart.rotTime, dt, not self.rotationMax);
      setRotation(self.rotationPart.node, unpack(newRot));
    end;
   
     if self.rotationPart3 ~= nil then
          local x, y, z = getRotation(self.rotationPart3.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax3);
          setRotation(self.rotationPart3.node, unpack(newRot));
    end;

    if self.rotationPart4 ~= nil then
          local x, y, z = getRotation(self.rotationPart4.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax4);
          setRotation(self.rotationPart4.node, unpack(newRot));
    end;

    if self.rotationPart5 ~= nil then
          local x, y, z = getRotation(self.rotationPart5.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart5.maxRot, self.rotationPart5.minRot, 3, self.rotationPart5.rotTime, dt, not self.rotationMax5);
          setRotation(self.rotationPart5.node, unpack(newRot));
    end;
  
    if self.rotationPart6 ~= nil then
          local x, y, z = getRotation(self.rotationPart6.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart6.maxRot, self.rotationPart6.minRot, 3, self.rotationPart6.rotTime, dt, not self.rotationMax6);
          setRotation(self.rotationPart6.node, unpack(newRot));
    end;
   
    if self.translationPart1 ~= nil then
        local x, y, z = getTranslation(self.translationPart1.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart1.maxTrans, self.translationPart1.minTrans, 3, self.translationPart1.transTime, dt, not self.translation1Max);
        setTranslation(self.translationPart1.node, unpack(newTrans));
        
    end;

     if self.verin ~= nil and self.rotationPart ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin.node);
		local bx, by, bz = getWorldTranslation(self.rotationPart.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin.node, x, y, z, 0, 1, 0);
		if self.verin.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin.tige, 0, (distance-self.verin.tigeDistance), 0);
		end;
	end;
 
     if self.verin1 ~= nil and self.rotationPart1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin1.node);
		local bx, by, bz = getWorldTranslation(self.rotationPart1.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin1.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin1.node, x, y, z, 0, 1, 0);
		if self.verin1.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin1.tige, 0, (distance-self.verin1.tigeDistance), 0);
		end;
	end;

    if self.verin2 ~= nil and self.rotationPart2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin2.node);
		local bx, by, bz = getWorldTranslation(self.rotationPart2.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin2.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin2.node, x, y, z, 0, 1, 0);
		if self.verin2.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin2.tige, 0, (distance-self.verin2.tigeDistance), 0);
		end;
	end;
    
	if self.rotationPartRight ~= nil then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, not self.rotationMaxRight);
        setRotation(self.rotationPartRight.node, unpack(newRot));
    end;

    if self.rotationPartLeft ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
        setRotation(self.rotationPartLeft.node, unpack(newRot));
    end;

   if self.rotationPart1 ~= nil then
          local x, y, z = getRotation(self.rotationPart1.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart1.maxRot, self.rotationPart1.minRot, 3, self.rotationPart1.rotTime, dt, not self.rotationMax1);
          setRotation(self.rotationPart1.node, unpack(newRot));
    end;

     if self.rotationPart2 ~= nil then
          local x, y, z = getRotation(self.rotationPart2.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax2);
          setRotation(self.rotationPart2.node, unpack(newRot));
    end;


   self.isExpandedRight = false;
    if self.rotationPartRight ~= nil then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local maxRot = self.rotationPartRight.maxRot;
        local eps = self.rotationPartRight.touchRotLimit;

        if math.abs(x-maxRot[1]) < eps and math.abs(y-maxRot[2]) < eps and math.abs(z-maxRot[3]) < eps then
            self.isExpandedRight = true;
        end;
    end;
	
	self.isExpandedLeft = false;
    if self.rotationPartLeft ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local maxRot = self.rotationPartLeft.maxRot;
        local eps = self.rotationPartLeft.touchRotLimit;

        if math.abs(x-maxRot[1]) < eps and math.abs(y-maxRot[2]) < eps and math.abs(z-maxRot[3]) < eps then
            self.isExpandedLeft = true;
        end;
    end;

   self.isExpandedbarreRight = false;
    if self.rotationPart1 ~= nil then
        local x, y, z = getRotation(self.rotationPart1.node);
        local maxRot = self.rotationPart1.maxRot;
        local eps = self.rotationPart1.touchRotLimit;

        if math.abs(x-maxRot[1]) < eps and math.abs(y-maxRot[2]) < eps and math.abs(z-maxRot[3]) < eps then
            self.isExpandedbarreRight = true;
        end;
    end

   self.isExpandedbarreLeft = false;
    if self.rotationPart2 ~= nil then
        local x, y, z = getRotation(self.rotationPart2.node);
        local maxRot = self.rotationPart2.maxRot;
        local eps = self.rotationPart2.touchRotLimit;

        if math.abs(x-maxRot[1]) < eps and math.abs(y-maxRot[2]) < eps and math.abs(z-maxRot[3]) < eps then
            self.isExpandedbarreLeft = true;
        end;
    end;

   if self.translationPart2 ~= nil then
        local x, y, z = getTranslation(self.translationPart2.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translation2Max);
        setTranslation(self.translationPart2.node, unpack(newTrans));
    end;

    if self.isExpandedLeft and self.isExpandedRight and self.translation2Max then
		self.drumNodeRotaryDelay = self.drumNodeRotaryDelay - dt;
		if self.drumNodeRotaryDelay <= 0 then
			self.drumNodeRotaryDelay = 0;
		end;
		if self.drumNodeRotaryDelay == 0 then
			if self.drumNodeLeft ~= nil then
				rotate(self.drumNodeLeft, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			if self.drumNodeRight ~= nil then
				rotate(self.drumNodeRight, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
		end;
	else
		self.drumNodeRotaryDelay = 1000;
	end;
	
	if self.marche then 
			if self.drumNodeRotary ~= nil then
				rotate(self.drumNodeRotary, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
			if self.drumNodeRotary2 ~= nil then
				rotate(self.drumNodeRotary2, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
			if self.drumNodeRotary3 ~= nil then
				rotate(self.drumNodeRotary3, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
			if self.drumNodeRotary4 ~= nil then
				rotate(self.drumNodeRotary4, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
			if self.drumNodeRotary5 ~= nil then
				rotate(self.drumNodeRotary5, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
			if self.drumNodeRotary6 ~= nil then
				rotate(self.drumNodeRotary6, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
			if self.drumNodeRotary7 ~= nil then
				rotate(self.drumNodeRotary7, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
			if self.drumNodeRotary8 ~= nil then
				rotate(self.drumNodeRotary8, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
			if self.drumNodeRotary9 ~= nil then
				rotate(self.drumNodeRotary9, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
			if self.drumNodeRotary10 ~= nil then
				rotate(self.drumNodeRotary10, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
			if self.drumNodeRotary11 ~= nil then
				rotate(self.drumNodeRotary11, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
			if self.drumNodeRotary12 ~= nil then
				rotate(self.drumNodeRotary12, self.drumRotationScale2 * 0.04 +dt  * self.attacherVehicle.lastSpeed * 3, 0, 0);
			end;
	end;
	    

    if self.isExpandedLeft and self.isExpandedRight and self.marche and self.translation2Max then
		self.cultivatorDelay = self.cultivatorDelay - dt;
		if self.cultivatorDelay <= 0 then
			self.cultivatorDelay = 0;
		end;
		if self.cultivatorDelay == 0 then
			for i=1, table.getn(self.cuttingAreas) do
				local x,y,z = getWorldTranslation(self.cuttingAreas[i].start);
				local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[i].width);
				local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[i].height);
				
                    if  i==1 or i==2 then
						Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);				                                 		
                    end;
						
			end;
		end;
	else
		self.cultivatorDelay = 1000;
    end;
   
			
    if self.fillLevel > 0 and self.isExpandedbarreLeft and self.isExpandedbarreRight and self.marche1 and self.translation1Max then  
		self.sowingDelay = self.sowingDelay - dt;
		if self.sowingDelay <= 0 then
			self.sowingDelay = 0;
		end;
	
		if self.sowingDelay == 0 then  
            --local area = 0;  
			self.cuttingAreasSend = {};			
			for i=1, table.getn(self.cuttingAreas) do
				if self:getIsAreaActive(cuttingArea) then
					local x,y,z = getWorldTranslation(self.cuttingAreas[i].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[i].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[i].height);	
					if i==3 or i==4 or i==5 then
						table.insert(self.cuttingAreasSend, {x,z,x1,z1,x2,z2});
					end;	
				end;
			end;	
				if (table.getn(self.cuttingAreasSend) > 0) then
					local currentFillType = self.currentFillType-3;
					local area = SowingMachineAreaEvent.runLocally(self.cuttingAreasSend, currentFillType)
					if area > 0 then
						local fruitDesc = FruitUtil.fruitIndexToDesc[currentFillType];
						local pixelToSqm = g_currentMission:getTerrainDetailPixelsToSqm(); -- 8192px are mapped to 2048m
						local sqm = area*pixelToSqm;
						local ha = sqm/10000;
						local usage = fruitDesc.seedUsagePerSqm*sqm;
                        g_currentMission.missionStats.seedUsageTotal = g_currentMission.missionStats.seedUsageTotal + usage;
                        g_currentMission.missionStats.seedUsageSession = g_currentMission.missionStats.seedUsageSession + usage;
						g_currentMission.missionStats.hectaresSeededTotal = g_currentMission.missionStats.hectaresSeededTotal + ha;
                        g_currentMission.missionStats.hectaresSeededSession = g_currentMission.missionStats.hectaresSeededSession + ha;
						self:setFillLevel(self.fillLevel - usage, self.currentFillType);
						g_server:broadcastEvent(SowingMachineAreaEvent:new(self.cuttingAreasSend, currentFillType));
					end;
				end
			 
		end;
	else
		self.sowingDelay = 1500;
    end;

   
		if self.isExpandedbarreLeft and self.isExpandedbarreRight and self.translation1Max then
			  
				for i=1, table.getn(self.cuttingAreas) do
			    local x,y,z = getWorldTranslation(self.cuttingAreas[i].start);
		        local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[i].width);
		        local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[i].height);	
				local xl,yl,zl = getWorldTranslation(self.cuttingAreas[10].start);
				local x1l,y1l,z1l = getWorldTranslation(self.cuttingAreas[10].width);
				local x2l,y2l,z2l = getWorldTranslation(self.cuttingAreas[10].height);
				local xr,yr,zr = getWorldTranslation(self.cuttingAreas[11].start);
				local x1r,y1r,z1r = getWorldTranslation(self.cuttingAreas[11].width);
				local x2r,y2r,z2r = getWorldTranslation(self.cuttingAreas[11].height);
				local cultivatorLeft = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.cultivatorChannel, xl, zl, x1l, z1l, x2l, z2l);
				local cultivatorRight = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.cultivatorChannel, xr, zr, x1r, z1r, x2r, z2r);
					if cultivatorRight ~= 0 then
						if self.rotationMax5 and i==6 and self.rotationMax5Delay == 0 then							
							Utils.updatePloughArea(x, z, x1, z1, x2, z2);
						end;
					else
						if self.rotationMax5 and i==6 and self.rotationMax5Delay == 0 then							
							Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);
						end;
					end;
					if cultivatorLeft ~= 0 then	
						if self.rotationMax6 and i==7 and self.rotationMax6Delay == 0 then							
							Utils.updatePloughArea(x, z, x1, z1, x2, z2);
						end; 
					else
						if self.rotationMax6 and i==7 and self.rotationMax6Delay == 0 then							
							Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);
						end; 
					end;
					
					if self.drivemark and i==8 then
						self.drivemarkDelay = self.drivemarkDelay - dt;
						if self.drivemarkDelay <= 0 then
							self.drivemarkDelay = 0;
						end;
						if self.drivemarkDelay == 0 then 
							Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);
						end;	
					end;
					if self.drivemark and i==9 then
						self.drivemarkDelay = self.drivemarkDelay - dt;
						if self.drivemarkDelay <= 0 then
							self.drivemarkDelay = 0;
						end;
						if self.drivemarkDelay == 0 then 
							Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);
						end;	
					end;
				end;
		else
			self.drivemarkDelay = 2000;
		end;
   if not self.isExpandedLeft then       
        self.marche = false;
   end;
	
	  if self.isClient then
	
		if self.marche and not self.workSoundEnabled then
			if self:getIsActiveForSound() then
				playSample(self.workSound, 0, 1, 0);
				setSamplePitch(self.workSound, self.workSoundPitchOffset);
				self.workSoundEnabled = true;
			end
		end;

		if not self.marche or not self:getIsActiveForInput() then                                                
			if self.workSoundEnabled and self.workSound ~= nil then
				stopSample(self.workSound);
				self.workSoundEnabled = false;
			end;
		end;
		
		if self.marche1 and not self.semoirSoundEnabled then
			if self:getIsActiveForSound() then	
				playSample(self.semoirSound, 0, 1, 0);
				setSamplePitch(self.semoirSound, self.semoirSoundPitchOffset);
				self.semoirSoundEnabled = true;
			end
		end;


		if not self.marche1 or not self:getIsActiveForInput() then                                                
			if self.semoirSoundEnabled and self.semoirSound ~= nil then
				stopSample(self.semoirSound);
				self.semoirSoundEnabled = false;
			end;
		end;
	  end
end; 

function Moduliner:draw()  

	if not self.helpPanel then
		g_currentMission:addHelpButtonText(g_i18n:getText("MODULINERTXT_HLPPANEL_ON"), InputBinding.MODULINER_HLPPANEL_ONOFF);
	else	
		g_currentMission:addHelpButtonText(g_i18n:getText("MODULINERTXT_HLPPANEL_OFF"), InputBinding.MODULINER_HLPPANEL_ONOFF);
			renderText(0.80, 0.86, 0.02, "- Moduliner Info -");
			if self.rotationMaxLeft then
            renderText(0.7543, 0.83, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_CULTI_WRKMODE)..": ");
			setTextColor(0, 1, 0, 1)
			renderText(0.78, 0.81, 0.017, g_i18n:getText("MODULINERTXT_CULTI_WRKMODE"));
			setTextColor(1, 1, 1, 1)
			else
			renderText(0.7543, 0.83, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_CULTI_WRKMODE)..": ");
			setTextColor(1, 0, 0, 1)
			renderText(0.78, 0.81, 0.017, g_i18n:getText("MODULINERTXT_CULTI_TRSPMODE"));
			setTextColor(1, 1, 1, 1)
			end;
			if self.rotationMax1 then
			renderText(0.7543, 0.78, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_SOWNG_WRKMODE)..": ");
			setTextColor(0, 1, 0, 1)
			renderText(0.78, 0.76, 0.017, g_i18n:getText("MODULINERTXT_SOWNG_WRKMODE"));
			setTextColor(1, 1, 1, 1)
			else
			renderText(0.7543, 0.78, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_SOWNG_WRKMODE)..": ");
			setTextColor(1, 0, 0, 1)
			renderText(0.78, 0.76, 0.017, g_i18n:getText("MODULINERTXT_SOWNG_TRSPMODE"));
			setTextColor(1, 1, 1, 1)
			end;
			if self.marche then
			renderText(0.7543, 0.73, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_CULTI_ONOFF)..": ");
			setTextColor(0, 1, 0, 1)
			renderText(0.78, 0.71, 0.017, g_i18n:getText("MODULINERTXT_CULTI_ON"));
			setTextColor(1, 1, 1, 1)
			else
			renderText(0.7543, 0.73, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_CULTI_ONOFF)..": ");
			setTextColor(1, 0, 0, 1)
			renderText(0.78, 0.71, 0.017, g_i18n:getText("MODULINERTXT_CULTI_OFF"));
			setTextColor(1, 1, 1, 1)
			end;
			if self.marche1 then
			renderText(0.7543, 0.68, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_SOWNG_ONOFF)..": ");
			setTextColor(0, 1, 0, 1)
			renderText(0.78, 0.66, 0.017, g_i18n:getText("MODULINERTXT_SOWNG_ON"));
			setTextColor(1, 1, 1, 1)
			else
			renderText(0.7543, 0.68, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_SOWNG_ONOFF)..": ");
			setTextColor(1, 0, 0, 1)
			renderText(0.78, 0.66, 0.017, g_i18n:getText("MODULINERTXT_SOWNG_OFF"));
			setTextColor(1, 1, 1, 1)
			end;
			if self.translation2Max then
			renderText(0.7543, 0.63, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_CULTI_UPDOWN)..": ");
			setTextColor(0, 1, 0, 1)
			renderText(0.78, 0.61, 0.017, g_i18n:getText("MODULINERTXT_CULTI_DOWN"));
			setTextColor(1, 1, 1, 1)
			else
			renderText(0.7543, 0.63, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_CULTI_UPDOWN)..": ");
			setTextColor(1, 0, 0, 1)
			renderText(0.78, 0.61, 0.017, g_i18n:getText("MODULINERTXT_CULTI_UP"));
			setTextColor(1, 1, 1, 1)
			end;
			if self.rotationMax then
			renderText(0.7543, 0.58, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_SOWNG_UPDOWN)..": ");
			setTextColor(0, 1, 0, 1)
			renderText(0.78, 0.56, 0.017, g_i18n:getText("MODULINERTXT_SOWNG_DOWN"));
			setTextColor(1, 1, 1, 1)
			else
			renderText(0.7543, 0.58, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_SOWNG_UPDOWN)..": ");
			setTextColor(1, 0, 0, 1)
			renderText(0.78, 0.56, 0.017, g_i18n:getText("MODULINERTXT_SOWNG_UP"));
			setTextColor(1, 1, 1, 1)
			end;
			if self.drivemark then
			renderText(0.7543, 0.53, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_DRVEMARK_ONOFF)..": ");
			setTextColor(0, 1, 0, 1)
			renderText(0.78, 0.51, 0.017, g_i18n:getText("MODULINERTXT_DRVEMARK_ON"));
			setTextColor(1, 1, 1, 1)
			else
			renderText(0.7543, 0.53, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_DRVEMARK_ONOFF)..": ");
			setTextColor(1, 0, 0, 1)
			renderText(0.78, 0.51, 0.017, g_i18n:getText("MODULINERTXT_DRVEMARK_OFF"));
			setTextColor(1, 1, 1, 1)
			end;
			if self.rotationMax3 then
			renderText(0.7543, 0.48, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_MRKWHL_LFT)..": ");
			setTextColor(0, 1, 0, 1)
			renderText(0.78, 0.46, 0.017, g_i18n:getText("MODULINERTXT_MRKWHL_LFT_ON"));
			setTextColor(1, 1, 1, 1)
			else
			renderText(0.7543, 0.48, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_MRKWHL_LFT)..": ");
			setTextColor(1, 0, 0, 1)
			renderText(0.78, 0.46, 0.017, g_i18n:getText("MODULINERTXT_MRKWHL_LFT_OFF"));
			setTextColor(1, 1, 1, 1)
			end;
			if self.rotationMax4 then
			renderText(0.7543, 0.43, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_MRKWHL_RGT)..": ");
			setTextColor(0, 1, 0, 1)
			renderText(0.78, 0.41, 0.017, g_i18n:getText("MODULINERTXT_MRKWHL_RGT_ON"));
			setTextColor(1, 1, 1, 1)
			else
			renderText(0.7543, 0.43, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_MRKWHL_RGT)..": ");
			setTextColor(1, 0, 0, 1)
			renderText(0.78, 0.41, 0.017, g_i18n:getText("MODULINERTXT_MRKWHL_RGT_OFF"));
			setTextColor(1, 1, 1, 1)
			end;
			renderText(0.7543, 0.38, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_MRKWHLS_OFF)..": ");
			renderText(0.78, 0.36, 0.017, g_i18n:getText("MODULINERTXT_MRKWHLS_OFF"));
			if self.travailsActive then
			renderText(0.7543, 0.33, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_WRKLIGHTS_ONOFF)..": ");
			renderText(0.78, 0.31, 0.017, g_i18n:getText("MODULINERTXT_WRKLIGHTS_ON"));
			else
			renderText(0.7543, 0.33, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_WRKLIGHTS_ONOFF)..": ");
			renderText(0.78, 0.31, 0.017, g_i18n:getText("MODULINERTXT_WRKLIGHTS_OFF"));
			end;
			if self.rundumleuchtenAn then
			renderText(0.7543, 0.28, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_RUL_ONOFF)..": ");
			renderText(0.78, 0.26, 0.017, g_i18n:getText("MODULINERTXT_RUL_ON"));
			else
			renderText(0.7543, 0.28, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_RUL_ONOFF)..": ");
			renderText(0.78, 0.26, 0.017, g_i18n:getText("MODULINERTXT_RUL_OFF"));
			end;
			renderText(0.7543, 0.23, 0.017, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MODULINER_EMPTYTNK)..": ");
			renderText(0.78, 0.21, 0.017, g_i18n:getText("MODULINERTXT_EMPTYTNK"));		
	end;	
--	renderText(0.76, 0.88, 0.023,""..string.format("self.rotationMax6Delay: %d", self.rotationMax6Delay).."");
--	renderText(0.76, 0.86, 0.023,""..string.format("self.rotationMax5Delay: %d", self.rotationMax5Delay).."");
--  renderText(0.76, 0.84, 0.015,""..string.format("self.cultivatorDelay: %d", self.cultivatorDelay).."");
--  renderText(0.76, 0.82, 0.015,""..string.format("self.drumNodeRotaryDelay: %d", self.drumNodeRotaryDelay).."");
--  renderText(0.76, 0.80, 0.015,""..string.format("self.sowingDelay: %d", self.sowingDelay).."");
--  renderText(0.76, 0.78, 0.023,""..string.format("self.drivemarkDelay: %d", self.drivemarkDelay).."");
--  renderText(0.76, 0.76, 0.023,""..string.format("self.currentFillType: %d", self.currentFillType).."");
end; 


function Moduliner:onAttach()
self.translationMaxbequille1 = true;
self.marche = false;
self.marche1 = false;
end;

function Moduliner:onDetach()
        self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;  
        Utils.setEmittingState(self.threshingParticleSystems1, false);
	Utils.setEmittingState(self.threshingParticleSystems2, false);
	Utils.setEmittingState(self.threshingParticleSystems3, false); 
        Utils.setEmittingState(self.threshingParticleSystems4, false);
	Utils.setEmittingState(self.threshingParticleSystems5, false);
	Utils.setEmittingState(self.threshingParticleSystems6, false); 
        self.marche = false;	
        self.marche1 = false;	
        self.translationMaxbequille1 = false;
		
	if self.workSound ~= nil then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
    end;
	if self.semoirSound ~= nil then
	  stopSample(self.semoirSound);
	  self.semoirSoundEnabled = false;
    end;	
end;

function Moduliner:onLeave()
	if self.workSound ~= nil then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
	if self.semoirSound ~= nil then
	stopSample(self.semoirSound);
	self.semoirSoundEnabled = false;
   end;
end;

function Moduliner:setStateEvent(level1, value, noEventSend)
	
    if value== true then
      value = "true"
    elseif value==false then
      value = "false"
    elseif value ~= "true" and value ~= "false" then
      value = string.format("%f", value)
    end
	
	KuhnModulinerEvent.sendEvent(self, level1, value, noEventSend);
    	
	if value== "true" then
      value = true
    elseif value=="false" then
      value = false
    elseif value ~= true and value ~= false then
      value = value * 1.0
    end
	
    self[level1]= value;
end;


KuhnModulinerEvent = {};
KuhnModulinerEvent_mt = Class(KuhnModulinerEvent, Event);

InitEventClass(KuhnModulinerEvent, "KuhnModulinerEvent");

function KuhnModulinerEvent:emptyNew()  
    local self = Event:new(KuhnModulinerEvent_mt );
    self.className="KuhnModulinerEvent";
    return self;
end;

function KuhnModulinerEvent:new(object, level1, value) 
    self.object = object;
    self.level1 = level1;
    self.value = value;

    return self;
end;

function KuhnModulinerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.level1 = streamReadString(streamId);
    self.value = streamReadString(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function KuhnModulinerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteString(streamId, self.level1 );
    streamWriteString(streamId, self.value );
end;

function KuhnModulinerEvent:run(connection)
    self.object:setStateEvent(self.level1, self.value, true);
    if not connection:getIsServer() then  
      g_server:broadcastEvent(KuhnModulinerEvent:new(self.object, self.level1, self.value), nil, connection, self.object);
    end;
end;

function KuhnModulinerEvent.sendEvent(object, level1, value, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then 
			g_server:broadcastEvent(KuhnModulinerEvent:new(object, level1, value), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(KuhnModulinerEvent:new(object, level1, value));
		end;
	end;
end;


