--
-- Lemken_Solitair_12
-- Specialization for Lemken Solitair 12
--
-- @author  MySQly
-- @date  02/06/09
--
-- Copyright (C) MySQly, All Rights Reserved.

Lemken_Solitair_12 = {};

function Lemken_Solitair_12.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Lemken_Solitair_12:load(xmlFile)

    self.aiTerrainDetailChannel1 = g_currentMission.ploughChannel;
    self.aiTerrainDetailChannel2 = g_currentMission.cultivatorChannel;

	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	self.seedPerQm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.seedPerHa#value"), 1);

	self.drum1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum1#index"));
	self.drum2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum2#index"));
	self.drum3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum3#index"));
	self.drum4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum4#index"));
	self.drum5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum5#index"));
	self.drum6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum6#index"));
	self.drum7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum7#index"));
	self.drum8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum8#index"));
	self.drum9 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum9#index"));
	self.drum10 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum10#index"));
	self.drum11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum11#index"));
	self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drumLeft#rotationScale"), 1);
	
	self.gotowydoskladania = true;
	self.rotationSpeed = 0;
	self.cos = 4000;
	self.cos2 = 4000;
	self.cos3 = 4000;
	self.cos4 = 2000;
	self.cos5 = 2000;
	self.cos6 = 2000;
	self.cos7 = 2000;
	
    local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft2#index"));
    if rotationPartNodeLeft2 ~= nil then
        self.rotationPartLeft2 = {};
        self.rotationPartLeft2.node = rotationPartNodeLeft2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#minRot"));
        self.rotationPartLeft2.minRot = {};
        self.rotationPartLeft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#maxRot"));
        self.rotationPartLeft2.maxRot = {};
        self.rotationPartLeft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#rotTime"), 2)*1000;
        self.rotationPartLeft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft3#index"));
    if rotationPartNodeLeft3 ~= nil then
        self.rotationPartLeft3 = {};
        self.rotationPartLeft3.node = rotationPartNodeLeft3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#minRot"));
        self.rotationPartLeft3.minRot = {};
        self.rotationPartLeft3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#maxRot"));
        self.rotationPartLeft3.maxRot = {};
        self.rotationPartLeft3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#rotTime"), 2)*1000;
        self.rotationPartLeft3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft4#index"));
    if rotationPartNodeLeft4 ~= nil then
        self.rotationPartLeft4 = {};
        self.rotationPartLeft4.node = rotationPartNodeLeft4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#minRot"));
        self.rotationPartLeft4.minRot = {};
        self.rotationPartLeft4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#maxRot"));
        self.rotationPartLeft4.maxRot = {};
        self.rotationPartLeft4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#rotTime"), 2)*1000;
        self.rotationPartLeft4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft5#index"));
    if rotationPartNodeLeft5 ~= nil then
        self.rotationPartLeft5 = {};
        self.rotationPartLeft5.node = rotationPartNodeLeft5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft5#minRot"));
        self.rotationPartLeft5.minRot = {};
        self.rotationPartLeft5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft5#maxRot"));
        self.rotationPartLeft5.maxRot = {};
        self.rotationPartLeft5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft5#rotTime"), 2)*1000;
        self.rotationPartLeft5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft5#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft6#index"));
    if rotationPartNodeLeft6 ~= nil then
        self.rotationPartLeft6 = {};
        self.rotationPartLeft6.node = rotationPartNodeLeft6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft6#minRot"));
        self.rotationPartLeft6.minRot = {};
        self.rotationPartLeft6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft6#maxRot"));
        self.rotationPartLeft6.maxRot = {};
        self.rotationPartLeft6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft6#rotTime"), 2)*1000;
        self.rotationPartLeft6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft6#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft7#index"));
    if rotationPartNodeLeft7 ~= nil then
        self.rotationPartLeft7 = {};
        self.rotationPartLeft7.node = rotationPartNodeLeft7;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft7#minRot"));
        self.rotationPartLeft7.minRot = {};
        self.rotationPartLeft7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft7#maxRot"));
        self.rotationPartLeft7.maxRot = {};
        self.rotationPartLeft7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft7#rotTime"), 2)*1000;
        self.rotationPartLeft7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft7#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft8#index"));
    if rotationPartNodeLeft8 ~= nil then
        self.rotationPartLeft8 = {};
        self.rotationPartLeft8.node = rotationPartNodeLeft8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft8#minRot"));
        self.rotationPartLeft8.minRot = {};
        self.rotationPartLeft8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft8#maxRot"));
        self.rotationPartLeft8.maxRot = {};
        self.rotationPartLeft8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft8#rotTime"), 2)*1000;
        self.rotationPartLeft8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft8#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft9 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft9#index"));
    if rotationPartNodeLeft9 ~= nil then
        self.rotationPartLeft9 = {};
        self.rotationPartLeft9.node = rotationPartNodeLeft9;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft9#minRot"));
        self.rotationPartLeft9.minRot = {};
        self.rotationPartLeft9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft9#maxRot"));
        self.rotationPartLeft9.maxRot = {};
        self.rotationPartLeft9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft9#rotTime"), 2)*1000;
        self.rotationPartLeft9.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft9#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft10 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft10#index"));
    if rotationPartNodeLeft10 ~= nil then
        self.rotationPartLeft10 = {};
        self.rotationPartLeft10.node = rotationPartNodeLeft10;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft10#minRot"));
        self.rotationPartLeft10.minRot = {};
        self.rotationPartLeft10.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft10.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft10.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft10#maxRot"));
        self.rotationPartLeft10.maxRot = {};
        self.rotationPartLeft10.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft10.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft10.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft10.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft10#rotTime"), 2)*1000;
        self.rotationPartLeft10.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft10#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft11#index"));
    if rotationPartNodeLeft11 ~= nil then
        self.rotationPartLeft11 = {};
        self.rotationPartLeft11.node = rotationPartNodeLeft11;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft11#minRot"));
        self.rotationPartLeft11.minRot = {};
        self.rotationPartLeft11.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft11.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft11.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft11#maxRot"));
        self.rotationPartLeft11.maxRot = {};
        self.rotationPartLeft11.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft11.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft11.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft11.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft11#rotTime"), 2)*1000;
        self.rotationPartLeft11.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft11#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft12#index"));
    if rotationPartNodeLeft12 ~= nil then
        self.rotationPartLeft12 = {};
        self.rotationPartLeft12.node = rotationPartNodeLeft12;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft12#minRot"));
        self.rotationPartLeft12.minRot = {};
        self.rotationPartLeft12.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft12.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft12.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft12#maxRot"));
        self.rotationPartLeft12.maxRot = {};
        self.rotationPartLeft12.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft12.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft12.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft12.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft12#rotTime"), 2)*1000;
        self.rotationPartLeft12.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft12#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft13#index"));
    if rotationPartNodeLeft12 ~= nil then
        self.rotationPartLeft13 = {};
        self.rotationPartLeft13.node = rotationPartNodeLeft12;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft13#minRot"));
        self.rotationPartLeft13.minRot = {};
        self.rotationPartLeft13.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft13.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft13.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft13#maxRot"));
        self.rotationPartLeft13.maxRot = {};
        self.rotationPartLeft13.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft13.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft13.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft13.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft13#rotTime"), 2)*1000;
        self.rotationPartLeft13.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft13#touchRotLimit"), 10));
    end;

    local rotationPartNodeLeft14 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft14#index"));
    if rotationPartNodeLeft14 ~= nil then
        self.rotationPartLeft14 = {};
        self.rotationPartLeft14.node = rotationPartNodeLeft14;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft14#minRot"));
        self.rotationPartLeft14.minRot = {};
        self.rotationPartLeft14.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft14.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft14.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft14#maxRot"));
        self.rotationPartLeft14.maxRot = {};
        self.rotationPartLeft14.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft14.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft14.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft14.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft14#rotTime"), 2)*1000;
        self.rotationPartLeft14.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft14#touchRotLimit"), 10));
    end;

    local rotationPartNodeLeft15 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft15#index"));
    if rotationPartNodeLeft15 ~= nil then
        self.rotationPartLeft15 = {};
        self.rotationPartLeft15.node = rotationPartNodeLeft15;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft15#minRot"));
        self.rotationPartLeft15.minRot = {};
        self.rotationPartLeft15.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft15.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft15.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft15#maxRot"));
        self.rotationPartLeft15.maxRot = {};
        self.rotationPartLeft15.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft15.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft15.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft15.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft15#rotTime"), 2)*1000;
        self.rotationPartLeft15.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft15#touchRotLimit"), 10));
    end;

	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
	
	local translationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end;	
	
	self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
	self.fillLevel = 0;
    self.allowFillType = Lemken_Solitair_12.allowFillType;
	
	sowingSoundFile = Utils.getFilename("sowing.wav", self.baseDirectory);
    self.sowingSoundId = createSample("sowingSound");
    loadSample(self.sowingSoundId, sowingSoundFile, false);
	
	seederSoundFile = Utils.getFilename("airseeder.wav", self.baseDirectory);
    self.seederSoundId = createSample("seedergSound");

    loadSample(self.seederSoundId, seederSoundFile, false);
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
	self.AIon = false;
	
	self.saveAILM = self.aiLeftMarker;
	self.aiLeftMarker = nil; 	
	
    self.attacherBackup = nil;
    self.TurnRadiusBackup = 0;	
end;

function Lemken_Solitair_12:delete()

end;

function Lemken_Solitair_12:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Lemken_Solitair_12:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_x and self.gotowydoskladania and not self.rotationMaxLeft10 and not self.rotationMaxLeft9 then
		
		self.robotniczy = not self.robotniczy;
		if self.rotationPartLeft then
			self.cos = 5000;
		else
			self.cos = 1000;
		end;
		self.part1 = true;
	end;
	if isDown and sym == Input.KEY_KP_2 and self.gotowy then
		self.rotationMaxLeft4 = not self.rotationMaxLeft4;
		self.rotationMaxLeft5 = not self.rotationMaxLeft5;
		self.gotowydoskladania = false;
		self.cos4 = 600;
		if not self.rotationMaxLeft4 then
			self.dotykaziemi = false;
		end;
		self.partdown = true;
	end;
	
	if isDown and sym == Input.KEY_z and self.gotowy then
		self.rotationMaxLeft13 = not self.rotationMaxLeft13;
	end;

	if isDown and sym == Input.KEY_KP_1 and self.gotowy then
		self.rotationMaxLeft10 = not self.rotationMaxLeft10;
		self.rotationMaxLeft15 = not self.rotationMaxLeft15;
		self.markerleft = false;
		self.cos5 = 3000;
		self.partmarker1 = true;
	end;
	
	if isDown and sym == Input.KEY_KP_3 and self.gotowy then
		self.rotationMaxLeft9 = not self.rotationMaxLeft9;
		self.rotationMaxLeft14 = not self.rotationMaxLeft14;
		self.markerright = false;
		self.cos6 = 3000;
		self.partmarker2 = true;
	end;
	
	if isDown and sym == Input.KEY_KP_5 and self.gotowy then
		self.rotationMaxLeft12 = not self.rotationMaxLeft12;
		self.rotationMaxLeft11 = not self.rotationMaxLeft11;
		self.cos7 = 2000;
		self.partmarkers = true;
		self.markers = false;
	end;
end;

function Lemken_Solitair_12:update(dt)
	if self.attacherVehicle then
		
	    if self.attacherVehicle.isAITractorActivated ~= nil then
			self.AIon = self.attacherVehicle.isAITractorActivated;
		end; 
		
		if  self.attacherVehicle.isAITractorActivated ~= nil then 
			self.aiLeftMarker = self.saveAILM; 
			AITractor.updateToolsInfo(self.attacherVehicle)
		end; 			
		
		if self.AIon then
			self.attacherVehicle.steeringAxleAngle = 0;
		end;
		
		if self.attacherBackup == nil and self.attacherVehicle ~= nil then
            self.attacherBackup = self.attacherVehicle;
        end;
	end;
	if self.attacherVehicle then
		if self.partmarkers then
			self.cos7 = self.cos7 - dt;
			if self.cos7 <= 0 then
				if self.rotationMaxLeft11 then
					self.markers = true;
				else
					self.markers = false;
				end;
				self.partmarkers = false;
			end;
		end;
		
		if self.partmarker2 then
			self.cos6 = self.cos6 - dt;
			if self.cos6 <= 0 then
				if self.rotationMaxLeft9 then
					self.markerright = true;
				else
					self.markerright = false;
				end;
				self.partmarker2 = false;
			end;
		end;

		if self.partmarker1 then
			self.cos5 = self.cos5 - dt;
			if self.cos5 <= 0 then
				if self.rotationMaxLeft10 then
					self.markerleft = true;
				else
					self.markerleft = false;
				end;
				self.partmarker1 = false;
			end;
		end;

		if self.partdown then
			self.cos4 = self.cos4 - dt;
			if self.cos4 <= 0 then
				self.partdown = false;
				if self.rotationMaxLeft4 then
					self.dotykaziemi = true;
				else
					self.gotowydoskladania = true;
				end;
			end;
		end;
		
		if self.robotniczy then
			self.rotationMaxLeft3 = self.robotniczy;
			if self.part1 then
				self.cos = self.cos - dt;
				if self.cos <= 0 then
					self.cos2 = 50;
					self.part2 = true;
					self.part1 = false;
					self.rotationMaxLeft2 = true;
				end;
			elseif self.part2 then
				self.cos2 = self.cos2 - dt;
				if self.cos2 <= 0 then
					self.rotationMaxLeft = self.robotniczy;
					self.cos3 = 7000;
					self.part3 = true;
					self.part2 = false;
				end;
			elseif self.part3 then
				self.cos3 = self.cos3 - dt;
				if self.cos3 <= 0 then
					self.gotowy = true;
					self.translationMax3 = true;
					self.translationMax4 = true;
					self.rotationMaxLeft6 = true;
					self.rotationMaxLeft7 = true;
					self.rotationMaxLeft8 = true;
					self.part3 = false;
				end;
			end;
		else
			self.translationMax3 = false;
			self.translationMax4 = false;
			self.rotationMaxLeft6 = false;
			self.rotationMaxLeft7 = false;
			self.rotationMaxLeft8 = false;
			if self.part1 then
				self.cos = self.cos - dt;
				if self.cos <= 0 then
					self.cos2 = 5000;
					self.part2 = true;
					self.part1 = false;
					self.rotationMaxLeft = self.robotniczy;
				end;
			elseif self.part2 then
				self.cos2 = self.cos2 - dt;
				if self.cos2 <= 0 then
					self.rotationMaxLeft2 = self.robotniczy;
					self.cos3 = 5000;
					self.part3 = true;
					self.part2 = false;
				end;
			elseif self.part3 then
				self.cos3 = self.cos3 - dt;
				if self.cos3 <= 0 then
					self.gotowy = true;
					self.rotationMaxLeft2 = self.robotniczy;
					self.rotationMaxLeft3 = self.robotniczy;
					self.part3 = false;
				end;
			end;
			self.gotowy = false;
		end;
		
		if self.attacherVehicle then
			self.translationMax = true;
			self.translationMax2 = true;
		else
			self.translationMax = false;
			self.translationMax2 = false;
		end;

		if self.gotowydoskladania then
			if self.rotationPartLeft ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
				setRotation(self.rotationPartLeft.node, unpack(newRot));
			end;

			if self.rotationPartLeft2 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft2.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft2.maxRot, self.rotationPartLeft2.minRot, 3, self.rotationPartLeft2.rotTime, dt, not self.rotationMaxLeft2);
				setRotation(self.rotationPartLeft2.node, unpack(newRot));
			end;
			
			if self.rotationPartLeft3 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft3.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft3.maxRot, self.rotationPartLeft3.minRot, 3, self.rotationPartLeft3.rotTime, dt, not self.rotationMaxLeft3);
				setRotation(self.rotationPartLeft3.node, unpack(newRot));
			end;
		end;
		
		if self.gotowy then
			if self.rotationPartLeft4 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft4.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft4.maxRot, self.rotationPartLeft4.minRot, 3, self.rotationPartLeft4.rotTime, dt, not self.rotationMaxLeft4);
				setRotation(self.rotationPartLeft4.node, unpack(newRot));
			end;
				
			if self.rotationPartLeft5 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft5.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft5.maxRot, self.rotationPartLeft5.minRot, 3, self.rotationPartLeft5.rotTime, dt, not self.rotationMaxLeft5);
				setRotation(self.rotationPartLeft5.node, unpack(newRot));
			end;
		end;
		
		if self.rotationPartLeft6 ~= nil then
			local x, y, z = getRotation(self.rotationPartLeft6.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft6.maxRot, self.rotationPartLeft6.minRot, 3, self.rotationPartLeft6.rotTime, dt, not self.rotationMaxLeft6);
			setRotation(self.rotationPartLeft6.node, unpack(newRot));
		end;
		
		if self.gotowydoskladania and not self.rotationMaxLeft10 and not self.rotationMaxLeft9 then
			if self.rotationPartLeft7 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft7.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft7.maxRot, self.rotationPartLeft7.minRot, 3, self.rotationPartLeft7.rotTime, dt, not self.rotationMaxLeft7);
				setRotation(self.rotationPartLeft7.node, unpack(newRot));
			end;
				
			if self.rotationPartLeft8 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft8.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft8.maxRot, self.rotationPartLeft8.minRot, 3, self.rotationPartLeft8.rotTime, dt, not self.rotationMaxLeft8);
				setRotation(self.rotationPartLeft8.node, unpack(newRot));
			end;
		end;
		
		if self.gotowy then
			if self.rotationPartLeft9 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft9.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft9.maxRot, self.rotationPartLeft9.minRot, 3, self.rotationPartLeft9.rotTime, dt, not self.rotationMaxLeft9);
				setRotation(self.rotationPartLeft9.node, unpack(newRot));
			end;
				
			if self.rotationPartLeft10 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft10.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft10.maxRot, self.rotationPartLeft10.minRot, 3, self.rotationPartLeft10.rotTime, dt, not self.rotationMaxLeft10);
				setRotation(self.rotationPartLeft10.node, unpack(newRot));
			end;
			if self.rotationPartLeft14 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft14.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft14.maxRot, self.rotationPartLeft14.minRot, 3, self.rotationPartLeft14.rotTime, dt, not self.rotationMaxLeft14);
				setRotation(self.rotationPartLeft14.node, unpack(newRot));
			end;
				
			if self.rotationPartLeft15 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft15.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft15.maxRot, self.rotationPartLeft15.minRot, 3, self.rotationPartLeft15.rotTime, dt, not self.rotationMaxLeft15);
				setRotation(self.rotationPartLeft15.node, unpack(newRot));
			end;
			if self.rotationPartLeft11 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft11.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft11.maxRot, self.rotationPartLeft11.minRot, 3, self.rotationPartLeft11.rotTime, dt, not self.rotationMaxLeft11);
				setRotation(self.rotationPartLeft11.node, unpack(newRot));
			end;
			
			if self.rotationPartLeft12 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft12.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft12.maxRot, self.rotationPartLeft12.minRot, 3, self.rotationPartLeft12.rotTime, dt, not self.rotationMaxLeft12);
				setRotation(self.rotationPartLeft12.node, unpack(newRot));
			end;
		end;
		
		if self.translationMax ~= nil then
			local x, y, z = getTranslation(self.translationPart.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
			setTranslation(self.translationPart.node, unpack(newTrans));
		end;
		
		if self.translationMax2 ~= nil then
			local x, y, z = getTranslation(self.translationPart2.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2);
			setTranslation(self.translationPart2.node, unpack(newTrans));
		end;
		
		
		
		if self.dotykaziemi and self.attacherVehicle then
			if not self.sowingsoundplayed  and self.fillLevel > 0 then
				playSample(self.sowingSoundId,0,1,0);
				playSample(self.seederSoundId,1,1,0);
				self.sowingsoundplayed = true;
			end
			
			self.rotationSpeed = 40;
			if self.drum1 ~= nil then
				rotate(self.drum1, self.drumRotationScale * self.rotationSpeed, 0, 0);
			end;
			if self.drum2 ~= nil then
				rotate(self.drum2, self.drumRotationScale * self.rotationSpeed, 0, 0);
			end;
			if self.drum3 ~= nil then
				rotate(self.drum3, self.drumRotationScale * self.rotationSpeed, 0, 0);
			end;
			if self.drum4 ~= nil then
				rotate(self.drum4, self.drumRotationScale * self.rotationSpeed, 0, 0);
			end;
			if self.drum5 ~= nil then
				rotate(self.drum5, self.drumRotationScale * self.rotationSpeed, 0, 0);
			end;
			if self.drum6 ~= nil then
				rotate(self.drum6, self.drumRotationScale * self.rotationSpeed, 0, 0);
			end;
			if self.drum7 ~= nil then
				rotate(self.drum7, self.drumRotationScale * self.rotationSpeed, 0, 0);
			end;
			if self.drum8 ~= nil then
				rotate(self.drum8, self.drumRotationScale * self.rotationSpeed, 0, 0);
			end;
			if self.drum9 ~= nil then
				rotate(self.drum9, self.drumRotationScale * self.rotationSpeed, 0, 0);
			end;

			if self.rotationMaxLeft9 then
				if self.drum11 ~= nil then
					rotate(self.drum11, -self.drumRotationScale * self.rotationSpeed, 0, 0);
				end;
			end;
		
		else
			if self.sowingsoundplayed then
				stopSample(self.sowingSoundId);
				playSample(self.seederSoundId,1,1,0);
				self.sowingsoundplayed = false;
			end

		end;
		
		if self.attacherVehicle then
			if self.rotationMaxLeft9 and self.dotykaziemi and self.markerright then
				if self.cuttingAreas[1] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);		
					Utils.updatePloughArea(x, z, x1, z1, x2, z2, false);
				end;
			end;
			
			if self.rotationMaxLeft10 and self.dotykaziemi and self.markerleft then
				if self.cuttingAreas[2] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreas[2].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[2].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[2].height);		
					Utils.updatePloughArea(x, z, x1, z1, x2, z2, false);
				end;
			end;
			
			local area = 0;		
			
			if self.dotykaziemi then
				if self.cuttingAreas[3] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreas[3].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[3].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[3].height);		
					area = Utils.updateSowingArea(self.currentFillType-3, x, z, x1, z1, x2, z2);
				end;
			end;
			
			if self.dotykaziemi and self.markers and self.fillLevel > 0 then
				if self.cuttingAreas[4] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreas[4].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[4].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[4].height);		
					Utils.updatePloughArea(x, z, x1, z1, x2, z2, false);
				end;
				if self.cuttingAreas[5] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreas[5].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[5].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[5].height);		
					Utils.updatePloughArea(x, z, x1, z1, x2, z2, false);
				end;
			end;
			
			local pixelToQm = 2048 / 8192 * 2048 / 8192;
			local qm = area*pixelToQm;
			local ha = qm/10000;
			local usage = 0.0001*qm*self.seedPerQm;
					g_currentMission.missionStats.seedUsageTotal = g_currentMission.missionStats.seedUsageTotal + usage;
					g_currentMission.missionStats.seedUsageSession = g_currentMission.missionStats.seedUsageSession + usage;
					g_currentMission.missionStats.hectaresSeededTotal = g_currentMission.missionStats.hectaresSeededTotal + ha;
					g_currentMission.missionStats.hectaresSeededSession = g_currentMission.missionStats.hectaresSeededSession + ha;
					g_currentMission.missionStats.seedingDurationTotal = g_currentMission.missionStats.seedingDurationTotal + dt/(1000*60);
					g_currentMission.missionStats.seedingDurationSession = g_currentMission.missionStats.seedingDurationSession + dt/(1000*60);

					
			if self.attacherVehicle.lastSpeed*3600 > 0.1 then 
				self:setFillLevel(self.fillLevel-usage, self.currentFillType);
			end;
			
			if self.dotykaziemi and self.fillLevel > 0 then
				Utils.setEmittingState(self.dustParticleSystems, true);
			else
				Utils.setEmittingState(self.dustParticleSystems, false);
			end;
		end;
	if self.dotykaziemi then
		if self.sowingsoundplayed and self.fillLevel <= 0 then
			stopSample(self.sowingSoundId);
			playSample(self.seederSoundId,1,1,0);
			self.sowingsoundplayed = false;
		end
	end;
	else
		if self.sowingsoundplayed and self.fillLevel <= 0 then
			stopSample(self.sowingSoundId);
			playSample(self.seederSoundId,1,1,0);
			self.sowingsoundplayed = false;
		end;
		Utils.setEmittingState(self.dustParticleSystems, false);
	end;
			if self.rotationPartLeft13 ~= nil then
				local x, y, z = getRotation(self.rotationPartLeft13.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft13.maxRot, self.rotationPartLeft13.minRot, 3, self.rotationPartLeft13.rotTime, dt, not self.rotationMaxLeft13);
				setRotation(self.rotationPartLeft13.node, unpack(newRot));
			end;

end;

function Lemken_Solitair_12:draw()
	if self.attacherVehicle then
		if self.gotowydoskladania and not self.rotationMaxLeft10 and not self.rotationMaxLeft9 then
			g_currentMission:addExtraPrintText("Key X - Workmode on/off");
		end;
		if self.gotowy then
			g_currentMission:addExtraPrintText("NumPad 1,5,3 - Plough");
			g_currentMission:addExtraPrintText("Numpad 2 - Lower Seeder on/off");
			g_currentMission:addExtraPrintText("Key Z - Open/Close Refill");
		end;
	end;
end;

function Lemken_Solitair_12:onAttach(attacherVehicle)
    self.TurnRadiusBackup = self.attacherVehicle.aiTractorTurnRadius;
    self.attacherVehicle.aiTractorTurnRadius = 0;
end;

function Utils.destroyCompleteArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	local meadowId 		 = g_currentMission.meadowId;
	local cuttedMeadowId = g_currentMission.cuttedMeadowId;
	Utils.updateDensity(meadowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	Utils.updateDensity(cuttedMeadowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
end;

function Lemken_Solitair_12:allowFillType(fillType)
    return self.fillTypes[fillType] == true;
end;

function Lemken_Solitair_12:aiLower()
		self.rotationMaxLeft4 = not self.rotationMaxLeft4;
		self.rotationMaxLeft5 = not self.rotationMaxLeft5;
		self.gotowydoskladania = false;
		self.cos4 = 1000;
end; 

function Lemken_Solitair_12:aiRaise()
		self.rotationMaxLeft4 = not self.rotationMaxLeft4;
		self.rotationMaxLeft5 = not self.rotationMaxLeft5;
		self.gotowydoskladania = false;
		self.cos4 = 1000;
end; 	

function Lemken_Solitair_12:setActive(active)

end;

