LemkenGigant1400 = {};
source("dataS/scripts/vehicles/specializations/CultivatorAreaEvent.lua");
function LemkenGigant1400.prerequisitesPresent(specializations)
	print(string.format("\n\t%s\n", "Script Edit by sKyDaNcEr www.luackermann.de"));
    return true;
end;
function LemkenGigant1400:load(xmlFile)
    self.aiTerrainDetailChannel1 = g_currentMission.ploughChannel;
    self.aiTerrainDetailChannel2 = g_currentMission.sowingChannel;
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
	for i=1, numCuttingAreas do
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
		self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
	end;
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory); 
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
    self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)
    end;	
	local numSpinnerParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.SpinnerParts#count"), 0);
    self.SpinnerParts = {};
    for i=1, numSpinnerParts do
		local partnamei = string.format("vehicle.SpinnerParts.part" .. "%d", i);
		self.SpinnerParts[i] = {};
		self.SpinnerParts[i].index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partnamei .. "#index"));
		self.SpinnerParts[i].Scale = Utils.getNoNil(getXMLInt(xmlFile, partnamei .. "#rotScale"), 10);
    end;
	self.leftwheel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.supportWheels#left"));
	self.rightwheel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.supportWheels#right"));	
	self.speedViolationMaxTime = 2500;
	self.speedViolationTimer = self.speedViolationMaxTime
	self.AIon = false;
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");	
	self.rotationSpeed = 0;
	self.rotationSpeedDownRate = 0;
	self.lastMovingDirection = 0;
	self.cuttingAreasSend = {};
	self.lower = false;
	self.open = false;
	self.saveAILM = self.aiLeftMarker;
	self.aiLeftMarker = nil; 
	self.cultivatorLimitToField = true;
	self.maxSpeedLevel = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxSpeedLevel#value"), 1);
	self.allowclints = false;
	self.allowowner = false;
	self.alloweins = g_currentMission.allowClientsCreateFields ;
	self.berechtigt = false;
end;
function LemkenGigant1400:readStream(streamId, connection)
	self.berechtigt = streamReadBool(streamId);	
	self.cultivatorLimitToField = streamReadBool(streamId);	
end;
function LemkenGigant1400:writeStream(streamId, connection)
	streamWriteBool(streamId, self.berechtigt);
	streamWriteBool(streamId, self.cultivatorLimitToField);
end;
function LemkenGigant1400:update(dt)
	if self.attacherVehicle then
		if self.berechtigt then
			if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
				self.cultivatorLimitToField = not self.cultivatorLimitToField
				LG1400umschaltEvent.sendEvent(self, self.cultivatorLimitToField)
			end;
		end;
		if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.LemkenGigant1400_Transport) then
			if self.open then
				if self.lower then
					self:setAnimationTime(2, self.animationParts[2].offSet, false);
					self:setAnimationTime(3, self.animationParts[3].offSet, false);
					self:setAnimationTime(1, self.animationParts[1].offSet, false);
				else
					self:setAnimationTime(1, self.animationParts[1].offSet, false);
				end;
			else
				self:setAnimationTime(1, self.animationParts[1].animDuration, false);
			end;
		end;
		
		if self.open then
			if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.LemkenGigant1400_lower) then
				if self.lower then
					self:setAnimationTime(2, self.animationParts[2].offSet, false);
					self:setAnimationTime(3, self.animationParts[3].offSet, false);
				else
					self:setAnimationTime(2, self.animationParts[2].animDuration, false);
					self:setAnimationTime(3, self.animationParts[3].animDuration, false);
				end;
			end;
		end;
		if self.animationParts[2].inputDone and self.animationParts[2].clipEndTime and self.animationParts[3].inputDone and self.animationParts[3].clipEndTime then
			self.lower = true;
		elseif not self.animationParts[2].clipEndTime and not self.animationParts[3].clipEndTime then
			self.lower = false;
		end;
		if self.animationParts[1].inputDone and self.animationParts[1].clipEndTime then
			self.open = true;
		elseif not self.animationParts[1].clipEndTime then
			self.open = false;
		end;
	end;
end;
function LemkenGigant1400:updateTick(dt)
	if self.attacherVehicle then
		if self.isServer then
			self.allowzwie = g_currentMission.allowClientsCreateFields;
			if not self.allowzwie == self.alloweins then
				self.alloweins = g_currentMission.allowClientsCreateFields;
				self.berechtigt = not self.berechtigt;
				self.cultivatorLimitToField = true;
				LemkenGigant1400Event.sendEvent(self, self.berechtigt)
				LG1400umschaltEvent.sendEvent(self, self.cultivatorLimitToField)
			end;
			local owner = self:getOwner();
			if owner ~= nil and owner:getIsLocal() then
				self.berechtigt = true;
			end;
		end;
		if self.attacherVehicle.isAITractorActivated ~= nil then
			self.AIon = self.attacherVehicle.isAITractorActivated;
		end; 
		if self.lower == false and self.AIon == false and self.attacherVehicle.isAITractorActivated ~= nil then
			self.aiLeftMarker = nil; 
			AITractor.updateToolsInfo(self.attacherVehicle)
		end;
		if self.open then
			local x,y,z = getRotation(self.wheels[1].repr);	
			setRotation(self.leftwheel, x, y, z);
			setRotation(self.rightwheel, x, y, z);			
			if self.lower then
				local speedLimit = 20;
				if self.maxSpeedLevel == 2 then
					speedLimit = 30;
				elseif self.maxSpeedLevel == 3 then
					speedLimit = 100;
				end;
				if self:doCheckSpeedLimit() and self.lastSpeed*3600 > speedLimit then
					self.speedViolationTimer = self.speedViolationTimer - dt;
					if self.isServer then
						if self.speedViolationTimer < 0 then
							if self.attacherVehicle then
								self.attacherVehicle:detachImplementByObject(self);
							end;
						end;
					end;
				else
					self.speedViolationTimer = self.speedViolationMaxTime;
				end;
				if self.animationParts[2].inputDone and self.animationParts[2].clipEndTime and self.attacherVehicle.isAITractorActivated ~= nil then 
					self.aiLeftMarker = self.saveAILM; 
					AITractor.updateToolsInfo(self.attacherVehicle)
				end; 
				local cuttingAreasSend = {};
				for k, cuttingArea in pairs(self.cuttingAreas) do
					if self:getIsAreaActive(cuttingArea) then
						local x,y,z = getWorldTranslation(cuttingArea.start);
						local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
						local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
						table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
					end;
				end;
				if table.getn(cuttingAreasSend) > 0 then
					local limitToField = self.cultivatorLimitToField;
					CultivatorAreaEvent.runLocally(cuttingAreasSend, limitToField);
					CultivatorAreaEvent:new(cuttingAreasSend, limitToField);
				end;
				self.rotationSpeed = self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection;
				self.rotationSpeedDownRate = math.abs(self.rotationSpeed * 0.02);
				self.lastMovingDirection = self.attacherVehicle.movingDirection;
				self.rotationSpeed = self.rotationSpeed - self.rotationSpeedDownRate;
				local rotS = self.rotationSpeed * 1000; 
				if self.isClient then
					if rotS == 0 then
						self.rotationSpeed = 0;
						Utils.setEmittingState(self.dustParticleSystems, false)
						if self.workSoundEnabled then
							stopSample(self.workSound);
							self.workSoundEnabled = nil;
						end;
					else
						Utils.setEmittingState(self.dustParticleSystems, true)
						if not self.workSoundEnabled and not self.AIon then
							setSamplePitch(self.workSound, self.workSoundPitchOffset);
							playSample(self.workSound, 0, self.workSoundVolume, 0);
							self.workSoundEnabled = true;
						end;
						
					end; 	
				end;
				for i=1, table.getn(self.SpinnerParts) do
					rotate(self.SpinnerParts[i].index , self.SpinnerParts[i].Scale * self.rotationSpeed ,0,0);
				end;
			else
				if self.isClient then
					if self.workSoundEnabled then
						stopSample(self.workSound);
						self.workSoundEnabled = nil;
					end;
					Utils.setEmittingState(self.dustParticleSystems, false)
				end;
				self.speedViolationTimer = self.speedViolationMaxTime;
			end;	
		end;
	end; 
end;
function LemkenGigant1400:onAttach(attacherVehicle)
	self:setAnimationTime(4, self.animationParts[4].animDuration, false);
end;
function LemkenGigant1400:onDetach()
	self.cultivatorLimitToField = true;
	self:setAnimationTime(4, self.animationParts[4].startPosition, false);
	Utils.setEmittingState(self.dustParticleSystems, false)
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = nil;
	end;
end;
	
function LemkenGigant1400:keyEvent(unicode, sym, modifier, isDown)
end;
function LemkenGigant1400:draw()		
	if self.open then
		if self.berechtigt then
			if self.cultivatorLimitToField then
				g_currentMission:addHelpButtonText("normal Mode",InputBinding.IMPLEMENT_EXTRA);
			else
				g_currentMission:addHelpButtonText("safe Mode", InputBinding.IMPLEMENT_EXTRA);   
			end; 
		end;
		g_currentMission:addHelpButtonText(g_i18n:getText("LemkenGigant1400.3"), InputBinding.LemkenGigant1400_Transport);
		if self.lower then
			if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
				local buttonName = InputBinding.SPEED_LEVEL1;
				if self.maxSpeedLevel == 2 then
					buttonName = InputBinding.SPEED_LEVEL2;
				elseif self.maxSpeedLevel == 3 then
					buttonName = InputBinding.SPEED_LEVEL3;
				end;
				g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), tostring(self.maxSpeedLevel), InputBinding.getKeyNamesOfDigitalAction(buttonName)), 0.07+0.022, 0.019+0.029);
			end;
			g_currentMission:addHelpButtonText(g_i18n:getText("LemkenGigant1400.6"), InputBinding.LemkenGigant1400_lower); 
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("LemkenGigant1400.5"), InputBinding.LemkenGigant1400_lower); 
		end; 
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("LemkenGigant1400.4"), InputBinding.LemkenGigant1400_Transport);
	end;
end;
function LemkenGigant1400:delete()
	Utils.setEmittingState(self.dustParticleSystems, false)
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = nil;
	end;	
end;
function LemkenGigant1400:mouseEvent(posX, posY, isDown, isUp, button)
end;
function LemkenGigant1400:aiLower()
	self:setAnimationTime(2, self.animationParts[2].animDuration, false);
	self:setAnimationTime(3, self.animationParts[3].animDuration, false);
end; 
function LemkenGigant1400:aiRaise()
	self:setAnimationTime(2, self.animationParts[2].offSet, false);
	self:setAnimationTime(3, self.animationParts[3].offSet, false);
end; 
------------------------------------------- event -------------------------------------------
LemkenGigant1400Event = {};
LemkenGigant1400Event_mt = Class(LemkenGigant1400Event, Event);
InitEventClass(LemkenGigant1400Event, "LemkenGigant1400Event");
function LemkenGigant1400Event:emptyNew()
    local self = Event:new(LemkenGigant1400Event_mt);
    self.className="LemkenGigant1400Event";
    return self;
end;
function LemkenGigant1400Event:new(object, data)
    local self = LemkenGigant1400Event:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;
function LemkenGigant1400Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	self.data = streamReadBool(streamId);
	self.object.berechtigt = self.data;
	if not connection:getIsServer() then
        g_server:broadcastEvent(LemkenGigant1400Event:new(self.object, self.data), nil, connection, self.object);
    end;
end;
function LemkenGigant1400Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.data);
end;
function LemkenGigant1400Event.sendEvent(vehicle, data)
	if g_server ~= nil then
		g_server:broadcastEvent(LemkenGigant1400Event:new(vehicle, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(LemkenGigant1400Event:new(vehicle, data));
	end;
end;
LG1400umschaltEvent = {};
LG1400umschaltEvent_mt = Class(LG1400umschaltEvent, Event);
InitEventClass(LG1400umschaltEvent, "LG1400umschaltEvent");
function LG1400umschaltEvent:emptyNew()
    local self = Event:new(LG1400umschaltEvent_mt);
    self.className="LG1400umschaltEvent";
    return self;
end;
function LG1400umschaltEvent:new(object, data)
    local self = LG1400umschaltEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;
function LG1400umschaltEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	self.data = streamReadBool(streamId);
	self.object.cultivatorLimitToField = self.data;
	if not connection:getIsServer() then
        g_server:broadcastEvent(LG1400umschaltEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;
function LG1400umschaltEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.data);
end;
function LG1400umschaltEvent.sendEvent(vehicle, data)
	if g_server ~= nil then
		g_server:broadcastEvent(LG1400umschaltEvent:new(vehicle, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(LG1400umschaltEvent:new(vehicle, data));
	end;
end;