--
-- Gregoire_Besson_SPEF9
-- This is the specialization for Gregoire_Besson_SPEF9
--
-- 29/12/09 guimchevalier from TSF3 www.tsforum3.com 

Gregoire_Besson_SPEF9 = {};

function Gregoire_Besson_SPEF9.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Gregoire_Besson_SPEF9:load(xmlFile)
	-- moving parts
	self.rot = {};
	self.comp = {};
	local varName = "reverse";
	local text = "vehicle.reverse";
	local tempNode = Utils.indexToObject(self.components, getXMLString(xmlFile, text.."#index"));
	if tempNode ~= nil then		
        self.rot[varName] = {};
        self.rot[varName].node = tempNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle."..varName.."#minRot"));
        self.rot[varName].mini = {};
        self.rot[varName].mini[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rot[varName].mini[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rot[varName].mini[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle."..varName.."#maxRot"));
        self.rot[varName].maxi = {};
        self.rot[varName].maxi[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rot[varName].maxi[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rot[varName].maxi[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rot[varName].rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle."..varName.."#rotTime"), 2)*1000;
		self.rot[varName].touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle."..varName.."#touchRotLimit"), 1));
	end;

	local text = "vehicle.lower";
	local varName = "lower";
	local tempNode = Utils.indexToObject(self.components, getXMLString(xmlFile, text.."#index"));
	if tempNode ~= nil then
		
        self.rot[varName] = {};
        self.rot[varName].node = tempNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle."..varName.."#minRot"));
        self.rot[varName].mini = {};
        self.rot[varName].mini[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rot[varName].mini[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rot[varName].mini[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle."..varName.."#maxRot"));
        self.rot[varName].maxi = {};
        self.rot[varName].maxi[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rot[varName].maxi[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rot[varName].maxi[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rot[varName].rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle."..varName.."#rotTime"), 2)*1000;
		self.rot[varName].touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle."..varName.."#touchRotLimit"), 1));
    end;
	
	-- hydraulics
	self.numHydraulics = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, self.numHydraulics do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].cylAxle = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName.."#cylAxle"));
		self.hydraulics[i].rod = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#rod"));
		self.hydraulics[i].rodAxle = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#rodAxle"));
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].cylAxle);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].rodAxle);		
		self.hydraulics[i].outDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;

	-- particles
	self.allowPloughParticle = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.allowPloughParticle#value"), 1);	
	if self.allowPloughParticle then
		self.groundParticleSystems1R = {};
		local psName = "vehicle.groundParticleSystem1R";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems1R, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive1R = false;

		self.groundParticleSystems2R = {};
		local psName = "vehicle.groundParticleSystem2R";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems2R, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive2R = false;
		
		self.groundParticleSystems3R = {};
		local psName = "vehicle.groundParticleSystem3R";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems3R, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive3R = false;
		
		self.groundParticleSystems4R = {};
		local psName = "vehicle.groundParticleSystem4R";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems4R, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive4R = false;
		
		self.groundParticleSystems5R = {};
		local psName = "vehicle.groundParticleSystem5R";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems5R, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive5R = false;
		
		self.groundParticleSystems6R = {};
		local psName = "vehicle.groundParticleSystem6R";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems6R, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive6R = false;
		
		self.groundParticleSystems7R = {};
		local psName = "vehicle.groundParticleSystem7R";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems7R, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive7R = false;
		
		self.groundParticleSystems8R = {};
		local psName = "vehicle.groundParticleSystem8R";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems8R, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive8R = false;
			
		self.groundParticleSystems1L = {};
		local psName = "vehicle.groundParticleSystem1L";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems1L, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive1L = false;

		self.groundParticleSystems2L = {};
		local psName = "vehicle.groundParticleSystem2L";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems2L, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive2L = false;
		
		self.groundParticleSystems3L = {};
		local psName = "vehicle.groundParticleSystem3L";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems3L, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive3L = false;
		
		self.groundParticleSystems4L = {};
		local psName = "vehicle.groundParticleSystem4L";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems4L, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive4L = false;
		
		self.groundParticleSystems5L = {};
		local psName = "vehicle.groundParticleSystem5L";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems5L, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive5L = false;
		
		self.groundParticleSystems6L = {};
		local psName = "vehicle.groundParticleSystem6L";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems6L, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive6L = false;
		
		self.groundParticleSystems7L = {};
		local psName = "vehicle.groundParticleSystem7L";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems7L, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive7L = false;
		
		self.groundParticleSystems8L = {};
		local psName = "vehicle.groundParticleSystem8L";
		Utils.loadParticleSystem(xmlFile, self.groundParticleSystems8L, psName, self.components, false, nil, self.baseDirectory)
		self.groundParticleSystemActive8L = false;
	end;
	
	self.groundParticleSystemsA = {};
    local psName = "vehicle.groundParticleSystemA";
    Utils.loadParticleSystem(xmlFile, self.groundParticleSystemsA, psName, self.components, false, nil, self.baseDirectory)
    self.groundParticleSystemActiveA = false;
	
	self.groundParticleSystemsB = {};
    local psName = "vehicle.groundParticleSystemB";
    Utils.loadParticleSystem(xmlFile, self.groundParticleSystemsB, psName, self.components, false, nil, self.baseDirectory)
    self.groundParticleSystemActiveB = false;
	
	--Sounds
	local hydraulicSound = getXMLString(xmlFile, "vehicle.hydraulicSound#file");
    if hydraulicSound ~= nil and hydraulicSound ~= "" then
        hydraulicSound = Utils.getFilename(hydraulicSound, self.baseDirectory);
        self.hydraulicSound = createSample("hydraulicSound");
        loadSample(self.hydraulicSound, hydraulicSound, false);
        self.hydraulicSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSound#pitchOffset"), 0);
        self.hydraulicSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSound#volume"), 1.0);
        self.hydraulicSoundEnabled = false;
    end;
	self.allowHydraulicSound = false ;
    self.eps = Utils.degToRad(1);
	local ploughSound = getXMLString(xmlFile, "vehicle.ploughSound#file");
    if ploughSound ~= nil and ploughSound ~= "" then
        ploughSound = Utils.getFilename(ploughSound, self.baseDirectory);
        self.ploughSound = createSample("ploughSound");
        loadSample(self.ploughSound, ploughSound, false);
        self.ploughSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughSound#pitchOffset"), 0);
        self.ploughSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughSound#volume"), 1.0);
        self.ploughSoundEnabled = false;
    end;
	
	--LoadRotation(self,"left")
	-- keys
	self.keys = {};
	self.keysName = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
		self.keysName[inputName] = Utils.getNoNil(getXMLString(xmlFile, baseName.."#keyname"),"Touche ?");
        i = i+1;
    end;
	
	self.lower = {};
	self.reverse = {};
	self.reverse.previous = "left";
	self.reverse.input = "top";
	self.reverse.direction = false;
	self.reverse.top = true;
	self.reverse.rotated = false;
	self.rotationMaxSupport = true;	
	self.lower.direction = false
	self.lower.lowered = false;
	self.frontActiveLeft = false;
	self.frontActiveRight = false;
	self.backActiveLeft = false;
	self.backActiveRight = false;
end;

function Gregoire_Besson_SPEF9:delete()
	Utils.deleteParticleSystem(self.groundParticleSystemsA);
	Utils.deleteParticleSystem(self.groundParticleSystemsB);
	if self.allowPloughParticle then
		Utils.deleteParticleSystem(self.groundParticleSystems1R);
		Utils.deleteParticleSystem(self.groundParticleSystems1L);
		Utils.deleteParticleSystem(self.groundParticleSystems2R);
		Utils.deleteParticleSystem(self.groundParticleSystems2L);
		Utils.deleteParticleSystem(self.groundParticleSystems3R);
		Utils.deleteParticleSystem(self.groundParticleSystems3L);
		Utils.deleteParticleSystem(self.groundParticleSystems4R);
		Utils.deleteParticleSystem(self.groundParticleSystems4L);
		Utils.deleteParticleSystem(self.groundParticleSystems5R);
		Utils.deleteParticleSystem(self.groundParticleSystems5L);
		Utils.deleteParticleSystem(self.groundParticleSystems6R);
		Utils.deleteParticleSystem(self.groundParticleSystems6L);
		Utils.deleteParticleSystem(self.groundParticleSystems7R);
		Utils.deleteParticleSystem(self.groundParticleSystems7L);
		Utils.deleteParticleSystem(self.groundParticleSystems8R);
		Utils.deleteParticleSystem(self.groundParticleSystems8L);
	end;
	
	if self.hydraulicSound ~= nil then
        delete(self.hydraulicSound);
    end;
     if self.ploughSound ~= nil then
        delete(self.ploughSound);
    end;
end;

function Gregoire_Besson_SPEF9:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Gregoire_Besson_SPEF9:keyEvent(unicode, sym, modifier, isDown)
	if isDown then
		if sym == self.keys.reverse then
			if self.reverse.input == "top" and self.reverse.top then
				if self.reverse.previous == "right" then
					self.reverse.input = "right";
					self.reverse.previous = "left"
					self.rot.reverse.maxi[3] = -self.rot.reverse.maxi[3];
				else
					self.reverse.input = "left";
					self.reverse.previous = "right";
					self.rot.reverse.maxi[3] = -self.rot.reverse.maxi[3];
				end;
				self.reverse.direction = true;
			elseif self.reverse.input ~= "top" then
				self.reverse.input = "top";
				self.reverse.direction = false;
			end;
		end;
		if sym == self.keys.lower then
			self.lower.direction = not self.lower.direction;
		end;
	end;
end;

function Gregoire_Besson_SPEF9:update(dt)
	if self:getIsActive() then
		self.reverse.rotated = false;
		self.reverse.top = false;
		self.lower.lowered = false;
		self.allowHydraulicSound = false;
		-- Moving parts
		-- reverse
		local x, y, z = getRotation(self.rot.reverse.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rot.reverse.maxi, self.rot.reverse.mini,3, self.rot.reverse.rotTime, dt, not self.reverse.direction);
		setRotation(self.rot.reverse.node, x,y,newRot[3]);
		
		local eps = self.rot.reverse.touchRotLimit;
		
        if math.abs(z-self.rot.reverse.mini[3]) < eps then
			self.reverse.top = true;
		elseif math.abs(z-self.rot.reverse.maxi[3]) < eps then
			self.reverse.rotated = true;
		end;
		
		if math.abs(z-self.rot.reverse.mini[3]) > self.eps and math.abs(z-self.rot.reverse.maxi[3]) > self.eps then
			self.allowHydraulicSound = true;
		end;
		
		local node = self.componentJoints[3].jointNode;
		local x, y, z = getRotation(node);
		setRotation(node, x,y,-newRot[3]);
		
	    --lower    	
		local x, y, z = getRotation(self.rot.lower.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rot.lower.maxi, self.rot.lower.mini,3, self.rot.lower.rotTime, dt, not self.lower.direction);
		setRotation(self.rot.lower.node, unpack(newRot));
		
		local eps = self.rot.lower.touchRotLimit;
		
        if math.abs(x-self.rot.lower.maxi[1]) < eps then
			self.lower.lowered = true;
		end;
		
		if math.abs(x-self.rot.lower.mini[1]) > self.eps and math.abs(x-self.rot.lower.maxi[1]) > self.eps then
			self.allowHydraulicSound = true;
		end;
		
		local node = self.componentJoints[4].jointNode;
		local x, y, z = getRotation(node);
		local newRot = Utils.getMovedLimitedValues(rot, self.rot.lower.maxi, self.rot.lower.mini,3, self.rot.lower.rotTime, dt, not self.lower.direction);
		setRotation(node,-newRot[1],-newRot[2],-newRot[3]);
		
		setJointFrame(self.componentJoints[3].jointIndex, 1,self.componentJoints[3].jointNode);
		setJointFrame(self.componentJoints[4].jointIndex, 1,self.componentJoints[4].jointNode);
		
		--Hydraulic
		for i=1, self.numHydraulics do
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].cylAxle);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].rodAxle);
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].cylAxle), bx-ax, by-ay, bz-az);	
			setDirection(self.hydraulics[i].cylAxle, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulics[i].rod, 0,self.hydraulics[i].outDistance-distance,0 );
		end;
		
		--Particle cutting areas
		self.frontActiveLeft = false;
		self.frontActiveRight = false;
		self.backActiveLeft = false;
		self.backActiveRight = false;
		
		if self:isLowered(false) and self.reverse.rotated then
			local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
			local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
			local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
			Utils.updatePloughArea(x, z, x1, z1, x2, z2);		
			if self.reverse.input == "right" then
				self.frontActiveRight = true;
			elseif self.reverse.input == "left" then
				self.frontActiveLeft = true;
			end;
		end;
		
		if self.lower.lowered and self.reverse.rotated then
			local x,y,z = getWorldTranslation(self.cuttingAreas[2].start);
			local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[2].width);
			local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[2].height);
			Utils.updatePloughArea(x, z, x1, z1, x2, z2);
			local x,y,z = getWorldTranslation(self.cuttingAreas[3].start);
			local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[3].width);
			local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[3].height);
			Utils.updatePloughArea(x, z, x1, z1, x2, z2);
			if self.reverse.input == "right" then
				self.backActiveRight = true;
			elseif self.reverse.input == "left" then
				self.backActiveLeft = true;
			end;
		end;
		if self.allowPloughParticle then
			if self.frontActiveRight and self.lastSpeed*3600 > 3 then
				if not self.groundParticleSystemActive1R then
					self.groundParticleSystemActive1R = true;
					Utils.setEmittingState(self.groundParticleSystems1R, true);
				end;
				if not self.groundParticleSystemActive2R then
					self.groundParticleSystemActive2R = true;
					Utils.setEmittingState(self.groundParticleSystems2R, true);
				end;
				if not self.groundParticleSystemActive3R then
					self.groundParticleSystemActive3R = true;
					Utils.setEmittingState(self.groundParticleSystems3R, true);
				end;
				
			else	
				if self.groundParticleSystemActive1R then
					self.groundParticleSystemActive1R = false;
					Utils.setEmittingState(self.groundParticleSystems1R, false);
				end;
				if self.groundParticleSystemActive2R then
					self.groundParticleSystemActive2R = false;
					Utils.setEmittingState(self.groundParticleSystems2R, false);
				end;
				if self.groundParticleSystemActive3R then
					self.groundParticleSystemActive3R = false;
					Utils.setEmittingState(self.groundParticleSystems3R, false);
				end;
			end;
			if (self.frontActiveRight or self.backActiveRight) and self.lastSpeed*3600 > 3 then
				if not self.groundParticleSystemActive4R then
					self.groundParticleSystemActive4R = true;
					Utils.setEmittingState(self.groundParticleSystems4R, true);
				end;
				
			else
				if self.groundParticleSystemActive4R then
					self.groundParticleSystemActive4R = false;
					Utils.setEmittingState(self.groundParticleSystems4R, false);
				end;
				
			end;
			if self.backActiveRight and self.lastSpeed*3600 > 3 then
				if not self.groundParticleSystemActive5R then
					self.groundParticleSystemActive5R = true;
					Utils.setEmittingState(self.groundParticleSystems5R, true);
				end;
				if not self.groundParticleSystemActive6R then
					self.groundParticleSystemActive6R = true;
					Utils.setEmittingState(self.groundParticleSystems6R, true);
				end;
				if not self.groundParticleSystemActive7R then
					self.groundParticleSystemActive7R = true;
					Utils.setEmittingState(self.groundParticleSystems7R, true);
				end;
				if not self.groundParticleSystemActive8R then
					self.groundParticleSystemActive8R = true;
					Utils.setEmittingState(self.groundParticleSystems8R, true);
				end;
			else
				if self.groundParticleSystemActive5R then
					self.groundParticleSystemActive5R = false;
					Utils.setEmittingState(self.groundParticleSystems5R, false);
				end;
				if self.groundParticleSystemActive6R then
					self.groundParticleSystemActive6R = false;
					Utils.setEmittingState(self.groundParticleSystems6R, false);
				end;
				if self.groundParticleSystemActive7R then
					self.groundParticleSystemActive7R = false;
					Utils.setEmittingState(self.groundParticleSystems7R, false);
				end;
				if self.groundParticleSystemActive8R then
					self.groundParticleSystemActive8R = false;
					Utils.setEmittingState(self.groundParticleSystems8R, false);
				end;
			end;
			if self.frontActiveLeft and self.lastSpeed*3600 > 3 then
				if not self.groundParticleSystemActive1L then
					self.groundParticleSystemActive1L = true;
					Utils.setEmittingState(self.groundParticleSystems1L, true);
				end;
				if not self.groundParticleSystemActive2L then
					self.groundParticleSystemActive2L = true;
					Utils.setEmittingState(self.groundParticleSystems2L, true);
				end;
				if not self.groundParticleSystemActive3L then
					self.groundParticleSystemActive3L = true;
					Utils.setEmittingState(self.groundParticleSystems3L, true);
				end;
			else
				if self.groundParticleSystemActive1L then
					self.groundParticleSystemActive1L = false;
					Utils.setEmittingState(self.groundParticleSystems1L, false);
				end;
				if self.groundParticleSystemActive2L then
					self.groundParticleSystemActive2L = false;
					Utils.setEmittingState(self.groundParticleSystems2L, false);
				end;
				if self.groundParticleSystemActive3L then
					self.groundParticleSystemActive3L = false;
					Utils.setEmittingState(self.groundParticleSystems3L, false);
				end;
			end;
			if (self.frontActiveLeft or self.backActiveLeft) and self.lastSpeed*3600 > 3 then
				if not self.groundParticleSystemActive4L then
					self.groundParticleSystemActive4L = true;
					Utils.setEmittingState(self.groundParticleSystems4L, true);
				end;
			else
				if self.groundParticleSystemActive4L then
					self.groundParticleSystemActive4L = false;
					Utils.setEmittingState(self.groundParticleSystems4L, false);
				end;
			end;
			if self.backActiveLeft and self.lastSpeed*3600 > 3 then
				
				if not self.groundParticleSystemActive5L then
					self.groundParticleSystemActive5L = true;
					Utils.setEmittingState(self.groundParticleSystems5L, true);
				end;
				if not self.groundParticleSystemActive6L then
					self.groundParticleSystemActive6L = true;
					Utils.setEmittingState(self.groundParticleSystems6L, true);
				end;
				if not self.groundParticleSystemActive7L then
					self.groundParticleSystemActive7L = true;
					Utils.setEmittingState(self.groundParticleSystems7L, true);
				end;
				if not self.groundParticleSystemActive8L then
					self.groundParticleSystemActive8L = true;
					Utils.setEmittingState(self.groundParticleSystems8L, true);
				end;
			else
				
				if self.groundParticleSystemActive5L then
					self.groundParticleSystemActive5L = false;
					Utils.setEmittingState(self.groundParticleSystems5L, false);
				end;
				if self.groundParticleSystemActive6L then
					self.groundParticleSystemActive6L = false;
					Utils.setEmittingState(self.groundParticleSystems6L, false);
				end;
				if self.groundParticleSystemActive7L then
					self.groundParticleSystemActive7L = false;
					Utils.setEmittingState(self.groundParticleSystems7L, false);
				end;
				if self.groundParticleSystemActive8L then
					self.groundParticleSystemActive8L = false;
					Utils.setEmittingState(self.groundParticleSystems8L, false);
				end;
			end;
		end	
		if (self.backActiveLeft or self.backActiveRight) and self.lastSpeed*3600 > 8 then
			if not self.groundParticleSystemActiveA then
				self.groundParticleSystemActiveA = true;
				Utils.setEmittingState(self.groundParticleSystemsA, true);
			end;
		else
			if self.groundParticleSystemActiveA then
				self.groundParticleSystemActiveA = false;
				Utils.setEmittingState(self.groundParticleSystemsA, false);
			end;			
		end;
		if (self.backActiveLeft or self.backActiveRight) and self.lastSpeed*3600 > 8 then
			if not self.groundParticleSystemActiveB then
				self.groundParticleSystemActiveB = true;
				Utils.setEmittingState(self.groundParticleSystemsB, true);
			end;
		else
			if self.groundParticleSystemActiveB then
				self.groundParticleSystemActiveB = false;
				Utils.setEmittingState(self.groundParticleSystemsB, false);
			end;
		end;

		-- sounds
		if self.hydraulicSound ~= nil then
			if self.allowHydraulicSound and self:getIsActiveForSound() then
				if not self.hydraulicSoundEnabled then
					playSample(self.hydraulicSound, 0, self.hydraulicSoundVolume, 0);
					setSamplePitch(self.hydraulicSound, self.hydraulicSoundPitchOffset);
					self.hydraulicSoundEnabled = true;
				end;
			else
				stopSample(self.hydraulicSound);
				self.hydraulicSoundEnabled = false;
			end;
		end;
		if self.ploughSound ~= nil then
			if (self.frontActiveLeft or self.frontActiveRight or self.backActiveLeft or self.backActiveRight)and self.lastSpeed*3600 > 3 and self:getIsActiveForSound() then
				if not self.ploughSoundEnabled then
					playSample(self.ploughSound, 0, self.ploughSoundVolume, 0);
					setSamplePitch(self.ploughSound, self.ploughSoundPitchOffset);
					self.ploughSoundEnabled = true;
				end;
			else
				stopSample(self.ploughSound);
				self.ploughSoundEnabled = false;
			end;
		end;
	end;
end;


function Gregoire_Besson_SPEF9:draw()
	if self.reverse.input == "top" and self.reverse.top then
		if self.reverse.previous == "left" then
			g_currentMission:addExtraPrintText(self.keysName.reverse.." : turn right");		
		else
			g_currentMission:addExtraPrintText(self.keysName.reverse.." : turn left");
		end;
	elseif self.reverse.input ~= "top" then
		g_currentMission:addExtraPrintText(self.keysName.reverse.." : turn top");
	end;
	if self.lower.direction then
		g_currentMission:addExtraPrintText(self.keysName.lower.." : lift the plough");		
	else
		g_currentMission:addExtraPrintText(self.keysName.lower.." : lower the plough");
	end;
end;

function Gregoire_Besson_SPEF9:onAttach(attacherVehicle)
end;

function Gregoire_Besson_SPEF9:onDetach()
	Gregoire_Besson_SPEF9.onDeactivate(self);
end;
 
function Gregoire_Besson_SPEF9:onEnter()
end;

function Gregoire_Besson_SPEF9:onLeave()
	Gregoire_Besson_SPEF9.onDeactivate(self);
end;
 
function Gregoire_Besson_SPEF9:onActivate()
end;

function Gregoire_Besson_SPEF9:onDeactivate()
	if self.allowPloughParticle then
		if self.groundParticleSystemActive1R then
			self.groundParticleSystemActive1R = false;
			Utils.setEmittingState(self.groundParticleSystems1R, false);
		end;
		if self.groundParticleSystemActive1L then
			self.groundParticleSystemActive1L = false;
			Utils.setEmittingState(self.groundParticleSystems1L, false);
		end;
		if self.groundParticleSystemActive2R then
			self.groundParticleSystemActive2R = false;
			Utils.setEmittingState(self.groundParticleSystems2R, false);
		end;
		if self.groundParticleSystemActive2L then
			self.groundParticleSystemActive2L = false;
			Utils.setEmittingState(self.groundParticleSystems2L, false);
		end;
		if self.groundParticleSystemActive3R then
			self.groundParticleSystemActive3R = false;
			Utils.setEmittingState(self.groundParticleSystems3R, false);
		end;
		if self.groundParticleSystemActive3L then
			self.groundParticleSystemActive3L = false;
			Utils.setEmittingState(self.groundParticleSystems3L, false);
		end;
		if self.groundParticleSystemActive4R then
			self.groundParticleSystemActive4R = false;
			Utils.setEmittingState(self.groundParticleSystems4R, false);
		end;
		if self.groundParticleSystemActive4L then
			self.groundParticleSystemActive4L = false;
			Utils.setEmittingState(self.groundParticleSystems4L, false);
		end;
		if self.groundParticleSystemActive5R then
			self.groundParticleSystemActive5R = false;
			Utils.setEmittingState(self.groundParticleSystems5R, false);
		end;
		if self.groundParticleSystemActive5L then
			self.groundParticleSystemActive5L = false;
			Utils.setEmittingState(self.groundParticleSystems5L, false);
		end;
		if self.groundParticleSystemActive6R then
			self.groundParticleSystemActive6R = false;
			Utils.setEmittingState(self.groundParticleSystems6R, false);
		end;
		if self.groundParticleSystemActive6L then
			self.groundParticleSystemActive6L = false;
			Utils.setEmittingState(self.groundParticleSystems6L, false);
		end;
		if self.groundParticleSystemActive7R then
			self.groundParticleSystemActive7R = false;
			Utils.setEmittingState(self.groundParticleSystems7R, false);
		end;
		if self.groundParticleSystemActive7L then
			self.groundParticleSystemActive7L = false;
			Utils.setEmittingState(self.groundParticleSystems7L, false);
		end;
		if self.groundParticleSystemActive8R then
			self.groundParticleSystemActive8R = false;
			Utils.setEmittingState(self.groundParticleSystems8R, false);
		end;
		if self.groundParticleSystemActive8L then
			self.groundParticleSystemActive8L = false;
			Utils.setEmittingState(self.groundParticleSystems8L, false);
		end;
	end;
	if self.groundParticleSystemActiveA then
		self.groundParticleSystemActiveA = false;
		Utils.setEmittingState(self.groundParticleSystemsA, false);
	end;
	if self.groundParticleSystemActiveB then
		self.groundParticleSystemActiveB = false;
		Utils.setEmittingState(self.groundParticleSystemsB, false);
	end;
	Plough.onDeactivateSounds(self);
end;

function Plough:onDeactivateSounds()
    if self.ploughSoundEnabled then
        stopSample(self.ploughSound);
        self.ploughSoundEnabled = false;
    end;
    if self.hydraulicSound ~= nil and self.hydraulicSoundEnabled  then
        stopSample(self.hydraulicSound);
        self.hydraulicSoundEnabled = false;
    end;
end;
