-- newAttacherJoint
-- Specialisation for the newAttacher
--
-- @ Autor  Brndi
-- @ Date  10/9/11

newAttacherJoint = {};

Vehicle.registerJointType("Lemkenattacher");

function newAttacherJoint.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function newAttacherJoint:load(xmlFile)		

	self.updateJoint = false;

end;

function newAttacherJoint:delete()
end;

function newAttacherJoint:getIsTurnedOnAttachedImplements()
end;

function newAttacherJoint:readStream(streamId, connection)

	self.updateJoint = streamReadBool(streamId);

end;

function newAttacherJoint:writeStream(streamId, connection)

	streamWriteBool(streamId, self.updateJoint);
	
end;

function newAttacherJoint:mouseEvent(posX, posY, isDown, isUp, button)
end;

function newAttacherJoint:keyEvent(unicode, sym, modifier, isDown)
end;

function newAttacherJoint:update(dt)
end;

function newAttacherJoint:updateTick(dt)

	if self:getIsActiveForInput() then
		self.updateJoint = true;
	end;

	UpdateJointEvent.sendEvent(self, self.updateJoint, noEventSend);

end;

function newAttacherJoint:draw()

	if g_currentMission.attachableInMountRange ~= nil then
		g_currentMission.hudAttachmentOverlay:render();
	end;

end;

function newAttacherJoint:validateAttacherJoint(implement, jointDesc, dt)

    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;

end;