--
-- Leboulch
-- @poc@lypse
-- 
Leboulch = {};

function Leboulch.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Leboulch:load(xmlFile)


   self.keys = {};
	self.keysName = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
		self.keysName[inputName] = Utils.getNoNil(getXMLString(xmlFile, baseName.."#keyname"),"Touche ?");
        i = i+1;
    end;
	


      self.pipeParticleSystem = {};
    self.pipeParticleSystemindex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pipeParticleSystem#index"));
    Utils.loadParticleSystem(xmlFile, self.pipeParticleSystem, "vehicle.pipeParticleSystem", self.pipeParticleSystemindex, false, nil, self.baseDirectory);
  
    self.findTrailerRaycastCallback = Combine.findTrailerRaycastCallback;

    self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);

	self.barre = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.barre#index"));
    setVisibility(self.barre, true);

       
    self.ridens = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ridens#index"));
    setVisibility(self.ridens, false);

    self.ridbet = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ridbet#index"));
    setVisibility(self.ridbet, false);
   
     local rotationPartNodebequille = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bequille#index"));
    if rotationPartNodebequille ~= nil then
        self.rotationPartbequille = {};
        self.rotationPartbequille.node = rotationPartNodebequille;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbequille#minRot"));
        self.rotationPartbequille.minRot = {};
        self.rotationPartbequille.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbequille.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbequille.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bequille#maxRot"));
        self.rotationPartbequille.maxRot = {};
        self.rotationPartbequille.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbequille.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbequille.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbequille.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bequille#rotTime"), 2)*1000;
        self.rotationPartbequille.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.bequille#touchRotLimit"), 10));
    end;
 
       local translationPartNodebequille1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bequille1#index"));
    if translationPartNodebequille1 ~= nil then
        self.translationPartbequille1 = {};
        self.translationPartbequille1.node = translationPartNodebequille1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bequille1#minTrans"));
        self.translationPartbequille1.minTrans = {};
        self.translationPartbequille1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartbequille1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartbequille1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bequille1#maxTrans"));
        self.translationPartbequille1.maxTrans = {};
        self.translationPartbequille1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartbequille1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartbequille1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartbequille1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bequille1#transTime"), 2)*1000;
        self.translationPartbequille1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bequille1#touchTransLimit"), 10);
    end;

 
    local rotationPartNodecaisse = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.caisse#index"));
    if rotationPartNodecaisse ~= nil then
        self.rotationPartcaisse = {};
        self.rotationPartcaisse.node = rotationPartNodecaisse;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartcaisse#minRot"));
        self.rotationPartcaisse.minRot = {};
        self.rotationPartcaisse.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartcaisse.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartcaisse.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.caisse#maxRot"));
        self.rotationPartcaisse.maxRot = {};
        self.rotationPartcaisse.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartcaisse.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartcaisse.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartcaisse.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.caisse#rotTime"), 2)*1000;
        self.rotationPartcaisse.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.caisse#touchRotLimit"), 10));
    end;

     local rotationPartNodechassis = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.chassis#index"));
    if rotationPartNodechassis ~= nil then
        self.rotationPartchassis = {};
        self.rotationPartchassis.node = rotationPartNodechassis;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartchassis#minRot"));
        self.rotationPartchassis.minRot = {};
        self.rotationPartchassis.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartchassis.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartchassis.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.chassis#maxRot"));
        self.rotationPartchassis.maxRot = {};
        self.rotationPartchassis.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartchassis.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartchassis.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartchassis.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.chassis#rotTime"), 2)*1000;
        self.rotationPartchassis.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.chassis#touchRotLimit"), 10));
    end;

  
	
    local translationPartNodeverrin1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verrin1#index"));
    if translationPartNodeverrin1 ~= nil then
        self.translationPartverrin1 = {};
        self.translationPartverrin1.node = translationPartNodeverrin1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin1#minTrans"));
        self.translationPartverrin1.minTrans = {};
        self.translationPartverrin1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin1#maxTrans"));
        self.translationPartverrin1.maxTrans = {};
        self.translationPartverrin1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartverrin1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin1#transTime"), 2)*1000;
        self.translationPartverrin1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin1#touchTransLimit"), 10);
    end;
    
      local translationPartNodeverrin2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verrin2#index"));
    if translationPartNodeverrin2~= nil then
        self.translationPartverrin2 = {};
        self.translationPartverrin2.node = translationPartNodeverrin2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin2#minTrans"));
        self.translationPartverrin2.minTrans = {};
        self.translationPartverrin2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin2#maxTrans"));
        self.translationPartverrin2.maxTrans = {};
        self.translationPartverrin2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartverrin2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin2#transTime"), 2)*1000;
        self.translationPartverrin2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin2#touchTransLimit"), 10);
    end;


          local translationPartNodeverrin3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verrin3#index"));
    if translationPartNodeverrin3~= nil then
        self.translationPartverrin3 = {};
        self.translationPartverrin3.node = translationPartNodeverrin3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin3#minTrans"));
        self.translationPartverrin3.minTrans = {};
        self.translationPartverrin3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin3#maxTrans"));
        self.translationPartverrin3.maxTrans = {};
        self.translationPartverrin3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin3.maxTrans[3] = Utils.getNoNil(z, 0);
        self.translationPartverrin3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin3#transTime"), 2)*1000;
        self.translationPartverrin3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin3#touchTransLimit"), 10);
    end;

      local translationPartNodeverrin4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verrin4#index"));
    if translationPartNodeverrin4 ~= nil then
        self.translationPartverrin4 = {};
        self.translationPartverrin4.node = translationPartNodeverrin4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin4#minTrans"));
        self.translationPartverrin4.minTrans = {};
        self.translationPartverrin4.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin4.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin4.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin4#maxTrans"));
        self.translationPartverrin4.maxTrans = {};
        self.translationPartverrin4.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin4.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin4.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartverrin4.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin4#transTime"), 2)*1000;
        self.translationPartverrin4.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin4#touchTransLimit"), 10);
    end;

     local translationPartNodeverrin5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verrin5#index"));
    if translationPartNodeverrin5 ~= nil then
        self.translationPartverrin5 = {};
        self.translationPartverrin5.node = translationPartNodeverrin5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin5#minTrans"));
        self.translationPartverrin5.minTrans = {};
        self.translationPartverrin5.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin5.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin5.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin5#maxTrans"));
        self.translationPartverrin5.maxTrans = {};
        self.translationPartverrin5.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin5.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin5.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartverrin5.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin5#transTime"), 2)*1000;
        self.translationPartverrin5.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin5#touchTransLimit"), 10);
    end;

     local translationPartNodeverrin6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verrin6#index"));
    if translationPartNodeverrin6 ~= nil then
        self.translationPartverrin6 = {};
        self.translationPartverrin6.node = translationPartNodeverrin6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin6#minTrans"));
        self.translationPartverrin6.minTrans = {};
        self.translationPartverrin6.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin6.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin6.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin6#maxTrans"));
        self.translationPartverrin6.maxTrans = {};
        self.translationPartverrin6.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin6.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin6.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartverrin6.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin6#transTime"), 2)*1000;
        self.translationPartverrin6.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin6#touchTransLimit"), 10);
    end;
    
 local translationPartNodeverrin7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verrin7#index"));
    if translationPartNodeverrin7 ~= nil then
        self.translationPartverrin7 = {};
        self.translationPartverrin7.node = translationPartNodeverrin7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin7#minTrans"));
        self.translationPartverrin7.minTrans = {};
        self.translationPartverrin7.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin7.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin7.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.verrin7#maxTrans"));
        self.translationPartverrin7.maxTrans = {};
        self.translationPartverrin7.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartverrin7.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartverrin7.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartverrin7.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin7#transTime"), 2)*1000;
        self.translationPartverrin7.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.verrin7#touchTransLimit"), 10);
    end;
    
      
   self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;


   
    
        self.trailerPosition = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.trailerPosition#index"));
	
	self.grainUnloading = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainUnloading"), 10);
	
	self.allowDoorOpen = true;
	self.lower = false;
	 
	self.isExpanded = false;
	self.pipeParticleActivated = false;
	self.isActive = true;

	
	
    self.barreActive = true;
    self.ridensActive = false;
    self.ridbetActive = false;
    self.ridnormActive = true;
  
end;

function Leboulch:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	--load function	
    self.ridensActive =  Utils.getNoNil(getXMLBool(xmlFile, key.."#silage"),false);
    self.ridbetActive =  Utils.getNoNil(getXMLBool(xmlFile, key.."#betterave"),false);   
	
   
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Leboulch:getSaveAttributesAndNodes(nodeIdent)
	-- save function
	local silagetext='error';
	if self.ridensActive then
		silagetext='true';
	else
		silagetext='false';
	end;
        local bettext='error';
	if self.ridbetActive then
		bettext='true';
	else
		bettext='false';
	end;
    local attributes = 'silage="'..silagetext..'" betterave="'..bettext..'"';

   return attributes, nil;
end;

function Leboulch:delete()
   
end;

function Leboulch:mouseEvent(posX, posY, isDown, isUp, button)   
end;

function Leboulch:keyEvent(unicode, sym, modifier, isDown)
    
        
	 if isDown and sym == self.keys.lever and Trailer.TIPSTATE_CLOSED then 
        self.translationMaxverrin1 = not self.translationMaxverrin1;
        self.translationMaxverrin2 = not self.translationMaxverrin2;
        self.translationMaxverrin3 = not self.translationMaxverrin3;
        self.translationMaxverrin4 = not self.translationMaxverrin4;
        self.translationMaxverrin5 = not self.translationMaxverrin5;
        self.translationMaxverrin6 = not self.translationMaxverrin6;
        self.translationMaxverrin7 = not self.translationMaxverrin7;
		self.rotationMaxcaisse = not self.rotationMaxcaisse;
                self.rotationMaxchassis = not self.rotationMaxchassis;
        self.barreActive = not self.barreActive;
	end;

     if self.attacherVehicle ~= nil then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;

    
     
    
     if self.fillLevel == 0 and isDown and sym == self.keys.ridelle then 
       if self.ridnormActive == true then
           self.ridensActive = true;
           self.ridbetActive = false;
           self.ridnormActive = false;
       elseif self.ridensActive == true then
            self.ridensActive = false;
            self.ridbetActive = true;
            self.ridnormActive = false; 
       elseif self.ridbetActive == true then
           self.ridensActive = false;
           self.ridbetActive = false;
           self.ridnormActive = true; 
       end;
     end;


end;

function Leboulch:update(dt)


if self.rotationPartbequille ~= nil then
		local x, y, z = getRotation(self.rotationPartbequille.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbequille.maxRot, self.rotationPartbequille.minRot, 3, self.rotationPartbequille.rotTime, dt, not self.rotationMaxbequille);
		setRotation(self.rotationPartbequille.node, unpack(newRot));        
   end;
   
   if self.translationPartbequille1 ~= nil then
		local x, y, z = getTranslation(self.translationPartbequille1.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartbequille1.maxTrans, self.translationPartbequille1.minTrans, 3, self.translationPartbequille1.transTime, dt, not self.translationMaxbequille1);
		setTranslation(self.translationPartbequille1.node, unpack(newTrans));
	end;
	 
 if self.attacherVehicle ~= nil then
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;
  end;

 
 self.pipeParticleActivated = false;
	self.trailerFound = 0;	 
    if self.fillLevel > 0 and self.attacherVehicle ~= nil then
        local x,y,z = getWorldTranslation(self.trailerPosition);
        raycastAll(x, y, z, 4, -6, -6, "findTrailerRaycastCallback", 10, self);
       
		
        local trailer = g_currentMission.objectToTrailer[self.trailerFound];
				
        if self.trailerFound == 0 or not trailer:allowFillType(self.currentFillType, true) or not trailer.allowFillFromAir then
            self.pipeParticleActivated = false;			
        else
         if self.currentFillType == FruitUtil.FRUITTYPE_FERTILIZER and self.rotationMaxcaisse then
	            local deltaLevel = self.grainUnloading;
				if trailer ~= nil then
					deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);                                         	
				else
					deltaLevel = 0;
				end;

	            self.fillLevel = self.fillLevel-deltaLevel;
	            if self.fillLevel <= 0.0 then
	                deltaLevel = deltaLevel+self.fillLevel;
	                self.fillLevel = 0.0;
	                pipeParticleActivated = false;
	            end;
	            if deltaLevel == 0 then
	                self.pipeParticleActivated = false;
	            end;
	            self:setFillLevel(self.fillLevel, self.currentFillType);
				if trailer ~= nil then
					trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentFillType);
                                        self.pipeParticleActivated = true;                                                                                   
				end;
          end;
        end;
	
    end;

		if self.pipeParticleActivated then
		Utils.setEmittingState(self.pipeParticleSystem, true);
		else
		Utils.setEmittingState(self.pipeParticleSystem, false);
		end;

     if self.translationPartverrin1 ~= nil then
		local x, y, z = getTranslation(self.translationPartverrin1.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartverrin1.maxTrans, self.translationPartverrin1.minTrans, 3, self.translationPartverrin1.transTime, dt, not self.translationMaxverrin1);
		setTranslation(self.translationPartverrin1.node, unpack(newTrans));
	end;
       if self.translationPartverrin2 ~= nil then
		local x, y, z = getTranslation(self.translationPartverrin2.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartverrin2.maxTrans, self.translationPartverrin2.minTrans, 3, self.translationPartverrin2.transTime, dt, not self.translationMaxverrin2);
		setTranslation(self.translationPartverrin2.node, unpack(newTrans));
	end;
       if self.translationPartverrin3 ~= nil then
		local x, y, z = getTranslation(self.translationPartverrin3.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartverrin3.maxTrans, self.translationPartverrin3.minTrans, 3, self.translationPartverrin3.transTime, dt, not self.translationMaxverrin3);
		setTranslation(self.translationPartverrin3.node, unpack(newTrans));
	end;
       if self.translationPartverrin4 ~= nil then
		local x, y, z = getTranslation(self.translationPartverrin4.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartverrin4.maxTrans, self.translationPartverrin4.minTrans, 3, self.translationPartverrin4.transTime, dt, not self.translationMaxverrin4);
		setTranslation(self.translationPartverrin4.node, unpack(newTrans));
	end;

       if self.translationPartverrin5 ~= nil then
		local x, y, z = getTranslation(self.translationPartverrin5.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartverrin5.maxTrans, self.translationPartverrin5.minTrans, 3, self.translationPartverrin5.transTime, dt, not self.translationMaxverrin5);
		setTranslation(self.translationPartverrin5.node, unpack(newTrans));
	end;
       if self.translationPartverrin6 ~= nil then
		local x, y, z = getTranslation(self.translationPartverrin6.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartverrin6.maxTrans, self.translationPartverrin6.minTrans, 3, self.translationPartverrin6.transTime, dt, not self.translationMaxverrin6);
		setTranslation(self.translationPartverrin6.node, unpack(newTrans));
	end;
        if self.translationPartverrin7 ~= nil then
		local x, y, z = getTranslation(self.translationPartverrin7.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartverrin7.maxTrans, self.translationPartverrin7.minTrans, 3, self.translationPartverrin7.transTime, dt, not self.translationMaxverrin7);
		setTranslation(self.translationPartverrin7.node, unpack(newTrans));
	end;
     if self.rotationPartcaisse ~= nil then
		local x, y, z = getRotation(self.rotationPartcaisse.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartcaisse.maxRot, self.rotationPartcaisse.minRot, 3, self.rotationPartcaisse.rotTime, dt, not self.rotationMaxcaisse);
		setRotation(self.rotationPartcaisse.node, unpack(newRot));        
   end;
    if self.rotationPartchassis ~= nil then
		local x, y, z = getRotation(self.rotationPartchassis.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartchassis.maxRot, self.rotationPartchassis.minRot, 3, self.rotationPartchassis.rotTime, dt, not self.rotationMaxchassis);
		setRotation(self.rotationPartchassis.node, unpack(newRot));        
   end;

  
   if self.barreActive then			
				local barres = self.barre;
				setVisibility(barres, self.barreActive);			
		    else
     			local barres = self.barre;
				setVisibility(barres, self.barreActive, false);			
	end;
     if self.ridensActive then			
				local ridenss = self.ridens;
				setVisibility(ridenss, self.ridensActive);			
		    else
     			local ridenss = self.ridens;
				setVisibility(ridenss, self.ridensActive, false);			
	end;
       if self.ridbetActive then			
				local ridbets = self.ridbet;
				setVisibility(ridbets, self.ribetActive);			
		    else
     			local ridbets = self.ridbet;
				setVisibility(ridbets, self.ridbetActive, false);			
	end;
end;

function Leboulch:setFillLevel(fillLevel, fillType)
	Trailer.setFillLevel(self, fillLevel, fillType);
end;


function Leboulch:findTrailerRaycastCallback(transformId, x, y, z, distance)    
	  self.trailerFound = 0;	
    if getUserAttribute(transformId, "vehicleType") == 2 then
        self.trailerFound = transformId;
    end;
	
	
	
    return false;
end;

function Leboulch:draw()
   if self.attacherVehicle then
        g_currentMission:addExtraPrintText("Touche O : Allumer/Eteindre le girophare");
        g_currentMission:addExtraPrintText("Touche B : Lever/baisser la benne au champs");
        g_currentMission:addExtraPrintText("Touche X : Ajouter/enlever les ridelles");                   
	end;
 
  
end;

function Trailer:onAttach(attacherVehicle)
self.rotationMaxbequille = true;
self.translationMaxbequille1 = true;
end;

function Leboulch:onDetach()
    self.rotationMaxbequille = false;
    self.translationMaxbequille1 = false;
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
    
  
end;