


-- @author  Kyosho
-- @date  01/01/2011



MoveZylinder = {};

function MoveZylinder.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function MoveZylinder:load(xmlFile)

	self.moveableZylinder = {};
	self.moveableZylinder.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableZylinder#index"));
	self.moveableZylinder.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableZylinder#maxY"), 0); 
	self.moveableZylinder.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableZylinder#minY"), 0); 
	
end;

function MoveZylinder:delete()
end;

function MoveZylinder:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MoveZylinder:keyEvent(unicode, sym, modifier, isDown)

end;

function MoveZylinder:update(dt)

	if self.moveableZylinder ~= nil then
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableZylinder.index);
		local maxY = self.moveableZylinder.max;
		local minY = self.moveableZylinder.min;
		local moveSpeed = 0.0022;
			if InputBinding.isPressed(InputBinding.Zylinder_UP) then
				if yAttacher < maxY then
					yAttacher = yAttacher + moveSpeed;
				else
					yAttacher = maxY;
				end;
			elseif InputBinding.isPressed(InputBinding.Zylinder_DOWN) then
				if yAttacher > minY then
					yAttacher = yAttacher - moveSpeed;
				else
					yAttacher = minY;
				end;
			end;
		setTranslation(self.moveableZylinder.index, xAttacher, yAttacher, zAttacher);
	end;
				
end;

function MoveZylinder:onLeave()

end;

function MoveZylinder:draw()

end;

function MoveZylinder:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

