-- specialization for bag_pallet
-- original script by @author Felix "Outlaw" Sorge
-- revised by @author Unimog 411

bag_pallet = {};

function bag_pallet.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function bag_pallet:load(xmlFile)

	self.palletName = getXMLString(xmlFile, "vehicle.name.de");

	self.bagInRange = SpecializationUtil.callSpecializationsFunction("bagInRange");
	
	self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerSecond#value"), 1);
	
	self.chargeTypes = {};
	self.chargeTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
	local chargeTypes = getXMLString(xmlFile, "vehicle.chargeTypes#chargeTypes");
    if chargeTypes ~= nil then
		self.chargefillNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeTypes#fillNode"));
        local types = Utils.splitString(" ", chargeTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.chargeTypes[desc.index] = true;
				self:setFillLevel(1000, desc.index);
			end;
        end;
    end;
	
	
	self.bagBags = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.bags#count"), 0);
    self.bags = {};
    for i=1, self.bagBags do
        local bagnamei = string.format("vehicle.bags.bag%d", i);
        self.bags[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, bagnamei .. "#index"));
        setVisibility(self.bags[i], false);
		self.singleBag = 25;
    end;

	self.bagpallet = true;
	
end;

function bag_pallet:delete()
end;

function bag_pallet:mouseEvent(posX, posY, isDown, isUp, button)
end;

function bag_pallet:keyEvent(unicode, sym, modifier, isDown)
end;

function bag_pallet:update(dt)
					
	for chargeTypes,v in pairs(self.chargeTypes) do	
		if chargeTypes == self.currentFillType then
			if self.fillLevel ~= 0 then
				self:bagInRange(dt);
			end; 
		elseif self.fillLevel == 0 then
			self.turnOn = false;
			self:setFillLevel(0, FruitUtil.FRUITTYPE_UNKNOWN);
		end; 	
	end;

	if self.bags ~= nil then
		if self.fillLevel > 0 then
			for i = 1, self.bagBags do
				if i * self.singleBag-24 <= self.fillLevel then
					setVisibility(self.bags[i], true);
				else
				setVisibility(self.bags[i], false);
				end;
			end;
		end;
	end;

end;

function bag_pallet:draw()
end;

function bag_pallet:bagInRange(dt)

    local nearestDistance = 3.0;
	local px, py, pz = getWorldTranslation(self.chargefillNode);
	
	for i=1, table.getn(g_currentMission.attachables) do
		local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);

		if distance < nearestDistance then
			local attachable = g_currentMission.attachables[i];
			if not attachable.bagpallet and attachable.allowFillFromAir then
				if self.currentFillType == attachable.currentFillType or attachable.currentFillType == FruitUtil.FRUITTYPE_UNKNOWN then
					if attachable.rootNode ~= self.rootNode and attachable.setFillLevel ~= nil then
						if attachable.fillLevel == attachable.capacity  or self.filllevel == 0 then
								self.turnOn = false; 
							elseif attachable.fillLevel ~= attachable.capacity  and self.fillLevel ~= 0 then
								if self.turnOn then
									if self.currentFillType ~= FruitUtil.FRUITTYPE_PESTICIDE then
										g_currentMission:addExtraPrintText(string.format (InputBinding.getButtonKeyName(InputBinding.bag_pallet_ON)).. ": " ..g_i18n:getText("bag_pallet_2"));
										g_currentMission:addExtraPrintText(g_i18n:getText("bag_pallet_5") ..string.format(" %s: %.0f " , self.palletName, self.fillLevel).. "kg");
									else
										g_currentMission:addExtraPrintText(string.format (InputBinding.getButtonKeyName(InputBinding.bag_pallet_ON)).. ": " ..g_i18n:getText("bag_pallet_4"));
										g_currentMission:addExtraPrintText(g_i18n:getText("bag_pallet_5") ..string.format(" %s: %.0f " , self.palletName, self.fillLevel).. g_i18n:getText("bag_pallet_6"));
									end;
									if InputBinding.hasEvent(InputBinding.bag_pallet_ON) then
									self.turnOn = not self.turnOn; 
									end;
									local percent = self.fillLevel /self.capacity*100;	
									local deltaLevel = self.literPerSecond*dt/1000.0;
									deltaLevel = math.min(deltaLevel, attachable.capacity - attachable.fillLevel);
									self.fillLevel = self.fillLevel-deltaLevel;
									self:setFillLevel(self.fillLevel, self.currentFillType);
									attachable:setFillLevel(attachable.fillLevel + deltaLevel, self.currentFillType);			
								else
									if self.currentFillType ~= FruitUtil.FRUITTYPE_PESTICIDE then
										g_currentMission:addExtraPrintText(string.format (InputBinding.getButtonKeyName(InputBinding.bag_pallet_ON)).. ": " ..g_i18n:getText("bag_pallet_1"));
										g_currentMission:addExtraPrintText(g_i18n:getText("bag_pallet_5") ..string.format(" %s: %.0f " , self.palletName, self.fillLevel).. "kg");
									else
										g_currentMission:addExtraPrintText(string.format (InputBinding.getButtonKeyName(InputBinding.bag_pallet_ON)).. ": " ..g_i18n:getText("bag_pallet_3"));
										g_currentMission:addExtraPrintText(g_i18n:getText("bag_pallet_5") ..string.format(" %s: %.0f " , self.palletName, self.fillLevel).. g_i18n:getText("bag_pallet_6"));
									end;
									if InputBinding.hasEvent(InputBinding.bag_pallet_ON) then
										self.turnOn = not self.turnOn; 
									end;
								end;
						end;
					end;
				end;
			end;
		end;
    end;

end;

function bag_pallet:onAttach()
end; 	

function bag_pallet:onDetach()
end;