accensioneEvent = {};
accensioneEvent_mt = Class(accensioneEvent, Event);

InitEventClass(accensioneEvent, "accensioneEvent");

function accensioneEvent:emptyNew()
    local self = Event:new(accensioneEvent_mt);
    self.className="accensioneEvent";
    return self;
end;

function accensioneEvent:new(object, isRunning)
    local self = accensioneEvent:emptyNew()
    self.object = object;
	self.isRunning = isRunning;
    return self;
end;

function accensioneEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRunning = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function accensioneEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isRunning);
end;

function accensioneEvent:run(connection)
	self.object:invokeIgnition(self.isRunning);
    if not connection:getIsServer() then
        g_server:broadcastEvent(accensioneEvent:new(self.object, self.isRunning), nil, connection, self.object);
    end;	
end;

function accensioneEvent.sendEvent(vehicle, isRunning)
	if g_server ~= nil then
		g_server:broadcastEvent(accensioneEvent:new(vehicle, isRunning), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(accensioneEvent:new(vehicle, isRunning));
	end;
end;

