--
-- SDF
-- Specialization class for SDF group
--
-- @author  Ago-Systemtech
-- @date  17/11/2011
-- Copyright (C) Ago-Systemtech, All Rights Reserved.

SDFmod = {};

function SDFmod.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function SDFmod:load(xmlFile)
	
	---Panel--
	self.controlpath = Utils.getFilename("Textur/info.png", self.baseDirectory);
    self.helpPoxX = 0.70;
    self.helpPoxY = 0.22;
    self.helpWidth = 0.30;
    self.helpHeight = 0.66;
    self.helpOverlay = Overlay:new("info", self.controlpath, self.helpPoxX, self.helpPoxY, self.helpWidth, self.helpHeight);
    self.InfoAttiva = true;
	
	self.ledriserva = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ledriserva#index"));
	self.ledriservaActive = false;
	self.dualsActive = false;
	self.riserva = 100;
	self.prevousFuelPercentage = 0;

	self.duals = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.duals#index"));
	self.duals2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.duals#index2"));
	self.duals3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.duals#index3"));
	self.duals4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.duals#index4"));
	
	self.warning = {};
    self.warning[1] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.warning.warning1#index"));
    self.warning[2] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.warning.warning2#index"));
     
	
       --Hydraulic--
    self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.bottomArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArm"));
	self.frontAttacherJoint = {};
	self.frontAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#front"));

        --Parafanghi--
	self.fender = {};
	self.fender.leftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fender#leftIndex"));
	self.fender.rightNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fender#rightIndex"));
	self.fender.leftRotMax = getXMLInt(xmlFile, "vehicle.fender#leftRotMax");
	self.fender.rightRotMax = getXMLInt(xmlFile, "vehicle.fender#rightRotMax");
 
        --Inclinazione ruote--
    self.GommeLK = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Gommes.GommeLK#index"));
    self.GommeRK = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Gommes.GommeRK#index"));
    self.GommePoint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Gommes.GommePoint#index"));
	
	   --BGA silos--
     self.bunkerSiloCompactingScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.bunkerSiloCompacter#compactingScale"), 1);
     self.bunkerSiloCompactingRefNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bunkerSiloCompacter#refNode"));

	   
        --Power Shaft--
	local i=0;
    while true do
        local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;		
		local joint = self.attacherJoints[i+1];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		if shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
		i = i + 1;
	end;

	local attacherJointCount = i;
	i = 0;
    while true do
        local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
		
		local joint = self.attacherJoints[attacherJointCount + 1 + i];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		if shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
        i = i+1;
    end;
      --Power Shaft Fine--
	       
		   --Rpm control---
	    self.motor.minRpm = 200;
        self.motor.minRpm = 200;
    	
   
	local rotationPartNodeContagiri = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartContagiri#index"));
    if rotationPartNodeContagiri ~= nil then
        self.rotationPartContagiri = {};
        self.rotationPartContagiri.node = rotationPartNodeContagiri;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartContagiri#minRot"));
        self.rotationPartContagiri.minRot = {};
        self.rotationPartContagiri.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartContagiri.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartContagiri.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartContagiri#maxRot"));
        self.rotationPartContagiri.maxRot = {};
        self.rotationPartContagiri.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartContagiri.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartContagiri.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartContagiri.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartContagiri#rotTime"), 2)*1000;
        self.rotationPartContagiri.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartContagiri#touchRotLimit"), 10));
    end;
	
		
	local rotationPartNodeKmh1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;
	
		
	      -- Indicatori--
	local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
	
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
	
	

	
	fuelwarningSoundFile = Utils.getFilename("sound/fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
end;

function SDFmod:delete()

end;

function SDFmod:mouseEvent(posX, posY, isDown, isUp, button)

end;

function SDFmod:keyEvent(unicode, sym, modifier, isDown)
	
		
	
	if isDown and sym == Input.KEY_KP_0 then
		self.helpPanel = not self.helpPanel;
	end;
	   --Gomme gemellate--
	if isDown and sym == Input.KEY_space then
		self.dualsActive = not self.dualsActive;
	end;	
	 	--panel--
		if isDown and sym == Input.KEY_f12 then
		self.InfoAttiva = not self.InfoAttiva;
	end;
		--warning--
     if isDown and sym == Input.KEY_space then 
		self.drawwarning = not self.drawwarning;
		setVisibility(self.warning[1], self.drawwarning);
    	setVisibility(self.warning[2], self.drawwarning);
	end;
end;

function SDFmod:update(dt)
	


	    	    --pistoni sollevatore--
		for i=1,table.getn(self.movingParts) do
			Cylindered.updateMovingPart(self, self.movingParts[i]);
		end;
                  
				--parafanghi--
	    if self:getIsActive() then
		
		local x1,y1,z1 = getRotation(self.wheels[1].repr);
		if y1 < math.rad(self.fender.rightRotMax) then
			setRotation(self.fender.rightNode, 0, math.rad(10), 0);
		else
			setRotation(self.fender.rightNode, 0, 0, 0);
		end;
		
		local x2,y2,z2 = getRotation(self.wheels[2].repr);
		if y2 > math.rad(self.fender.leftRotMax) then
			setRotation(self.fender.leftNode, 0, math.rad(-10), 0);
		else
			setRotation(self.fender.leftNode, 0, 0, 0);
		end;
	
	end;
           			
			--Inclinazione ruote--
	if self:getIsActive() then
	    -- abgreifen der Rotation des Lenkrades und Teilung/ Berechnung fr die der Gomme
		self.GetRotRT, self.GetRotRTT, self.GetRotRTTT = getRotation(self.GommePoint)
		self.RotateF = (self.GetRotRTT /40)  -- <<-- der Wert (40) gibt die Teilung an, wird er grer fllt der Sturz schwcher aus, wird er kleiner wird der Sturz strker)
        -- setzt letztenendes die Rotation in die Tat um:
		setRotation(self.GommeLK, 0, 0, -self.RotateF)		
		setRotation(self.GommeRK, 0, 0, -self.RotateF)		   		
	end;
	     			
			--RPM control--
	if self:getIsActiveForInput() then
        if Input.isKeyPressed(Input.KEY_k) then
		    self.motor.minRpm = self.motor.minRpm - 100;
		elseif Input.isKeyPressed(Input.KEY_m) then
		    self.motor.minRpm = self.motor.minRpm + 100;
	    end;
    end;

    if self.isEntered then
		if self.motor.minRpm < -2400 then
			self.motor.minRpm = -1600;
		elseif self.motor.minRpm > 100 then
			self.motor.minRpm = 100;
		end;
	end;

	
          -- Indication ---
	if self.isMotorStarted then
		if self.rotationPartTanknadel ~= nil then
			local x, y, z = getRotation(self.rotationPartTanknadel.node);
			y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
			setRotation(self.rotationPartTanknadel.node, x, y ,z);
		end;

	else
		setRotation(self.rotationPartTanknadel.node, 0, 0 , 0);
	end;
	
		
  local maxContagiri = 2400;
  if self.isMotorStarted then
	if self.rotationPartContagiri ~= nil then
		local x, y, z = getRotation(self.rotationPartContagiri.node);
		y = ((self.rotationPartContagiri.maxRot[2] - self.rotationPartContagiri.minRot[2]) / maxContagiri) * self.motor.lastMotorRpm + self.rotationPartContagiri.minRot[2];
		setRotation(self.rotationPartContagiri.node, x, y ,z);
	end;
	else
		setRotation(self.rotationPartContagiri.node, 0, 0 , 0);
	end;
		
	local maxKmh = 68;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;

	
	if self.isEntered then
		if self.fuelFillLevel < 50 then
			self.riserva = self.riserva - dt;
			if self.riserva <= 0 then
				playSample(self.fuelwarningSoundId,1,1,0);
				self.riserva = 30000;
			end;
			self.ledriservaActive = true;
		else
			self.riserva = 30000;
			self.ledriservaActive = false;
		end;
		setVisibility(self.ledriserva,self.ledriservaActive);
	end;

	
	setVisibility(self.duals, self.dualsActive);
	setVisibility(self.duals2, self.dualsActive);
	setVisibility(self.duals3, self.dualsActive);
	setVisibility(self.duals4, self.dualsActive);

	
		
				--Hydraulic--
    if self:getIsActive() then
        if self.backHydraulic ~= nil then
			local x, y, z = getRotation(self.backHydraulic.bottomArm);
			setRotation(self.backHydraulic.rootArm, x, y, z);
		end;
	end;
		    
	   
end;

function SDFmod:draw()
      
	  if self.helpOverlay ~= nil then
		if self.InfoAttiva then
		self.helpOverlay:render();
		end;
	end;
		if self.InfoAttiva then	
			--g_currentMission:addExtraPrintText("Key F12: Info Off");
		else
			---g_currentMission:addExtraPrintText("Key F12: Info On");
		end;

	if self.isEntered then
		if not self.helpPanel then
			--renderText(0.72, 0.25, 0.02, "Tasto m: Info On");
		else
			--renderText(0.72, 0.25, 0.02, "Tasto m: Info Off");
		end;
		if self.helpPanel then
			renderText(0.02, 0.56, 0.023, "      - Same Diamond 300 Help -");
			renderText(0.02, 0.54, 0.021, "Prima di agganciare un rimorchio regolare l'altezza del gancio");
			renderText(0.02, 0.52, 0.021, "Before attaching a trailer to adjust the height of the hook");
			renderText(0.02, 0.50, 0.021, "Vor dem Anbringen eines Anhangers, die Hohe des Hakens.");
			renderText(0.02, 0.48, 0.021, "      ---------------------------------");
			renderText(0.02, 0.46, 0.021, "Il trattore lavabile e si sporca dopo circa un ora di gioco.");
			renderText(0.02, 0.44, 0.021, "Si puo lavare e si pulisce anche con la pioggia.");
			renderText(0.02, 0.42, 0.021, "The tractor is washable and it gets dirty after about an hour of play.");
			renderText(0.02, 0.40, 0.021, "You can wash and clean even with the rain.");
			renderText(0.02, 0.38, 0.021, "Der Traktor ist waschbar und es wird schmutzig nach etwa einer Stunde zu spielen.");
			renderText(0.02, 0.36, 0.021, "Sie konnen waschen und zu reinigen, auch mit dem regen.");
			renderText(0.02, 0.34, 0.021, "      ---------------------------------");
			renderText(0.02, 0.32, 0.021, "Per usare il limitatore di giri ESLimiter, premere i tasti Pgup/Pgdown");
			renderText(0.02, 0.30, 0.021, "To use the rev limiter ESLimiter, press the PgUp / PgDown");
			renderText(0.02, 0.28, 0.021, "Zur Verwendung der Drehzahlbegrenzer ESLimiter, drucken Sie die Bild auf / Bild ab");
			renderText(0.02, 0.26, 0.021, "      ---------------------------------");
			renderText(0.02, 0.24, 0.021, "Grazie per aver scelto una mia mod-Thank you for my mod-Vielen Dank fur meine mod");
			renderText(0.02, 0.22, 0.021, "Support, TRACTOR ITALIA FORUM: http://forum.tractor-italia.net");
			renderText(0.02, 0.20, 0.021, "ATTENZIONE VIETATO FARE MODIFICHE-ATTENTION, FORBIDDEN TO DO CHANGES.");
			renderText(0.02, 0.18, 0.021, "Creative Commons license, by Ago-Systemtech");
		end;
	end;
	
	
end;

function SDFmod:onEnter()
	
end;

function SDFmod:onLeave()

end;
