--
-- Dangreville
--
-- 23/10/09 guimchevalier from TSF3 www.tsforum3.com 

Dangreville = {};

function Dangreville.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Dangreville:load(xmlFile)
	-- Anim
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
  	self.charId = {};
	self.clipIndex = {};
	self.charSet = {};
	self.Go = {}; 
	self.Done = {};
	self.CheckDone = {};
	local partname = "vehicle.supportAnimation";
	local nameR = "support";
	local xmlString = getXMLString(xmlFile, partname.."#rootNode");
	self.charId[nameR] = Utils.indexToObject(self.components, xmlString);
	self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#clip");
	self.CheckDone[nameR] = false;
	self.Go[nameR] = false;
	self.Done[nameR] = false;
end;

function Dangreville:delete()
end;

function Dangreville:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Dangreville:keyEvent(unicode, sym, modifier, isDown)
end;

function Dangreville:update(dt)
	self:anim("support",false);
end;

function Dangreville:draw()
end;

function Dangreville:onAttach()
	self.Go.support = not self.Go.support;
	self.Done.support = true;
 end;
 
function Dangreville:onDetach()
	self.Go.support = not self.Go.support;
	self.Done.support = true;
 end;
 
function Dangreville:anim(varName, loopCheck)
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;		
			self.CheckDone[varName] = true;	
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
		end;
	end;
end; 