--
-- lsfarmingv1
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

lsfarmingv1 = {}

local lsfarmingv1_mt = Class(lsfarmingv1, Mission00);

function lsfarmingv1:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = lsfarmingv1_mt;
    end;
    local self = lsfarmingv1:superClass():new(baseDirectory, mt);
    return self;
end;

function lsfarmingv1:delete()
    lsfarmingv1:superClass().delete(self);
end;

function lsfarmingv1:load()
    self.environment = Environment:new(Utils.getFilename("sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));     
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.dds", self.baseDirectory));
    
    lsfarmingv1:superClass().load(self);
end
function lsfarmingv1:loadFinished()
    lsfarmingv1:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function lsfarmingv1:mouseEvent(posX, posY, isDown, isUp, button)
    lsfarmingv1:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function lsfarmingv1:keyEvent(unicode, sym, modifier, isDown)
    lsfarmingv1:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function lsfarmingv1:update(dt)
    lsfarmingv1:superClass().update(self, dt);
end;

function lsfarmingv1:draw()
    lsfarmingv1:superClass().draw(self);
end;
