--
-- SampleModMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);

function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);
    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
       
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
	
		kreisel = Utils.getFilename("pda/3.png", self.baseDirectory);
		kuh = Utils.getFilename("pda/2.png", self.baseDirectory);
		bga = Utils.getFilename("pda/4.png", self.baseDirectory);
		landhandel = Utils.getFilename("pda/1.png", self.baseDirectory);
		
		-- create Map Hotspot
		self.missionPDA:createMapHotspot("Kreisel", kreisel, 1384, 835, 0.021, 0.021, false, false, 0);
		
		-- create Map Hotspot
		self.missionPDA:createMapHotspot("Kuhweide", kuh, 1174, 271, 0.021, 0.021, false, false, 0);
		
		-- create Map Hotspot
		self.missionPDA:createMapHotspot("Landhandel", landhandel, 1867, 933, 0.021, 0.021, false, false, 0);
		
		-- create Map Hotspot
		self.missionPDA:createMapHotspot("Biogasanlage", bga, 1762, 1035, 0.021, 0.021, false, false, 0);

    
    SampleModMap:superClass().load(self);
end
function SampleModMap:loadFinished()
    SampleModMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;
