--
-- www.ls-uk.info
-- LS UK Modteam
--
-- Henly20
-- date  20/11/2010
-- Worklights For Implements 

JDFHWorklights = {};

function JDFHWorklights.prerequisitesPresent(specializations)
     return true;
end;



function JDFHWorklights:load(xmlFile)

	self.setWorkLightsVisibility = SpecializationUtil.callSpecializationsFunction("setWorkLightsVisibility");

    self.workLights = {};
    local i = 0;
    while true do
          local key = string.format("vehicle.workLights.workLight(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, false);
              table.insert(self.workLights, node);
          end;
          i = i + 1;
    end;
	  
    self.worklightCones = {};
    local i = 0;
    while true do
          local key = string.format("vehicle.worklightCones.worklightCone(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#index"));
          if node ~= nil then
              setVisibility(node, false);
              table.insert(self.worklightCones, node);
          end;
          i = i + 1;
    end;
	  
	self.workLightsActive = false;
    self.realWorkLightsActive = false;
    self.worklightConesActive = false;
end;

function JDFHWorklights:delete()

end;

function JDFHWorklights:readStream(streamId, connection)
	
end;

function JDFHWorklights:writeStream(streamId, connection)
	
end;

function JDFHWorklights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JDFHWorklights:keyEvent(unicode, sym, modifier, isDown)
end;

function JDFHWorklights:update(dt)

      if self:getIsActiveForInput() and self.isClient then
          if InputBinding.hasEvent(InputBinding.JDFHSPOTS) then
              if (not self.toggleLightsSound) then
                  self.toggleLightsSound = createSample("toggleLightsSound");
                  loadSample(self.toggleLightsSound, "dataS2/sounds/switchFlashlight.wav", false);
                  setSamplePitch(self.toggleLightsSound, 0.5);
              end;
              playSample(self.toggleLightsSound, 1, 1.0, 0);
              self:setWorkLightsVisibility(not self.workLightsActive);
          end;
	end;
	
		local realWorkLightsActive = false;
        local worklightConesActive = false;
        if self:getIsActiveForSound() then
              realWorkLightsActive = self.workLightsActive;
        else
              worklightConesActive = self.workLightsActive;
        end;

        if worklightConesActive ~= self.worklightConesActive then
            self.worklightConesActive = worklightConesActive;
            for _, worklightCone in pairs(self.worklightCones) do
                  setVisibility(worklightCone, worklightConesActive);
            end;
        end;
end;

function JDFHWorklights:updateTick(dt)

end;

function JDFHWorklights:onLeave()
      if self.deactivateOnLeave then
         JDFHWorklights.onDeactivate(self);
      end;
end;

function JDFHWorklights:onDeactivate()     
	self:setWorkLightsVisibility(false,true);
	
end;

function JDFHWorklights:onDetach()
	self:setWorkLightsVisibility(false,true);
end;

function JDFHWorklights:draw()


end;

function JDFHWorklights:setWorkLightsVisibility(visibility, noEventSend)
      if visibility ~= self.workLightsActive then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetWorkLightsEvent:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(SetWorkLightsEvent:new(self, visibility));
              end;
          end;
  
          self.workLightsActive = visibility;
		  
		  
          if not visibility or self:getIsActiveForSound() then  
              self.realWorkLightsActive = visibility;
			  for _, workLight in pairs(self.workLights) do
				 setVisibility(workLight, visibility);
			  end;
          end;
          for _,v in pairs(self.specializations) do
              if v.setWorkLightsVisibility ~= nil then
                 v.setWorkLightsVisibility(self, visibility);
              end;
          end;
          for _, worklightCone in pairs(self.worklightCones) do
              setVisibility(worklightCone, false);
          end;
      end;

end;

SetWorkLightsEvent = {};
SetWorkLightsEvent_mt = Class(SetWorkLightsEvent, Event);

InitEventClass(SetWorkLightsEvent, "SetWorkLightsEvent");

function SetWorkLightsEvent:emptyNew()
      local self = Event:new(SetWorkLightsEvent_mt);
      self.className="SetWorkLightsEvent";
      return self;
end;

function SetWorkLightsEvent:new(vehicle, visibility)
      local self = SetWorkLightsEvent:emptyNew()
      self.visibility = visibility;
      self.vehicle = vehicle;
      return self;
end;

function SetWorkLightsEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.visibility = streamReadBool(streamId);
      self.vehicle = networkGetObject(id);
      self:run(connection);
 end;

function SetWorkLightsEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
      streamWriteBool(streamId, self.visibility);
end;

function SetWorkLightsEvent:run(connection)
      self.vehicle:setWorkLightsVisibility(self.visibility, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetWorkLightsEvent:new(self.vehicle, self.visibility), nil, connection, self.vehicle);
      end;
end;