--
-- PFM Z341
-- author: Burner
-- 

Z341 = {};

function Z341.prerequisitesPresent(specializations)
   return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function Z341:load(xmlFile)
	self.av = {};
	self.threshingScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingScale#value"), 1);
	self.threshingParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.threshingParticleSystems.threshingParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end;
		local isStatic = Utils.getNoNil(getXMLBool(xmlFile, namei.."#static"), false);
		if isStatic then
			StaticParticleSystem.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		else
			Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		end;
		Utils.setEmittingState(self.threshingParticleSystems,false);
		i = i +1;		
    end;
end;

function Z341:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Z341:keyEvent(unicode, sym, modifier, isDown)
end;

function Z341:update(dt)
end;

function Z341:draw()
end;

function Z341:onAttach(attacherVehicle)
	self.av = attacherVehicle;
	attacherVehicle.threshingScale = self.threshingScale;
end;

function Z341:onDetach()
	self.av.threshingScale = 1;
end;

function Z341:delete()
end;