RitchieBaleRightEvent = {};
RitchieBaleRightEvent_mt = Class(RitchieBaleRightEvent, Event);

InitEventClass(RitchieBaleRightEvent, "RitchieBaleRightEvent");

function RitchieBaleRightEvent:emptyNew()
    local self = Event:new(RitchieBaleRightEvent_mt);
    self.className="RitchieBaleRightEvent";

    return self;
end;

function RitchieBaleRightEvent:new(vehicle, baleId)
    local self = RitchieBaleRightEvent:emptyNew()
    self.vehicle = vehicle;
	self.baleId = baleId;

    return self;
end;

function RitchieBaleRightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);

    self.baleId = streamReadInt32(streamId);

    self.vehicle = networkGetObject(id);

    self:run(connection);
end;

function RitchieBaleRightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));

	streamWriteInt32(streamId, self.baleId);
end;

function RitchieBaleRightEvent:run(connection)
	self.vehicle:setBaleRight(self.baleId, true);

	if not connection:getIsServer() then
		g_server:broadcastEvent(RitchieBaleRightEvent:new(self.vehicle, self.baleId), nil, connection, self.object);
	end;
end;

function RitchieBaleRightEvent.sendEvent(vehicle, baleId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RitchieBaleRightEvent:new(vehicle, baleId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(RitchieBaleRightEvent:new(vehicle, baleId));
		end;
	end;
end;