RitchieBaleRight3Event = {};
RitchieBaleRight3Event_mt = Class(RitchieBaleRight3Event, Event);

InitEventClass(RitchieBaleRight3Event, "RitchieBaleRight3Event");

function RitchieBaleRight3Event:emptyNew()
    local self = Event:new(RitchieBaleRight3Event_mt);
    self.className="RitchieBaleRight3Event";

    return self;
end;

function RitchieBaleRight3Event:new(vehicle, baleId)
    local self = RitchieBaleRight3Event:emptyNew()
    self.vehicle = vehicle;
	self.baleId = baleId;

    return self;
end;

function RitchieBaleRight3Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);

    self.baleId = streamReadInt32(streamId);

    self.vehicle = networkGetObject(id);

    self:run(connection);
end;

function RitchieBaleRight3Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));

	streamWriteInt32(streamId, self.baleId);
end;

function RitchieBaleRight3Event:run(connection)
	self.vehicle:setBaleRight3(self.baleId, true);

	if not connection:getIsServer() then
		g_server:broadcastEvent(RitchieBaleRight3Event:new(self.vehicle, self.baleId), nil, connection, self.object);
	end;
end;

function RitchieBaleRight3Event.sendEvent(vehicle, baleId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RitchieBaleRight3Event:new(vehicle, baleId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(RitchieBaleRight3Event:new(vehicle, baleId));
		end;
	end;
end;