RitchieBaleRight1Event = {};
RitchieBaleRight1Event_mt = Class(RitchieBaleRight1Event, Event);

InitEventClass(RitchieBaleRight1Event, "RitchieBaleRight1Event");

function RitchieBaleRight1Event:emptyNew()
    local self = Event:new(RitchieBaleRight1Event_mt);
    self.className="RitchieBaleRight1Event";

    return self;
end;

function RitchieBaleRight1Event:new(vehicle, baleId)
    local self = RitchieBaleRight1Event:emptyNew()
    self.vehicle = vehicle;
	self.baleId = baleId;

    return self;
end;

function RitchieBaleRight1Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);

    self.baleId = streamReadInt32(streamId);

    self.vehicle = networkGetObject(id);

    self:run(connection);
end;

function RitchieBaleRight1Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));

	streamWriteInt32(streamId, self.baleId);
end;

function RitchieBaleRight1Event:run(connection)
	self.vehicle:setBaleRight1(self.baleId, true);

	if not connection:getIsServer() then
		g_server:broadcastEvent(RitchieBaleRight1Event:new(self.vehicle, self.baleId), nil, connection, self.object);
	end;
end;

function RitchieBaleRight1Event.sendEvent(vehicle, baleId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RitchieBaleRight1Event:new(vehicle, baleId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(RitchieBaleRight1Event:new(vehicle, baleId));
		end;
	end;
end;